/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public interface RaftServerConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerConfigKeys.class);
    public static final String PREFIX = "raft.server";
    public static final String STORAGE_DIR_KEY = "raft.server.storage.dir";
    public static final List<File> STORAGE_DIR_DEFAULT = Collections.singletonList(new File("/tmp/raft-server/"));
    public static final String SLEEP_DEVIATION_THRESHOLD_KEY = "raft.server.sleep.deviation.threshold";
    public static final int SLEEP_DEVIATION_THRESHOLD_DEFAULT = 300;
    public static final String STAGING_CATCHUP_GAP_KEY = "raft.server.staging.catchup.gap";
    public static final int STAGING_CATCHUP_GAP_DEFAULT = 1000;

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).info(arg_0);
    }

    public static List<File> storageDir(RaftProperties properties) {
        return ConfUtils.getFiles((arg_0, arg_1) -> ((RaftProperties)properties).getFiles(arg_0, arg_1), (String)"raft.server.storage.dir", (List)STORAGE_DIR_DEFAULT, (Consumer)RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setStorageDir(RaftProperties properties, List<File> storageDir) {
        ConfUtils.setFiles((arg_0, arg_1) -> ((RaftProperties)properties).setFiles(arg_0, arg_1), (String)"raft.server.storage.dir", storageDir, (BiConsumer[])new BiConsumer[0]);
    }

    public static int sleepDeviationThreshold(RaftProperties properties) {
        return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)"raft.server.sleep.deviation.threshold", (int)300, (Consumer)RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setSleepDeviationThreshold(RaftProperties properties, int thresholdMs) {
        ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)"raft.server.sleep.deviation.threshold", (int)thresholdMs, (BiConsumer[])new BiConsumer[0]);
    }

    public static int stagingCatchupGap(RaftProperties properties) {
        return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)"raft.server.staging.catchup.gap", (int)1000, (Consumer)RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
    }

    public static void setStagingCatchupGap(RaftProperties properties, int stagingCatchupGap) {
        ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)"raft.server.staging.catchup.gap", (int)stagingCatchupGap, (BiConsumer[])new BiConsumer[0]);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftServerConfigKeys.class);
    }
}

