/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowerInfo {
    public static final Logger LOG = LoggerFactory.getLogger(FollowerInfo.class);
    private final String name;
    private final Consumer<Object> infoIndexChange;
    private final Consumer<Object> debugIndexChange;
    private final RaftPeer peer;
    private final AtomicReference<Timestamp> lastRpcResponseTime;
    private final AtomicReference<Timestamp> lastRpcSendTime;
    private final RaftLogIndex nextIndex;
    private final RaftLogIndex matchIndex = new RaftLogIndex((Object)"matchIndex", 0L);
    private final RaftLogIndex commitIndex = new RaftLogIndex((Object)"commitIndex", -1L);
    private final RaftLogIndex snapshotIndex = new RaftLogIndex((Object)"snapshotIndex", 0L);
    private volatile boolean attendVote;
    private final int rpcSlownessTimeoutMs;

    FollowerInfo(RaftGroupMemberId id, RaftPeer peer, Timestamp lastRpcTime, long nextIndex, boolean attendVote, int rpcSlownessTimeoutMs) {
        this.name = id + "->" + peer.getId();
        this.infoIndexChange = s -> LOG.info("{}: {}", (Object)this.name, s);
        this.debugIndexChange = s -> LOG.debug("{}: {}", (Object)this.name, s);
        this.peer = peer;
        this.lastRpcResponseTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastRpcSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.nextIndex = new RaftLogIndex((Object)"nextIndex", nextIndex);
        this.attendVote = attendVote;
        this.rpcSlownessTimeoutMs = rpcSlownessTimeoutMs;
    }

    public long getMatchIndex() {
        return this.matchIndex.get();
    }

    public boolean updateMatchIndex(long newMatchIndex) {
        return this.matchIndex.updateToMax(newMatchIndex, this.debugIndexChange);
    }

    long getCommitIndex() {
        return this.commitIndex.get();
    }

    boolean updateCommitIndex(long newCommitIndex) {
        return this.commitIndex.updateToMax(newCommitIndex, this.debugIndexChange);
    }

    long getSnapshotIndex() {
        return this.snapshotIndex.get();
    }

    public long getNextIndex() {
        return this.nextIndex.get();
    }

    public void increaseNextIndex(long newNextIndex) {
        this.nextIndex.updateIncreasingly(newNextIndex, this.debugIndexChange);
    }

    public void decreaseNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> old <= 0L ? old : Math.min(old - 1L, newNextIndex), this.infoIndexChange);
    }

    public void updateNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> newNextIndex >= 0L ? newNextIndex : old, this.infoIndexChange);
    }

    public void updateNextIndexToMax(long newNextIndex) {
        this.nextIndex.updateToMax(newNextIndex, this.infoIndexChange);
    }

    public void setSnapshotIndex(long newSnapshotIndex) {
        this.snapshotIndex.setUnconditionally(newSnapshotIndex, this.infoIndexChange);
        this.matchIndex.setUnconditionally(newSnapshotIndex, this.infoIndexChange);
        this.nextIndex.setUnconditionally(newSnapshotIndex + 1L, this.infoIndexChange);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(c" + this.getCommitIndex() + ",m" + this.getMatchIndex() + ",n" + this.getNextIndex() + ", attendVote=" + this.attendVote + ", lastRpcSendTime=" + ((Timestamp)this.lastRpcSendTime.get()).elapsedTimeMs() + ", lastRpcResponseTime=" + ((Timestamp)this.lastRpcResponseTime.get()).elapsedTimeMs() + ")";
    }

    void startAttendVote() {
        this.attendVote = true;
    }

    boolean isAttendingVote() {
        return this.attendVote;
    }

    public RaftPeer getPeer() {
        return this.peer;
    }

    public void updateLastRpcResponseTime() {
        this.lastRpcResponseTime.set(Timestamp.currentTime());
    }

    Timestamp getLastRpcResponseTime() {
        return (Timestamp)this.lastRpcResponseTime.get();
    }

    public void updateLastRpcSendTime() {
        this.lastRpcSendTime.set(Timestamp.currentTime());
    }

    public Timestamp getLastRpcTime() {
        return Timestamp.latest((Timestamp)((Timestamp)this.lastRpcResponseTime.get()), (Timestamp)((Timestamp)this.lastRpcSendTime.get()));
    }

    boolean isSlow() {
        return ((Timestamp)this.lastRpcResponseTime.get()).elapsedTimeMs() > (long)this.rpcSlownessTimeoutMs;
    }
}

