/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.AlreadyExistsException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.function.CheckedBiConsumer;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class GroupManagementBaseTest
extends BaseTest {
    static final Logger LOG = LoggerFactory.getLogger(GroupManagementBaseTest.class);
    static final RaftProperties prop = new RaftProperties();
    static final CheckedBiConsumer<MiniRaftCluster, RaftGroup, RuntimeException> NOOP = (c, g) -> {};

    public GroupManagementBaseTest() {
        Log4jUtils.setLogLevel((Logger)RaftServerProxy.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftServerImpl.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    public abstract MiniRaftCluster.Factory<? extends MiniRaftCluster> getClusterFactory();

    public MiniRaftCluster getCluster(int peerNum) throws IOException {
        return this.getClusterFactory().newCluster(peerNum, prop);
    }

    @Test
    public void testSingleGroupRestart() throws Exception {
        MiniRaftCluster cluster = this.getCluster(0);
        LOG.info("Start testMultiGroup" + cluster.printServers());
        List<RaftPeerId> ids = Arrays.stream(MiniRaftCluster.generateIds((int)3, (int)0)).map(RaftPeerId::valueOf).collect(Collectors.toList());
        ids.forEach(id -> cluster.putNewServer(id, null, true));
        LOG.info("putNewServer: " + cluster.printServers());
        cluster.start();
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("start: " + cluster.printServers());
        Assert.assertNull((Object)cluster.getLeader());
        RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (Collection)cluster.getPeers());
        LOG.info("add new group: " + newGroup);
        try (RaftClient client = cluster.createClient(newGroup);){
            for (RaftPeer p : newGroup.getPeers()) {
                client.groupAdd(newGroup, p.getId());
            }
        }
        Assert.assertNotNull((Object)RaftTestUtil.waitForLeader((MiniRaftCluster)cluster));
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("restart servers");
        for (RaftPeer p : newGroup.getPeers()) {
            cluster.restartServer(p.getId(), null, false);
        }
        Assert.assertNotNull((Object)RaftTestUtil.waitForLeader((MiniRaftCluster)cluster));
        cluster.shutdown();
    }

    @Test
    public void testMultiGroup5Nodes() throws Exception {
        int[] idIndex = new int[]{3, 4, 5};
        this.runMultiGroupTest(idIndex, 0);
    }

    @Test
    public void testMultiGroup7Nodes() throws Exception {
        int[] idIndex = new int[]{1, 6, 7};
        this.runMultiGroupTest(idIndex, 1);
    }

    @Test
    public void testMultiGroup9Nodes() throws Exception {
        int[] idIndex = new int[]{5, 8, 9};
        this.runMultiGroupTest(idIndex, 2);
    }

    private void runMultiGroupTest(int[] idIndex, int chosen) throws Exception {
        GroupManagementBaseTest.printThreadCount(null, (String)"init");
        GroupManagementBaseTest.runMultiGroupTest((MiniRaftCluster)this.getCluster(0), (int[])idIndex, (int)chosen, (CheckedBiConsumer)NOOP);
    }

    public static <T extends Throwable> void runMultiGroupTest(MiniRaftCluster cluster, int[] idIndex, int chosen, CheckedBiConsumer<MiniRaftCluster, RaftGroup, T> checker) throws IOException, InterruptedException, T {
        int i;
        if (chosen < 0) {
            chosen = ThreadLocalRandom.current().nextInt(idIndex.length);
        }
        String type = cluster.getClass().getSimpleName() + Arrays.toString(idIndex) + "chosen=" + chosen;
        LOG.info("\n\nrunMultiGroupTest with " + type + ": " + cluster.printServers());
        RaftGroup emptyGroup = RaftGroup.valueOf((RaftGroupId)cluster.getGroupId(), (RaftPeer[])new RaftPeer[0]);
        List<RaftPeerId> ids = Arrays.stream(MiniRaftCluster.generateIds((int)idIndex[idIndex.length - 1], (int)0)).map(RaftPeerId::valueOf).collect(Collectors.toList());
        LOG.info("ids: " + ids);
        ids.forEach(id -> cluster.putNewServer(id, emptyGroup, true));
        LOG.info("putNewServer: " + cluster.printServers());
        TimeUnit.SECONDS.sleep(1L);
        cluster.start();
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("start: " + cluster.printServers());
        Assert.assertNull((Object)cluster.getLeader());
        List allPeers = cluster.getPeers();
        Collections.sort(allPeers, Comparator.comparing(p -> p.getId().toString()));
        RaftGroup[] groups = new RaftGroup[idIndex.length];
        for (i = 0; i < idIndex.length; ++i) {
            RaftGroupId gid = RaftGroupId.randomId();
            int previous = i == 0 ? 0 : idIndex[i - 1];
            RaftPeer[] peers = allPeers.subList(previous, idIndex[i]).toArray(RaftPeer.emptyArray());
            groups[i] = RaftGroup.valueOf((RaftGroupId)gid, (RaftPeer[])peers);
            LOG.info(i + ") starting " + groups[i]);
            for (RaftPeer p2 : peers) {
                try (RaftClient client = cluster.createClient(p2.getId(), emptyGroup);){
                    client.groupAdd(groups[i], p2.getId());
                }
            }
            Assert.assertNotNull((Object)RaftTestUtil.waitForLeader((MiniRaftCluster)cluster, (RaftGroupId)gid));
            checker.accept((Object)cluster, (Object)groups[i]);
        }
        GroupManagementBaseTest.printThreadCount((String)type, (String)"start groups");
        LOG.info("start groups: " + cluster.printServers());
        LOG.info("chosen = " + chosen + ", " + groups[chosen]);
        for (i = 0; i < groups.length; ++i) {
            if (i == chosen) continue;
            RaftGroup g = groups[i];
            LOG.info(i + ") close " + cluster.printServers(g.getGroupId()));
            for (RaftPeer p3 : g.getPeers()) {
                RaftClientReply r;
                File root = cluster.getServer(p3.getId()).getImpl(g.getGroupId()).getState().getStorage().getStorageDir().getRoot();
                Assert.assertTrue((boolean)root.exists());
                Assert.assertTrue((boolean)root.isDirectory());
                try (RaftClient client = cluster.createClient(p3.getId(), g);){
                    r = client.groupRemove(g.getGroupId(), true, p3.getId());
                }
                Assert.assertTrue((boolean)r.isSuccess());
                Assert.assertFalse((boolean)root.exists());
            }
        }
        GroupManagementBaseTest.printThreadCount((String)type, (String)"close groups");
        LOG.info("close groups: " + cluster.printServers());
        RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)groups[chosen].getGroupId(), (RaftPeer[])new RaftPeer[0]);
        for (int i2 = 0; i2 < groups.length; ++i2) {
            if (i2 == chosen) continue;
            LOG.info(i2 + ") groupAdd: " + cluster.printServers(groups[i2].getGroupId()));
            for (RaftPeer p3 : groups[i2].getPeers()) {
                RaftClient client = cluster.createClient(p3.getId(), groups[i2]);
                Throwable throwable = null;
                try {
                    client.groupAdd(newGroup, p3.getId());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
        }
        LOG.info(chosen + ") setConfiguration: " + cluster.printServers(groups[chosen].getGroupId()));
        try (RaftClient client = cluster.createClient(groups[chosen]);){
            client.setConfiguration(allPeers.toArray(RaftPeer.emptyArray()));
        }
        Assert.assertNotNull((Object)RaftTestUtil.waitForLeader((MiniRaftCluster)cluster));
        checker.accept((Object)cluster, (Object)groups[chosen]);
        LOG.info("update groups: " + cluster.printServers());
        GroupManagementBaseTest.printThreadCount((String)type, (String)"update groups");
        cluster.shutdown();
        GroupManagementBaseTest.printThreadCount((String)type, (String)"shutdown");
    }

    static void printThreadCount(String type, String label) {
        System.out.println("| " + type + " | " + label + " | " + JavaUtils.getRootThreadGroup().activeCount() + " |");
    }

    @Test
    public void testGroupAlreadyExists() throws Exception {
        MiniRaftCluster cluster = this.getCluster(1);
        cluster.start();
        RaftPeer peer = (RaftPeer)cluster.getPeers().get(0);
        RaftPeerId peerId = peer.getId();
        RaftGroup group = RaftGroup.valueOf((RaftGroupId)cluster.getGroupId(), (RaftPeer[])new RaftPeer[]{peer});
        try (RaftClient client = cluster.createClient();){
            Assert.assertEquals((Object)group, (Object)cluster.getRaftServerImpl(peerId).getGroup());
            try {
                client.groupAdd(group, peer.getId());
            }
            catch (IOException ex) {
                Assert.assertTrue((boolean)ex.toString().contains(AlreadyExistsException.class.getCanonicalName()));
            }
            Assert.assertEquals((Object)group, (Object)cluster.getRaftServerImpl(peerId).getGroup());
            cluster.shutdown();
        }
    }
}

