/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class LeaderElection
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(LeaderElection.class);
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final String name;
    private final LifeCycle lifeCycle;
    private final Daemon daemon;
    private final RaftServerImpl server;

    private ResultAndTerm logAndReturn(Result result, Map<RaftPeerId, RaftProtos.RequestVoteReplyProto> responses, List<Exception> exceptions, long newTerm) {
        LOG.info(this + ": Election " + result + "; received " + responses.size() + " response(s) " + responses.values().stream().map(ServerProtoUtils::toString).collect(Collectors.toList()) + " and " + exceptions.size() + " exception(s); " + this.server.getState());
        int i = 0;
        for (Exception e : exceptions) {
            int j = i++;
            LogUtils.infoOrTrace((Logger)LOG, () -> "  Exception " + j, (Throwable)e);
        }
        return new ResultAndTerm(result, newTerm);
    }

    LeaderElection(RaftServerImpl server) {
        this.name = server.getMemberId() + "-" + this.getClass().getSimpleName() + COUNT.incrementAndGet();
        this.lifeCycle = new LifeCycle((Object)this);
        this.daemon = new Daemon((Runnable)this);
        this.server = server;
    }

    void start() {
        this.startIfNew(() -> this.daemon.start());
    }

    @VisibleForTesting
    void startInForeground() {
        this.startIfNew((Runnable)this);
    }

    private void startIfNew(Runnable starter) {
        if (this.lifeCycle.compareAndTransition(LifeCycle.State.NEW, LifeCycle.State.STARTING)) {
            starter.run();
        } else {
            LifeCycle.State state = this.lifeCycle.getCurrentState();
            LOG.info("{}: skip starting since this is already {}", (Object)this, (Object)state);
        }
    }

    void shutdown() {
        this.lifeCycle.checkStateAndClose();
    }

    @VisibleForTesting
    LifeCycle.State getCurrentState() {
        return this.lifeCycle.getCurrentState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING)) {
            LifeCycle.State state = this.lifeCycle.getCurrentState();
            LOG.info("{}: skip running since this is already {}", (Object)this, (Object)state);
            return;
        }
        Timestamp electionStartTime = Timestamp.currentTime();
        try {
            this.askForVotes();
        }
        catch (Throwable e) {
            LifeCycle.State state = this.lifeCycle.getCurrentState();
            if (state.isClosingOrClosed()) {
                LOG.info("{}: {} is safely ignored since this is already {}", new Object[]{this, e.getClass().getSimpleName(), state, e});
            } else {
                if (!this.server.isAlive()) {
                    LOG.info("{}: {} is safely ignored since the server is not alive: {}", new Object[]{this, e.getClass().getSimpleName(), this.server, e});
                } else {
                    LOG.error("{}: Failed, state={}", new Object[]{this, state, e});
                }
                this.shutdown();
            }
        }
        finally {
            this.server.getLeaderElectionMetrics().onLeaderElectionCompletion(electionStartTime.elapsedTimeMs());
            this.lifeCycle.checkStateAndClose(() -> {});
        }
    }

    private boolean shouldRun() {
        return this.lifeCycle.getCurrentState().isRunning() && this.server.isCandidate() && this.server.isAlive();
    }

    private boolean shouldRun(long electionTerm) {
        return this.shouldRun() && this.server.getState().getCurrentTerm() == electionTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void askForVotes() throws InterruptedException, IOException {
        ServerState state = this.server.getState();
        block15: while (this.shouldRun()) {
            ResultAndTerm r;
            Collection others;
            SnapshotInfo snapshot;
            RaftConfiguration conf;
            long electionTerm;
            RaftServerImpl raftServerImpl = this.server;
            synchronized (raftServerImpl) {
                if (!this.shouldRun()) {
                    break;
                }
                electionTerm = state.initElection();
                conf = state.getRaftConf();
                state.persistMetadata();
            }
            LOG.info("{}: begin an election at term {} for {}", new Object[]{this, electionTerm, conf});
            TermIndex lastEntry = state.getLog().getLastEntryTermIndex();
            if (lastEntry == null && (snapshot = state.getLatestSnapshot()) != null) {
                lastEntry = snapshot.getTermIndex();
            }
            if ((others = conf.getOtherPeers(this.server.getId())).isEmpty()) {
                r = new ResultAndTerm(Result.PASSED, electionTerm);
            } else {
                Executor voteExecutor = new Executor((Object)this, others.size());
                try {
                    int submitted = this.submitRequests(electionTerm, lastEntry, others, voteExecutor);
                    r = this.waitForResults(electionTerm, submitted, conf, voteExecutor);
                }
                finally {
                    voteExecutor.shutdown();
                }
            }
            RaftServerImpl raftServerImpl2 = this.server;
            synchronized (raftServerImpl2) {
                if (!this.shouldRun(electionTerm)) {
                    return;
                }
                switch (1.$SwitchMap$org$apache$ratis$server$impl$LeaderElection$Result[ResultAndTerm.access$000((ResultAndTerm)r).ordinal()]) {
                    case 1: {
                        this.server.changeToLeader();
                        return;
                    }
                    case 2: {
                        LOG.info("{} received shutdown response when requesting votes.", (Object)this);
                        this.server.getProxy().close();
                        return;
                    }
                    case 3: 
                    case 4: {
                        long term = Math.max(ResultAndTerm.access$100((ResultAndTerm)r), state.getCurrentTerm());
                        this.server.changeToFollowerAndPersistMetadata(term, (Object)Result.DISCOVERED_A_NEW_TERM);
                        return;
                    }
                    case 5: {
                        continue block15;
                    }
                }
                throw new IllegalArgumentException("Unable to process result " + ResultAndTerm.access$000((ResultAndTerm)r));
            }
        }
    }

    private int submitRequests(long electionTerm, TermIndex lastEntry, Collection<RaftPeer> others, Executor voteExecutor) {
        int submitted = 0;
        for (RaftPeer peer : others) {
            RaftProtos.RequestVoteRequestProto r = this.server.createRequestVoteRequest(peer.getId(), electionTerm, lastEntry);
            voteExecutor.submit(() -> this.server.getServerRpc().requestVote(r));
            ++submitted;
        }
        return submitted;
    }

    private ResultAndTerm waitForResults(long electionTerm, int submitted, RaftConfiguration conf, Executor voteExecutor) throws InterruptedException {
        Timestamp timeout = Timestamp.currentTime().addTimeMs((long)this.server.getRandomTimeoutMs());
        HashMap<RaftPeerId, RaftProtos.RequestVoteReplyProto> responses = new HashMap<RaftPeerId, RaftProtos.RequestVoteReplyProto>();
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
        int waitForNum = submitted;
        ArrayList<RaftPeerId> votedPeers = new ArrayList<RaftPeerId>();
        while (waitForNum > 0 && this.shouldRun(electionTerm)) {
            TimeDuration waitTime = timeout.elapsedTime().apply(n -> -n);
            if (waitTime.isNonPositive()) {
                return this.logAndReturn(Result.TIMEOUT, responses, exceptions, -1L);
            }
            try {
                Future future = voteExecutor.poll(waitTime);
                if (future == null) continue;
                RaftProtos.RequestVoteReplyProto r = (RaftProtos.RequestVoteReplyProto)future.get();
                RaftPeerId replierId = RaftPeerId.valueOf((ByteString)r.getServerReply().getReplyId());
                RaftProtos.RequestVoteReplyProto previous = responses.putIfAbsent(replierId, r);
                if (previous != null) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("{} received duplicated replies from {}, the 2nd reply is ignored: 1st={}, 2nd={}", new Object[]{this, replierId, ServerProtoUtils.toString((RaftProtos.RequestVoteReplyProto)previous), ServerProtoUtils.toString((RaftProtos.RequestVoteReplyProto)r)});
                    continue;
                }
                if (r.getShouldShutdown()) {
                    return this.logAndReturn(Result.SHUTDOWN, responses, exceptions, -1L);
                }
                if (r.getTerm() > electionTerm) {
                    return this.logAndReturn(Result.DISCOVERED_A_NEW_TERM, responses, exceptions, r.getTerm());
                }
                if (r.getServerReply().getSuccess()) {
                    votedPeers.add(replierId);
                    if (conf.hasMajority(votedPeers, this.server.getId())) {
                        return this.logAndReturn(Result.PASSED, responses, exceptions, -1L);
                    }
                }
            }
            catch (ExecutionException e) {
                LogUtils.infoOrTrace((Logger)LOG, () -> this + " got exception when requesting votes", (Throwable)e);
                exceptions.add(e);
            }
            --waitForNum;
        }
        return this.logAndReturn(Result.REJECTED, responses, exceptions, -1L);
    }

    public String toString() {
        return this.name;
    }
}

