/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.BlockRequestHandlingInjection;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogTestUtils;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class LeaderElectionTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public LeaderElectionTests() {
        Log4jUtils.setLogLevel((Logger)RaftServerImpl.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    @Test
    public void testBasicLeaderElection() throws Exception {
        this.LOG.info("Running testBasicLeaderElection");
        MiniRaftCluster cluster = this.newCluster(5);
        cluster.start();
        RaftTestUtil.waitAndKillLeader((MiniRaftCluster)cluster);
        RaftTestUtil.waitAndKillLeader((MiniRaftCluster)cluster);
        RaftTestUtil.waitAndKillLeader((MiniRaftCluster)cluster);
        this.testFailureCase("waitForLeader after killed a majority of servers", () -> RaftTestUtil.waitForLeader((MiniRaftCluster)cluster, null, (boolean)false), IllegalStateException.class, new Class[0]);
        cluster.shutdown();
    }

    @Test
    public void testChangeLeader() throws Exception {
        SegmentedRaftLogTestUtils.setRaftLogWorkerLogLevel((Level)Level.TRACE);
        this.LOG.info("Running testChangeLeader");
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftPeerId leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster).getId();
        for (int i = 0; i < 10; ++i) {
            leader = RaftTestUtil.changeLeader((MiniRaftCluster)cluster, (RaftPeerId)leader, IllegalStateException::new);
            ExitUtils.assertNotTerminated();
        }
        SegmentedRaftLogTestUtils.setRaftLogWorkerLogLevel((Level)Level.INFO);
        cluster.shutdown();
    }

    @Test
    public void testEnforceLeader() throws Exception {
        this.LOG.info("Running testEnforceLeader");
        int numServer = 5;
        try (MiniRaftCluster cluster = this.newCluster(5);){
            cluster.start();
            RaftPeerId firstLeader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster).getId();
            this.LOG.info("firstLeader = {}", (Object)firstLeader);
            int first = MiniRaftCluster.getIdIndex((String)firstLeader.toString());
            int random = ThreadLocalRandom.current().nextInt(4);
            String newLeader = "s" + (random < first ? random : random + 1);
            this.LOG.info("enforce leader to {}", (Object)newLeader);
            LeaderElectionTests.enforceLeader((MiniRaftCluster)cluster, (String)newLeader, (Logger)this.LOG);
        }
    }

    static void enforceLeader(MiniRaftCluster cluster, String newLeader, Logger LOG) throws InterruptedException {
        LOG.info(cluster.printServers());
        for (int i = 0; !cluster.tryEnforceLeader(newLeader) && i < 10; ++i) {
            RaftServerImpl currLeader = cluster.getLeader();
            LOG.info("try enforcing leader to " + newLeader + " but " + (currLeader == null ? "no leader for round " + i : "new leader is " + currLeader.getId()));
        }
        LOG.info(cluster.printServers());
        RaftServerImpl leader = cluster.getLeader();
        Assert.assertEquals((Object)newLeader, (Object)leader.getId().toString());
    }

    @Test
    public void testLateServerStart() throws Exception {
        int numServer = 3;
        this.LOG.info("Running testLateServerStart");
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.initServers();
        Iterator i = cluster.getServers().iterator();
        for (int j = 1; j < 3; ++j) {
            ((RaftServerProxy)i.next()).start();
        }
        RaftServerImpl leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        TimeDuration sleepTime = TimeDuration.valueOf((long)3L, (TimeUnit)TimeUnit.SECONDS);
        this.LOG.info("sleep " + sleepTime);
        sleepTime.sleep();
        RaftServerProxy lastServer = (RaftServerProxy)i.next();
        lastServer.start();
        RaftPeerId lastServerLeaderId = (RaftPeerId)JavaUtils.attemptRepeatedly(() -> Optional.ofNullable(((RaftServerImpl)lastServer.getImpls().iterator().next()).getState().getLeaderId()).orElseThrow(() -> new IllegalStateException("No leader yet")), (int)10, (TimeDuration)ONE_SECOND, (String)"getLeaderId", (Logger)this.LOG);
        this.LOG.info(cluster.printServers());
        Assert.assertEquals((Object)leader.getId(), (Object)lastServerLeaderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testDisconnectLeader() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServerImpl leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.send((Message)new RaftTestUtil.SimpleMessage("message"));
                Thread.sleep(1000L);
                this.isolate(cluster, leader.getId());
                RaftClientReply reply = client.send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assert.assertNotEquals((Object)reply.getReplierId(), (Object)leader.getId());
                Assert.assertTrue((boolean)reply.isSuccess());
            }
            finally {
                this.deIsolate(cluster, leader.getId());
            }
            cluster.shutdown();
        }
    }

    private void isolate(MiniRaftCluster cluster, RaftPeerId id) {
        try {
            BlockRequestHandlingInjection.getInstance().blockReplier(id.toString());
            cluster.setBlockRequestsFrom(id.toString(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deIsolate(MiniRaftCluster cluster, RaftPeerId id) {
        BlockRequestHandlingInjection.getInstance().unblockReplier(id.toString());
        cluster.setBlockRequestsFrom(id.toString(), false);
    }

    @Test
    public void testLeaderElectionMetrics() throws IOException, InterruptedException {
        this.LOG.info("Running testLeaderElectionMetrics");
        Timestamp timestamp = Timestamp.currentTime();
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftServerImpl leaderServer = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        RatisMetricRegistry ratisMetricRegistry = LeaderElectionMetrics.getLeaderElectionMetrics((RaftServerImpl)leaderServer).getRegistry();
        long numLeaderElections = ratisMetricRegistry.counter("electionCount").getCount();
        Assert.assertTrue((numLeaderElections > 0L ? 1 : 0) != 0);
        long numLeaderElectionTimeout = ratisMetricRegistry.counter("electionTimeoutCount").getCount();
        Assert.assertTrue((numLeaderElectionTimeout > 0L ? 1 : 0) != 0);
        Long leaderElectionLatency = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("electionLatency")).values().iterator().next()).getValue();
        Assert.assertTrue((leaderElectionLatency > 0L && leaderElectionLatency < timestamp.elapsedTimeMs() ? 1 : 0) != 0);
    }

    @Test
    public void testImmediatelyRevertedToFollower() {
        RaftServerImpl server = LeaderElectionTests.createMockServer((boolean)true);
        LeaderElection subject = new LeaderElection(server);
        try {
            subject.startInForeground();
            Assert.assertEquals((Object)LifeCycle.State.CLOSED, (Object)subject.getCurrentState());
        }
        catch (Exception e) {
            this.LOG.info("Error starting LeaderElection", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShutdownBeforeStart() {
        RaftServerImpl server = LeaderElectionTests.createMockServer((boolean)false);
        LeaderElection subject = new LeaderElection(server);
        try {
            subject.shutdown();
            subject.startInForeground();
            Assert.assertEquals((Object)LifeCycle.State.CLOSED, (Object)subject.getCurrentState());
        }
        catch (Exception e) {
            this.LOG.info("Error starting LeaderElection", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    private static RaftServerImpl createMockServer(boolean alive) {
        RaftServerImpl server = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        Mockito.when((Object)server.isAlive()).thenReturn((Object)alive);
        Mockito.when((Object)server.isCandidate()).thenReturn((Object)false);
        Mockito.when((Object)server.getMemberId()).thenReturn((Object)RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"any"), (RaftGroupId)RaftGroupId.randomId()));
        LeaderElectionMetrics leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftServerImpl)server);
        Mockito.when((Object)server.getLeaderElectionMetrics()).thenReturn((Object)leaderElectionMetrics);
        return server;
    }
}

