/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerMetrics;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.StreamRequests;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.server.metrics.LogAppenderMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class LeaderState {
    private static final Logger LOG = RaftServerImpl.LOG;
    public static final String APPEND_PLACEHOLDER = LeaderState.class.getSimpleName() + ".placeholder";
    private final StateUpdateEvent updateCommitEvent = new StateUpdateEvent(StateUpdateEvent.Type.UPDATE_COMMIT, -1L, () -> this.updateCommit());
    private final StateUpdateEvent checkStagingEvent = new StateUpdateEvent(StateUpdateEvent.Type.CHECK_STAGING, -1L, () -> this.checkStaging());
    private final String name;
    private final RaftServerImpl server;
    private final RaftLog raftLog;
    private final long currentTerm;
    private volatile ConfigurationStagingState stagingState;
    private List<List<RaftPeerId>> voterLists;
    private final Map<RaftPeerId, FollowerInfo> peerIdFollowerInfoMap = new ConcurrentHashMap();
    private final SenderList senders;
    private final EventQueue eventQueue;
    private final EventProcessor processor;
    private final PendingRequests pendingRequests;
    private final WatchRequests watchRequests;
    private final StreamRequests streamRequests;
    private volatile boolean running = true;
    private final int stagingCatchupGap;
    private final TimeDuration syncInterval;
    private final long placeHolderIndex;
    private final RaftServerMetrics raftServerMetrics;
    private final LogAppenderMetrics logAppenderMetrics;

    LeaderState(RaftServerImpl server, RaftProperties properties) {
        this.name = server.getMemberId() + "-" + this.getClass().getSimpleName();
        this.server = server;
        this.stagingCatchupGap = RaftServerConfigKeys.stagingCatchupGap((RaftProperties)properties);
        this.syncInterval = RaftServerConfigKeys.Rpc.sleepTime((RaftProperties)properties);
        ServerState state = server.getState();
        this.raftLog = state.getLog();
        this.currentTerm = state.getCurrentTerm();
        this.eventQueue = new EventQueue(this, null);
        this.processor = new EventProcessor(this, null);
        this.raftServerMetrics = server.getRaftServerMetrics();
        this.logAppenderMetrics = new LogAppenderMetrics(server.getMemberId());
        this.pendingRequests = new PendingRequests(server.getMemberId(), properties, this.raftServerMetrics);
        this.watchRequests = new WatchRequests((Object)server.getMemberId(), properties);
        this.streamRequests = new StreamRequests((Object)server.getMemberId());
        RaftConfiguration conf = server.getRaftConf();
        Collection others = conf.getOtherPeers(server.getId());
        this.placeHolderIndex = this.raftLog.getNextIndex();
        this.senders = new SenderList();
        this.addSenders(others, this.placeHolderIndex, true);
        this.voterLists = this.divideFollowers(conf);
    }

    RaftProtos.LogEntryProto start() {
        RaftProtos.LogEntryProto placeHolder = ServerProtoUtils.toLogEntryProto((RaftConfiguration)this.server.getRaftConf(), (long)this.server.getState().getCurrentTerm(), (long)this.raftLog.getNextIndex());
        CodeInjectionForTesting.execute((String)APPEND_PLACEHOLDER, (Object)this.server.getId().toString(), null, (Object[])new Object[0]);
        this.raftLog.append(new RaftProtos.LogEntryProto[]{placeHolder});
        this.processor.start();
        this.senders.forEach(LogAppender::startAppender);
        return placeHolder;
    }

    boolean isReady() {
        return this.server.getState().getLastAppliedIndex() >= this.placeHolderIndex;
    }

    void stop() {
        this.running = false;
        this.senders.forEach(LogAppender::stopAppender);
        NotLeaderException nle = this.server.generateNotLeaderException();
        Collection commitInfos = this.server.getCommitInfos();
        try {
            Collection transactions = this.pendingRequests.sendNotLeaderResponses(nle, commitInfos);
            this.server.getStateMachine().notifyNotLeader(transactions);
            this.watchRequests.failWatches((Exception)nle);
        }
        catch (IOException e) {
            LOG.warn("{}: Caught exception in sendNotLeaderResponses", (Object)this, (Object)e);
        }
        this.streamRequests.clear();
        this.server.getServerRpc().notifyNotLeader(this.server.getMemberId().getGroupId());
        this.logAppenderMetrics.unregister();
        this.raftServerMetrics.unregister();
        if (this.pendingRequests != null) {
            this.pendingRequests.close();
        }
    }

    void notifySenders() {
        this.senders.forEach(LogAppender::notifyAppend);
    }

    boolean inStagingState() {
        return this.stagingState != null;
    }

    long getCurrentTerm() {
        return this.currentTerm;
    }

    TimeDuration getSyncInterval() {
        return this.syncInterval;
    }

    PendingRequest startSetConfiguration(SetConfigurationRequest request) {
        LOG.info("{}: startSetConfiguration {}", (Object)this, (Object)request);
        Preconditions.assertTrue((this.running && !this.inStagingState() ? 1 : 0) != 0);
        List peersInNewConf = request.getPeersInNewConf();
        Collection peersToBootStrap = this.server.getRaftConf().filterNotContainedInConf(peersInNewConf);
        PendingRequest pending = this.pendingRequests.addConfRequest(request);
        ConfigurationStagingState configurationStagingState = new ConfigurationStagingState(this, peersToBootStrap, new PeerConfiguration((Iterable)peersInNewConf));
        Collection newPeers = configurationStagingState.getNewPeers();
        this.stagingState = configurationStagingState;
        if (newPeers.isEmpty()) {
            this.applyOldNewConf();
        } else {
            this.addAndStartSenders(newPeers);
        }
        return pending;
    }

    PendingRequests.Permit tryAcquirePendingRequest(Message message) {
        return this.pendingRequests.tryAcquire(message);
    }

    PendingRequest addPendingRequest(PendingRequests.Permit permit, RaftClientRequest request, TransactionContext entry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: addPendingRequest at {}, entry={}", new Object[]{this, request, ServerProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry.getLogEntry())});
        }
        return this.pendingRequests.add(permit, request, entry);
    }

    CompletableFuture<RaftClientReply> streamAsync(RaftClientRequest request) {
        return ((CompletableFuture)this.streamRequests.streamAsync(request).thenApply(dummy -> new RaftClientReply(request, this.server.getCommitInfos()))).exceptionally(e -> this.exception2RaftClientReply(request, e));
    }

    CompletableFuture<RaftClientRequest> streamEndOfRequestAsync(RaftClientRequest request) {
        return this.streamRequests.streamEndOfRequestAsync(request).thenApply(bytes -> RaftClientRequest.toWriteRequest((RaftClientRequest)request, (Message)Message.valueOf((ByteString)bytes)));
    }

    CompletableFuture<RaftClientReply> addWatchReqeust(RaftClientRequest request) {
        LOG.debug("{}: addWatchRequest {}", (Object)this, (Object)request);
        return ((CompletableFuture)this.watchRequests.add(request).thenApply(v -> new RaftClientReply(request, this.server.getCommitInfos()))).exceptionally(e -> this.exception2RaftClientReply(request, e));
    }

    private RaftClientReply exception2RaftClientReply(RaftClientRequest request, Throwable e) {
        if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof NotReplicatedException) {
            return new RaftClientReply(request, (NotReplicatedException)e, this.server.getCommitInfos());
        }
        if (e instanceof NotLeaderException) {
            return new RaftClientReply(request, (RaftException)((NotLeaderException)e), this.server.getCommitInfos());
        }
        if (e instanceof LeaderNotReadyException) {
            return new RaftClientReply(request, (RaftException)((LeaderNotReadyException)e), this.server.getCommitInfos());
        }
        throw new CompletionException(e);
    }

    void commitIndexChanged() {
        this.getMajorityMin(FollowerInfo::getCommitIndex, () -> ((RaftLog)this.raftLog).getLastCommittedIndex()).ifPresent(m -> {
            this.watchRequests.update(RaftProtos.ReplicationLevel.ALL_COMMITTED, MinMajorityMax.access$1100((MinMajorityMax)m));
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY_COMMITTED, MinMajorityMax.access$1000((MinMajorityMax)m));
            this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY, MinMajorityMax.access$1200((MinMajorityMax)m));
        });
    }

    private void applyOldNewConf() {
        ServerState state = this.server.getState();
        RaftConfiguration current = this.server.getRaftConf();
        RaftConfiguration oldNewConf = this.stagingState.generateOldNewConf(current, state.getLog().getNextIndex());
        long index = state.getLog().append(state.getCurrentTerm(), oldNewConf);
        this.updateConfiguration(index, oldNewConf);
        this.stagingState = null;
        this.notifySenders();
    }

    private void updateConfiguration(long logIndex, RaftConfiguration newConf) {
        this.voterLists = this.divideFollowers(newConf);
        this.server.getState().setRaftConf(logIndex, newConf);
    }

    void updateFollowerCommitInfos(CommitInfoCache cache, List<RaftProtos.CommitInfoProto> protos) {
        this.senders.stream().map(LogAppender::getFollower).map(f -> cache.update(f.getPeer(), f.getCommitIndex())).forEach(protos::add);
    }

    RaftProtos.AppendEntriesRequestProto newAppendEntriesRequestProto(RaftPeerId targetId, TermIndex previous, List<RaftProtos.LogEntryProto> entries, boolean initializing, long callId) {
        return ServerProtoUtils.toAppendEntriesRequestProto((RaftGroupMemberId)this.server.getMemberId(), (RaftPeerId)targetId, (long)this.currentTerm, entries, (long)this.raftLog.getLastCommittedIndex(), (boolean)initializing, (TermIndex)previous, (Collection)this.server.getCommitInfos(), (long)callId);
    }

    void addAndStartSenders(Collection<RaftPeer> newPeers) {
        this.addSenders(newPeers, 0L, false).forEach(LogAppender::startAppender);
    }

    Collection<LogAppender> addSenders(Collection<RaftPeer> newPeers, long nextIndex, boolean attendVote) {
        Timestamp t = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        List<LogAppender> newAppenders = newPeers.stream().map(peer -> {
            FollowerInfo f = new FollowerInfo(this.server.getMemberId(), peer, t, nextIndex, attendVote, this.server.getRpcSlownessTimeoutMs());
            LogAppender logAppender = this.server.newLogAppender(this, f);
            this.peerIdFollowerInfoMap.put(peer.getId(), f);
            this.raftServerMetrics.addFollower(f.getPeer());
            this.logAppenderMetrics.addFollowerGauges(f);
            return logAppender;
        }).collect(Collectors.toList());
        this.senders.addAll(newAppenders);
        return newAppenders;
    }

    void stopAndRemoveSenders(Predicate<LogAppender> predicate) {
        List<LogAppender> toStop = this.senders.stream().filter(predicate).collect(Collectors.toList());
        toStop.forEach(LogAppender::stopAppender);
        this.senders.removeAll(toStop);
    }

    void restartSender(LogAppender sender) {
        FollowerInfo follower = sender.getFollower();
        LOG.info("{}: Restarting {} for {}", new Object[]{this, sender.getClass().getSimpleName(), follower.getName()});
        sender.stopAppender();
        this.senders.removeAll(Collections.singleton(sender));
        this.addAndStartSenders(Collections.singleton(follower.getPeer()));
    }

    private void updateSenders(RaftConfiguration conf) {
        Preconditions.assertTrue((conf.isStable() && !this.inStagingState() ? 1 : 0) != 0);
        this.stopAndRemoveSenders(s -> !conf.containsInConf(s.getFollower().getPeer().getId()));
    }

    void submitStepDownEvent() {
        this.submitStepDownEvent(this.getCurrentTerm());
    }

    void submitStepDownEvent(long term) {
        this.eventQueue.submit(new StateUpdateEvent(StateUpdateEvent.Type.STEP_DOWN, term, () -> this.stepDown(term)));
    }

    private void stepDown(long term) {
        block2: {
            try {
                this.server.changeToFollowerAndPersistMetadata(term, (Object)"stepDown");
            }
            catch (IOException e) {
                String s = this + ": Failed to persist metadata for term " + term;
                LOG.warn(s, (Throwable)e);
                if (!this.running) break block2;
                throw new IllegalStateException(s + " and running == true", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() {
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            RaftConfiguration conf;
            if (this.running && (conf = this.server.getRaftConf()).isTransitional() && this.server.getState().isConfCommitted()) {
                this.replicateNewConf();
            }
        }
    }

    private BootStrapProgress checkProgress(FollowerInfo follower, long committed) {
        Preconditions.assertTrue((!follower.isAttendingVote() ? 1 : 0) != 0);
        Timestamp progressTime = Timestamp.currentTime().addTimeMs((long)(-this.server.getMaxTimeoutMs()));
        Timestamp timeoutTime = Timestamp.currentTime().addTimeMs((long)(-3 * this.server.getMaxTimeoutMs()));
        if (follower.getLastRpcResponseTime().compareTo(timeoutTime) < 0) {
            LOG.debug("{} detects a follower {} timeout ({}) for bootstrapping", new Object[]{this, follower, timeoutTime});
            return BootStrapProgress.NOPROGRESS;
        }
        if (follower.getMatchIndex() + (long)this.stagingCatchupGap > committed && follower.getLastRpcResponseTime().compareTo(progressTime) > 0) {
            return BootStrapProgress.CAUGHTUP;
        }
        return BootStrapProgress.PROGRESSING;
    }

    private Collection<BootStrapProgress> checkAllProgress(long committed) {
        Preconditions.assertTrue((boolean)this.inStagingState());
        return this.senders.stream().filter(sender -> !sender.getFollower().isAttendingVote()).map(sender -> this.checkProgress(sender.getFollower(), committed)).collect(Collectors.toCollection(ArrayList::new));
    }

    void submitCheckStagingEvent() {
        this.eventQueue.submit(this.checkStagingEvent);
    }

    private void checkStaging() {
        if (!this.inStagingState()) {
            this.updateCommitEvent.execute();
        } else {
            long committedIndex = this.server.getState().getLog().getLastCommittedIndex();
            Collection reports = this.checkAllProgress(committedIndex);
            if (reports.contains(BootStrapProgress.NOPROGRESS)) {
                this.stagingState.fail(BootStrapProgress.NOPROGRESS);
            } else if (!reports.contains(BootStrapProgress.PROGRESSING)) {
                this.applyOldNewConf();
                this.senders.forEach(s -> s.getFollower().startAttendVote());
            }
        }
    }

    boolean isBootStrappingPeer(RaftPeerId peerId) {
        return Optional.ofNullable(this.stagingState).map(s -> s.contains(peerId)).orElse(false);
    }

    void submitUpdateCommitEvent() {
        this.eventQueue.submit(this.updateCommitEvent);
    }

    private void updateCommit() {
        this.getMajorityMin(FollowerInfo::getMatchIndex, () -> ((RaftLog)this.raftLog).getFlushIndex()).ifPresent(m -> this.updateCommit(MinMajorityMax.access$1000((MinMajorityMax)m), MinMajorityMax.access$1100((MinMajorityMax)m)));
    }

    private Optional<MinMajorityMax> getMajorityMin(ToLongFunction<FollowerInfo> followerIndex, LongSupplier logIndex) {
        RaftPeerId selfId = this.server.getId();
        RaftConfiguration conf = this.server.getRaftConf();
        List followers = (List)this.voterLists.get(0);
        boolean includeSelf = conf.containsInConf(selfId);
        if (followers.isEmpty() && !includeSelf) {
            return Optional.empty();
        }
        long[] indicesInNewConf = this.getSorted(followers, includeSelf, followerIndex, logIndex);
        MinMajorityMax newConf = MinMajorityMax.valueOf((long[])indicesInNewConf);
        if (!conf.isTransitional()) {
            return Optional.of(newConf);
        }
        List oldFollowers = (List)this.voterLists.get(1);
        boolean includeSelfInOldConf = conf.containsInOldConf(selfId);
        if (oldFollowers.isEmpty() && !includeSelfInOldConf) {
            return Optional.empty();
        }
        long[] indicesInOldConf = this.getSorted(oldFollowers, includeSelfInOldConf, followerIndex, logIndex);
        MinMajorityMax oldConf = MinMajorityMax.valueOf((long[])indicesInOldConf);
        return Optional.of(newConf.combine(oldConf));
    }

    private void updateCommit(long majority, long min) {
        long oldLastCommitted = this.raftLog.getLastCommittedIndex();
        if (majority > oldLastCommitted) {
            TermIndex[] entriesToCommit = this.raftLog.getEntries(oldLastCommitted + 1L, majority + 1L);
            if (this.server.getState().updateStatemachine(majority, this.currentTerm)) {
                this.watchRequests.update(RaftProtos.ReplicationLevel.MAJORITY, majority);
                this.logMetadata(majority);
                this.commitIndexChanged();
            }
            try {
                for (TermIndex entry : entriesToCommit) {
                    this.raftLog.getRaftLogMetrics().onLogEntryCommit(this.raftLog.get(entry.getIndex()));
                }
            }
            catch (RaftLogIOException e) {
                LOG.error("Caught exception reading from RaftLog", (Throwable)e);
            }
            this.checkAndUpdateConfiguration(entriesToCommit);
        }
        this.watchRequests.update(RaftProtos.ReplicationLevel.ALL, min);
    }

    private void logMetadata(long commitIndex) {
        this.raftLog.appendMetadata(this.currentTerm, commitIndex);
        this.notifySenders();
    }

    private boolean committedConf(TermIndex[] entries) {
        long currentCommitted = this.raftLog.getLastCommittedIndex();
        for (TermIndex entry : entries) {
            if (entry.getIndex() > currentCommitted || !this.raftLog.isConfigEntry(entry)) continue;
            return true;
        }
        return false;
    }

    private void checkAndUpdateConfiguration(TermIndex[] entriesToCheck) {
        RaftConfiguration conf = this.server.getRaftConf();
        if (this.committedConf(entriesToCheck)) {
            if (conf.isTransitional()) {
                this.replicateNewConf();
            } else {
                this.pendingRequests.replySetConfiguration(() -> ((RaftServerImpl)this.server).getCommitInfos());
                if (!conf.containsInConf(this.server.getId())) {
                    LOG.info("{} is not included in the new configuration {}. Will shutdown server...", (Object)this, (Object)conf);
                    try {
                        Thread.sleep(this.server.getMinTimeoutMs());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.server.shutdown(false);
                }
            }
        }
    }

    private void replicateNewConf() {
        RaftConfiguration conf = this.server.getRaftConf();
        RaftConfiguration newConf = RaftConfiguration.newBuilder().setConf(conf).setLogEntryIndex(this.raftLog.getNextIndex()).build();
        this.updateSenders(newConf);
        long index = this.raftLog.append(this.server.getState().getCurrentTerm(), newConf);
        this.updateConfiguration(index, newConf);
        this.notifySenders();
    }

    private List<FollowerInfo> getFollowerInfos(List<RaftPeerId> followerIDs) {
        ArrayList<FollowerInfo> followerInfos = new ArrayList<FollowerInfo>();
        for (int i = 0; i < followerIDs.size(); ++i) {
            RaftPeerId id = followerIDs.get(i);
            if (!this.peerIdFollowerInfoMap.containsKey(id)) {
                throw new IllegalArgumentException("RaftPeerId:" + id + " not in peerIdFollowerInfoMap of leader:" + this.server.getMemberId());
            }
            followerInfos.add((FollowerInfo)this.peerIdFollowerInfoMap.get(id));
        }
        return followerInfos;
    }

    private long[] getSorted(List<RaftPeerId> followerIDs, boolean includeSelf, ToLongFunction<FollowerInfo> getFollowerIndex, LongSupplier getLogIndex) {
        int length;
        int n = length = includeSelf ? followerIDs.size() + 1 : followerIDs.size();
        if (length == 0) {
            throw new IllegalArgumentException("followers.size() == " + followerIDs.size() + " and includeSelf == " + includeSelf);
        }
        long[] indices = new long[length];
        List followerInfos = this.getFollowerInfos(followerIDs);
        for (int i = 0; i < followerInfos.size(); ++i) {
            indices[i] = getFollowerIndex.applyAsLong((FollowerInfo)followerInfos.get(i));
        }
        if (includeSelf) {
            indices[length - 1] = getLogIndex.getAsLong();
        }
        Arrays.sort(indices);
        return indices;
    }

    private List<List<RaftPeerId>> divideFollowers(RaftConfiguration conf) {
        ArrayList<List<RaftPeerId>> lists = new ArrayList<List<RaftPeerId>>(2);
        List listForNew = this.senders.stream().filter(sender -> conf.containsInConf(sender.getFollower().getPeer().getId())).map(sender -> sender.getFollower().getPeer().getId()).collect(Collectors.toList());
        lists.add(listForNew);
        if (conf.isTransitional()) {
            List listForOld = this.senders.stream().filter(sender -> conf.containsInOldConf(sender.getFollower().getPeer().getId())).map(sender -> sender.getFollower().getPeer().getId()).collect(Collectors.toList());
            lists.add(listForOld);
        }
        return lists;
    }

    void replyPendingRequest(long logIndex, RaftClientReply reply) {
        this.pendingRequests.replyPendingRequest(logIndex, reply);
    }

    TransactionContext getTransactionContext(long index) {
        return this.pendingRequests.getTransactionContext(index);
    }

    long[] getFollowerNextIndices() {
        return this.senders.stream().mapToLong(s -> s.getFollower().getNextIndex()).toArray();
    }

    List<RaftPeer> getFollowers() {
        return Collections.unmodifiableList(this.senders.stream().map(sender -> sender.getFollower().getPeer()).collect(Collectors.toList()));
    }

    Stream<LogAppender> getLogAppenders() {
        return this.senders.stream();
    }

    void recordFollowerHeartbeatElapsedTime(RaftPeer follower, long elapsedTime) {
        this.raftServerMetrics.recordFollowerHeartbeatElapsedTime(follower, elapsedTime);
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ RaftServerImpl access$000(LeaderState x0) {
        return x0.server;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ boolean access$200(LeaderState x0) {
        return x0.running;
    }

    static /* synthetic */ void access$500(LeaderState x0) {
        x0.prepare();
    }

    static /* synthetic */ EventQueue access$600(LeaderState x0) {
        return x0.eventQueue;
    }

    static /* synthetic */ void access$700(LeaderState x0) {
        x0.checkStaging();
    }

    static /* synthetic */ ConfigurationStagingState access$802(LeaderState x0, ConfigurationStagingState x1) {
        x0.stagingState = x1;
        return x0.stagingState;
    }

    static /* synthetic */ PendingRequests access$900(LeaderState x0) {
        return x0.pendingRequests;
    }
}

