/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;

public class PendingRequest
implements Comparable<PendingRequest> {
    private final long index;
    private final RaftClientRequest request;
    private final TransactionContext entry;
    private final CompletableFuture<RaftClientReply> future;

    PendingRequest(long index, RaftClientRequest request, TransactionContext entry) {
        this.index = index;
        this.request = request;
        this.entry = entry;
        this.future = new CompletableFuture();
    }

    PendingRequest(SetConfigurationRequest request) {
        this(-1L, (RaftClientRequest)request, null);
    }

    long getIndex() {
        return this.index;
    }

    RaftClientRequest getRequest() {
        return this.request;
    }

    public CompletableFuture<RaftClientReply> getFuture() {
        return this.future;
    }

    TransactionContext getEntry() {
        return this.entry;
    }

    synchronized void setException(Throwable e) {
        Preconditions.assertTrue((e != null ? 1 : 0) != 0);
        this.future.completeExceptionally(e);
    }

    synchronized void setReply(RaftClientReply r) {
        Preconditions.assertTrue((r != null ? 1 : 0) != 0);
        this.future.complete(r);
    }

    TransactionContext setNotLeaderException(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this.setReply(new RaftClientReply(this.getRequest(), (RaftException)nle, commitInfos));
        return this.getEntry();
    }

    @Override
    public int compareTo(PendingRequest that) {
        return Long.compare(this.index, that.index);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(index=" + this.index + ", request=" + this.request;
    }
}

