/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftServerMetrics;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingRequests {
    public static final Logger LOG = LoggerFactory.getLogger(PendingRequests.class);
    private PendingRequest pendingSetConf;
    private final String name;
    private final RequestMap pendingRequests;

    PendingRequests(RaftGroupMemberId id, RaftProperties properties, RaftServerMetrics raftServerMetrics) {
        this.name = id + "-" + this.getClass().getSimpleName();
        this.pendingRequests = new RequestMap((Object)id, RaftServerConfigKeys.Write.elementLimit((RaftProperties)properties), RaftServerConfigKeys.Write.byteLimit((RaftProperties)properties), raftServerMetrics);
    }

    Permit tryAcquire(Message message) {
        return this.pendingRequests.tryAcquire(message);
    }

    PendingRequest add(Permit permit, RaftClientRequest request, TransactionContext entry) {
        Preconditions.assertTrue((boolean)request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE));
        long index = entry.getLogEntry().getIndex();
        LOG.debug("{}: addPendingRequest at index={}, request={}", new Object[]{this.name, index, request});
        PendingRequest pending = new PendingRequest(index, request, entry);
        return this.pendingRequests.put(permit, index, pending);
    }

    PendingRequest addConfRequest(SetConfigurationRequest request) {
        Preconditions.assertTrue((this.pendingSetConf == null ? 1 : 0) != 0);
        this.pendingSetConf = new PendingRequest(request);
        return this.pendingSetConf;
    }

    void replySetConfiguration(Supplier<Collection<RaftProtos.CommitInfoProto>> getCommitInfos) {
        if (this.pendingSetConf != null) {
            RaftClientRequest request = this.pendingSetConf.getRequest();
            LOG.debug("{}: sends success for {}", (Object)this.name, (Object)request);
            this.pendingSetConf.setReply(new RaftClientReply(request, getCommitInfos.get()));
            this.pendingSetConf = null;
        }
    }

    void failSetConfiguration(RaftException e) {
        Preconditions.assertTrue((this.pendingSetConf != null ? 1 : 0) != 0);
        this.pendingSetConf.setException((Throwable)e);
        this.pendingSetConf = null;
    }

    TransactionContext getTransactionContext(long index) {
        PendingRequest pendingRequest = this.pendingRequests.get(index);
        return pendingRequest != null ? pendingRequest.getEntry() : null;
    }

    void replyPendingRequest(long index, RaftClientReply reply) {
        PendingRequest pending = this.pendingRequests.remove(index);
        if (pending != null) {
            Preconditions.assertTrue((pending.getIndex() == index ? 1 : 0) != 0);
            pending.setReply(reply);
        }
    }

    Collection<TransactionContext> sendNotLeaderResponses(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        LOG.info("{}: sendNotLeaderResponses", (Object)this.name);
        Collection transactions = this.pendingRequests.setNotLeaderException(nle, commitInfos);
        if (this.pendingSetConf != null) {
            this.pendingSetConf.setNotLeaderException(nle, commitInfos);
        }
        return transactions;
    }

    void close() {
        if (this.pendingRequests != null) {
            this.pendingRequests.close();
        }
    }
}

