/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.util.Preconditions;

public final class RaftConfiguration {
    private final PeerConfiguration oldConf;
    private final PeerConfiguration conf;
    private final long logEntryIndex;

    public static Builder newBuilder() {
        return new Builder(null);
    }

    private RaftConfiguration(PeerConfiguration conf, PeerConfiguration oldConf, long logEntryIndex) {
        this.conf = Objects.requireNonNull(conf);
        this.oldConf = oldConf;
        this.logEntryIndex = logEntryIndex;
    }

    boolean isTransitional() {
        return this.oldConf != null;
    }

    boolean isStable() {
        return this.oldConf == null;
    }

    boolean containsInConf(RaftPeerId peerId) {
        return this.conf.contains(peerId);
    }

    boolean containsInOldConf(RaftPeerId peerId) {
        return this.oldConf != null && this.oldConf.contains(peerId);
    }

    boolean contains(RaftPeerId peerId) {
        return this.containsInConf(peerId) && (this.oldConf == null || this.containsInOldConf(peerId));
    }

    public RaftPeer getPeer(RaftPeerId id) {
        if (id == null) {
            return null;
        }
        RaftPeer peer = this.conf.getPeer(id);
        if (peer != null) {
            return peer;
        }
        if (this.oldConf != null) {
            return this.oldConf.getPeer(id);
        }
        return null;
    }

    public Collection<RaftPeer> getPeers() {
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>(this.conf.getPeers());
        if (this.oldConf != null) {
            this.oldConf.getPeers().stream().filter(p -> !peers.contains(p)).forEach(peers::add);
        }
        return peers;
    }

    public Collection<RaftPeer> getOtherPeers(RaftPeerId selfId) {
        List others = this.conf.getOtherPeers(selfId);
        if (this.oldConf != null) {
            this.oldConf.getOtherPeers(selfId).stream().filter(p -> !others.contains(p)).forEach(others::add);
        }
        return others;
    }

    boolean hasMajority(Collection<RaftPeerId> others, RaftPeerId selfId) {
        Preconditions.assertTrue((!others.contains(selfId) ? 1 : 0) != 0);
        return this.conf.hasMajority(others, selfId) && (this.oldConf == null || this.oldConf.hasMajority(others, selfId));
    }

    public String toString() {
        return this.logEntryIndex + ": " + this.conf + ", old=" + this.oldConf;
    }

    boolean hasNoChange(Collection<RaftPeer> newMembers) {
        if (!this.isStable() || this.conf.size() != newMembers.size()) {
            return false;
        }
        for (RaftPeer peer : newMembers) {
            if (this.conf.contains(peer.getId())) continue;
            return false;
        }
        return true;
    }

    long getLogEntryIndex() {
        return this.logEntryIndex;
    }

    Collection<RaftPeer> filterNotContainedInConf(List<RaftPeer> peers) {
        return peers.stream().filter(p -> !this.containsInConf(p.getId())).collect(Collectors.toList());
    }

    RaftPeer getRandomPeer(RaftPeerId exclusiveId) {
        List peers = this.conf.getOtherPeers(exclusiveId);
        if (peers.isEmpty()) {
            return null;
        }
        int index = ThreadLocalRandom.current().nextInt(peers.size());
        return (RaftPeer)peers.get(index);
    }

    Collection<RaftPeer> getPeersInOldConf() {
        return this.oldConf != null ? this.oldConf.getPeers() : Collections.emptyList();
    }

    Collection<RaftPeer> getPeersInConf() {
        return this.conf.getPeers();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RaftConfiguration that = (RaftConfiguration)obj;
        return this.logEntryIndex == that.logEntryIndex && Objects.equals(this.conf, that.conf) && Objects.equals(this.oldConf, that.oldConf);
    }

    public int hashCode() {
        return Long.hashCode(this.logEntryIndex);
    }

    static /* synthetic */ PeerConfiguration access$100(RaftConfiguration x0) {
        return x0.conf;
    }
}

