/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.ObjectName;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientProtocol;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReconfigurationInProgressException;
import org.apache.ratis.protocol.ServerNotReadyException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StaleReadException;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerMXBean;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerMetrics;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.server.impl.RoleInfo;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.JmxRegister;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftServerImpl
implements RaftServerProtocol,
RaftServerAsynchronousProtocol,
RaftClientProtocol,
RaftClientAsynchronousProtocol {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerImpl.class);
    private static final String CLASS_NAME = RaftServerImpl.class.getSimpleName();
    static final String REQUEST_VOTE = CLASS_NAME + ".requestVote";
    static final String APPEND_ENTRIES = CLASS_NAME + ".appendEntries";
    static final String INSTALL_SNAPSHOT = CLASS_NAME + ".installSnapshot";
    private final RaftServerProxy proxy;
    private final StateMachine stateMachine;
    private final int minTimeoutMs;
    private final int maxTimeoutMs;
    private final int rpcSlownessTimeoutMs;
    private final int sleepDeviationThresholdMs;
    private final boolean installSnapshotEnabled;
    private final LifeCycle lifeCycle;
    private final ServerState state;
    private final Supplier<RaftPeer> peerSupplier = JavaUtils.memoize(() -> new RaftPeer(this.getId(), this.getServerRpc().getInetSocketAddress()));
    private final RoleInfo role;
    private final RetryCache retryCache;
    private final CommitInfoCache commitInfoCache = new CommitInfoCache();
    private final RaftServerJmxAdapter jmxAdapter;
    private final LeaderElectionMetrics leaderElectionMetrics;
    private final RaftServerMetrics raftServerMetrics;
    private AtomicReference<TermIndex> inProgressInstallSnapshotRequest;
    private AtomicBoolean startComplete;

    RaftServerImpl(RaftGroup group, StateMachine stateMachine, RaftServerProxy proxy) throws IOException {
        RaftPeerId id = proxy.getId();
        LOG.info("{}: new RaftServerImpl for {} with {}", new Object[]{id, group, stateMachine});
        this.lifeCycle = new LifeCycle((Object)id);
        this.stateMachine = stateMachine;
        this.role = new RoleInfo(id);
        RaftProperties properties = proxy.getProperties();
        this.minTimeoutMs = RaftServerConfigKeys.Rpc.timeoutMin((RaftProperties)properties).toIntExact(TimeUnit.MILLISECONDS);
        this.maxTimeoutMs = RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)properties).toIntExact(TimeUnit.MILLISECONDS);
        this.rpcSlownessTimeoutMs = RaftServerConfigKeys.Rpc.slownessTimeout((RaftProperties)properties).toIntExact(TimeUnit.MILLISECONDS);
        this.sleepDeviationThresholdMs = RaftServerConfigKeys.sleepDeviationThreshold((RaftProperties)properties);
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled((RaftProperties)properties);
        Preconditions.assertTrue((this.maxTimeoutMs > this.minTimeoutMs ? 1 : 0) != 0, (String)"max timeout: %s, min timeout: %s", (Object[])new Object[]{this.maxTimeoutMs, this.minTimeoutMs});
        this.proxy = proxy;
        this.state = new ServerState(id, group, properties, this, stateMachine);
        this.retryCache = this.initRetryCache(properties);
        this.inProgressInstallSnapshotRequest = new AtomicReference<Object>(null);
        this.jmxAdapter = new RaftServerJmxAdapter(this, null);
        this.leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftServerImpl)this);
        this.raftServerMetrics = RaftServerMetrics.getRaftServerMetrics((RaftServerImpl)this);
        this.startComplete = new AtomicBoolean(false);
    }

    private RetryCache initRetryCache(RaftProperties prop) {
        TimeDuration expireTime = RaftServerConfigKeys.RetryCache.expiryTime((RaftProperties)prop);
        return new RetryCache(expireTime);
    }

    LogAppender newLogAppender(LeaderState leaderState, FollowerInfo f) {
        return this.getProxy().getFactory().newLogAppender(this, leaderState, f);
    }

    RaftPeer getPeer() {
        return (RaftPeer)this.peerSupplier.get();
    }

    int getMinTimeoutMs() {
        return this.minTimeoutMs;
    }

    int getMaxTimeoutMs() {
        return this.maxTimeoutMs;
    }

    int getRpcSlownessTimeoutMs() {
        return this.rpcSlownessTimeoutMs;
    }

    int getRandomTimeoutMs() {
        return this.minTimeoutMs + ThreadLocalRandom.current().nextInt(this.maxTimeoutMs - this.minTimeoutMs + 1);
    }

    int getSleepDeviationThresholdMs() {
        return this.sleepDeviationThresholdMs;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    @VisibleForTesting
    public RetryCache getRetryCache() {
        return this.retryCache;
    }

    public RaftServerProxy getProxy() {
        return this.proxy;
    }

    public RaftServerRpc getServerRpc() {
        return this.proxy.getServerRpc();
    }

    private void setRole(RaftProtos.RaftPeerRole newRole, Object reason) {
        LOG.info("{}: changes role from {} to {} at term {} for {}", new Object[]{this.getMemberId(), this.role, newRole, this.state.getCurrentTerm(), reason});
        this.role.transitionRole(newRole);
    }

    boolean start() {
        if (!this.lifeCycle.compareAndTransition(LifeCycle.State.NEW, LifeCycle.State.STARTING)) {
            return false;
        }
        RaftConfiguration conf = this.getRaftConf();
        if (conf != null && conf.contains(this.getId())) {
            LOG.info("{}: start as a follower, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startAsFollower();
        } else {
            LOG.info("{}: start with initializing state, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startInitializing();
        }
        RaftServerImpl.registerMBean((RaftPeerId)this.getId(), (RaftGroupId)this.getMemberId().getGroupId(), (RaftServerMXBean)this.jmxAdapter, (JmxRegister)this.jmxAdapter);
        this.state.start();
        this.startComplete.compareAndSet(false, true);
        return true;
    }

    static boolean registerMBean(RaftPeerId id, RaftGroupId groupdId, RaftServerMXBean mBean, JmxRegister jmx) {
        String prefix = "Ratis:service=RaftServer,group=" + groupdId + ",id=";
        String registered = jmx.register((Object)mBean, Arrays.asList(() -> prefix + id, () -> prefix + ObjectName.quote(id.toString())));
        return registered != null;
    }

    private void startAsFollower() {
        this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, (Object)"startAsFollower");
        this.role.startFollowerState(this);
        this.lifeCycle.transition(LifeCycle.State.RUNNING);
    }

    private void startInitializing() {
        this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, (Object)"startInitializing");
    }

    public ServerState getState() {
        return this.state;
    }

    public RaftGroupMemberId getMemberId() {
        return this.getState().getMemberId();
    }

    public RaftPeerId getId() {
        return this.getMemberId().getPeerId();
    }

    RoleInfo getRole() {
        return this.role;
    }

    RaftConfiguration getRaftConf() {
        return this.getState().getRaftConf();
    }

    RaftGroup getGroup() {
        return RaftGroup.valueOf((RaftGroupId)this.getMemberId().getGroupId(), (Collection)this.getRaftConf().getPeers());
    }

    public void shutdown(boolean deleteDirectory) {
        this.lifeCycle.checkStateAndClose(() -> {
            LOG.info("{}: shutdown", (Object)this.getMemberId());
            try {
                this.jmxAdapter.unregister();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to un-register RaftServer JMX bean", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownFollowerState();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown FollowerState", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownLeaderElection();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown LeaderElection", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownLeaderState(true);
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown LeaderState monitor", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.state.close();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to close state", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.leaderElectionMetrics.unregister();
                this.raftServerMetrics.unregister();
                RaftServerMetrics.removeRaftServerMetrics((RaftServerImpl)this);
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to unregister metric", (Object)this.getMemberId(), (Object)ignored);
            }
            if (deleteDirectory) {
                RaftStorageDirectory dir = this.state.getStorage().getStorageDir();
                for (int i = 0; i < 5; ++i) {
                    try {
                        FileUtils.deleteFully((File)dir.getRoot());
                        LOG.info("{}: Succeed to remove RaftStorageDirectory {}", (Object)this.getMemberId(), (Object)dir);
                        break;
                    }
                    catch (NoSuchFileException e) {
                        LOG.warn("{}: Some file does not exist {}", new Object[]{this.getMemberId(), dir, e});
                        continue;
                    }
                    catch (Exception ignored) {
                        LOG.error("{}: Failed to remove RaftStorageDirectory {}", new Object[]{this.getMemberId(), dir, ignored});
                        break;
                    }
                }
            }
        });
    }

    public boolean isAlive() {
        return !this.lifeCycle.getCurrentState().isClosingOrClosed();
    }

    public boolean isFollower() {
        return this.role.isFollower();
    }

    public boolean isCandidate() {
        return this.role.isCandidate();
    }

    public boolean isLeader() {
        return this.role.isLeader();
    }

    public CommitInfoCache getCommitInfoCache() {
        return this.commitInfoCache;
    }

    private synchronized boolean changeToFollower(long newTerm, boolean force, Object reason) {
        RaftProtos.RaftPeerRole old = this.role.getCurrentRole();
        boolean metadataUpdated = this.state.updateCurrentTerm(newTerm);
        if (old != RaftProtos.RaftPeerRole.FOLLOWER || force) {
            this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, reason);
            if (old == RaftProtos.RaftPeerRole.LEADER) {
                this.role.shutdownLeaderState(false);
            } else if (old == RaftProtos.RaftPeerRole.CANDIDATE) {
                this.role.shutdownLeaderElection();
            } else if (old == RaftProtos.RaftPeerRole.FOLLOWER) {
                this.role.shutdownFollowerState();
            }
            this.role.startFollowerState(this);
        }
        return metadataUpdated;
    }

    synchronized void changeToFollowerAndPersistMetadata(long newTerm, Object reason) throws IOException {
        if (this.changeToFollower(newTerm, false, reason)) {
            this.state.persistMetadata();
        }
    }

    synchronized void changeToLeader() {
        Preconditions.assertTrue((boolean)this.isCandidate());
        this.role.shutdownLeaderElection();
        this.setRole(RaftProtos.RaftPeerRole.LEADER, (Object)"changeToLeader");
        this.state.becomeLeader();
        RaftProtos.LogEntryProto e = this.role.startLeaderState(this, this.getProxy().getProperties());
        this.getState().setRaftConf(e);
    }

    Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        ArrayList<RaftProtos.CommitInfoProto> infos = new ArrayList<RaftProtos.CommitInfoProto>();
        infos.add(this.updateCommitInfoCache());
        if (this.isLeader()) {
            this.role.getLeaderState().ifPresent(leader -> leader.updateFollowerCommitInfos(this.commitInfoCache, infos));
        } else {
            this.getRaftConf().getPeers().stream().map(RaftPeer::getId).filter(id -> !id.equals((Object)this.getId())).map(arg_0 -> ((CommitInfoCache)this.commitInfoCache).get(arg_0)).filter(Objects::nonNull).forEach(infos::add);
        }
        return infos;
    }

    GroupInfoReply getGroupInfo(GroupInfoRequest request) {
        return new GroupInfoReply((RaftClientRequest)request, this.getRoleInfoProto(), this.state.getStorage().getStorageDir().hasMetaFile(), this.getCommitInfos(), this.getGroup());
    }

    public RaftProtos.RoleInfoProto getRoleInfoProto() {
        RaftProtos.RaftPeerRole currentRole = this.role.getCurrentRole();
        RaftProtos.RoleInfoProto.Builder roleInfo = RaftProtos.RoleInfoProto.newBuilder().setSelf(this.getPeer().getRaftPeerProto()).setRole(currentRole).setRoleElapsedTimeMs(this.role.getRoleElapsedTimeMs());
        switch (1.$SwitchMap$org$apache$ratis$proto$RaftProtos$RaftPeerRole[currentRole.ordinal()]) {
            case 1: {
                RaftProtos.CandidateInfoProto.Builder candidate = RaftProtos.CandidateInfoProto.newBuilder().setLastLeaderElapsedTimeMs(this.state.getLastLeaderElapsedTimeMs());
                roleInfo.setCandidateInfo(candidate);
                break;
            }
            case 2: {
                this.role.getFollowerState().ifPresent(fs -> {
                    RaftProtos.ServerRpcProto leaderInfo = ServerProtoUtils.toServerRpcProto((RaftPeer)this.getRaftConf().getPeer(this.state.getLeaderId()), (long)fs.getLastRpcTime().elapsedTimeMs());
                    roleInfo.setFollowerInfo(RaftProtos.FollowerInfoProto.newBuilder().setLeaderInfo(leaderInfo).setOutstandingOp(fs.getOutstandingOp()));
                });
                break;
            }
            case 3: {
                this.role.getLeaderState().ifPresent(ls -> {
                    RaftProtos.LeaderInfoProto.Builder leader = RaftProtos.LeaderInfoProto.newBuilder();
                    ls.getLogAppenders().map(LogAppender::getFollower).forEach(f -> leader.addFollowerInfo(ServerProtoUtils.toServerRpcProto((RaftPeer)f.getPeer(), (long)f.getLastRpcResponseTime().elapsedTimeMs())));
                    roleInfo.setLeaderInfo(leader);
                });
                break;
            }
            default: {
                throw new IllegalStateException("incorrect role of server " + currentRole);
            }
        }
        return roleInfo.build();
    }

    synchronized void changeToCandidate() {
        Preconditions.assertTrue((boolean)this.isFollower());
        this.role.shutdownFollowerState();
        this.setRole(RaftProtos.RaftPeerRole.CANDIDATE, (Object)"changeToCandidate");
        if (this.state.shouldNotifyExtendedNoLeader()) {
            this.stateMachine.notifyExtendedNoLeader(this.getRoleInfoProto());
        }
        this.role.startLeaderElection(this);
        this.leaderElectionMetrics.onNewLeaderElection();
    }

    public String toString() {
        return this.role + " " + this.state + " " + this.lifeCycle.getCurrentState();
    }

    private CompletableFuture<RaftClientReply> checkLeaderState(RaftClientRequest request, RetryCache.CacheEntry entry) {
        try {
            this.assertGroup((Object)request.getRequestorId(), request.getRaftGroupId());
        }
        catch (GroupMismatchException e) {
            return RetryCache.failWithException((Throwable)e, (RetryCache.CacheEntry)entry);
        }
        if (!this.isLeader()) {
            NotLeaderException exception = this.generateNotLeaderException();
            RaftClientReply reply = new RaftClientReply(request, (RaftException)exception, this.getCommitInfos());
            return RetryCache.failWithReply((RaftClientReply)reply, (RetryCache.CacheEntry)entry);
        }
        LeaderState leaderState = this.role.getLeaderState().orElse(null);
        if (leaderState == null || !leaderState.isReady()) {
            RetryCache.CacheEntry cacheEntry = this.retryCache.get(request.getClientId(), request.getCallId());
            if (cacheEntry != null && cacheEntry.isCompletedNormally()) {
                return cacheEntry.getReplyFuture();
            }
            LeaderNotReadyException lnre = new LeaderNotReadyException(this.getMemberId());
            RaftClientReply reply = new RaftClientReply(request, (RaftException)lnre, this.getCommitInfos());
            return RetryCache.failWithReply((RaftClientReply)reply, (RetryCache.CacheEntry)entry);
        }
        return null;
    }

    public boolean isLeaderReady() {
        if (!this.isLeader()) {
            return false;
        }
        LeaderState leaderState = this.role.getLeaderState().orElse(null);
        return leaderState != null && leaderState.isReady();
    }

    NotLeaderException generateNotLeaderException() {
        if (this.lifeCycle.getCurrentState() != LifeCycle.State.RUNNING) {
            return new NotLeaderException(this.getMemberId(), null, null);
        }
        RaftPeerId leaderId = this.state.getLeaderId();
        if (leaderId == null || leaderId.equals((Object)this.getId())) {
            leaderId = null;
        }
        RaftConfiguration conf = this.getRaftConf();
        Collection peers = conf.getPeers();
        return new NotLeaderException(this.getMemberId(), conf.getPeer(leaderId), peers);
    }

    private LifeCycle.State assertLifeCycleState(Set<LifeCycle.State> expected) throws ServerNotReadyException {
        return this.lifeCycle.assertCurrentState((n, c) -> new ServerNotReadyException(this.getMemberId() + " is not in " + expected + ": current state is " + c), expected);
    }

    void assertGroup(Object requestorId, RaftGroupId requestorGroupId) throws GroupMismatchException {
        RaftGroupId groupId = this.getMemberId().getGroupId();
        if (!groupId.equals((Object)requestorGroupId)) {
            throw new GroupMismatchException(this.getMemberId() + ": The group (" + requestorGroupId + ") of " + requestorId + " does not match the group (" + groupId + ") of the server " + this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftClientReply> appendTransaction(RaftClientRequest request, TransactionContext context, RetryCache.CacheEntry cacheEntry) throws IOException {
        PendingRequest pending;
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            CompletableFuture reply = this.checkLeaderState(request, cacheEntry);
            if (reply != null) {
                return reply;
            }
            LeaderState leaderState = this.role.getLeaderStateNonNull();
            PendingRequests.Permit permit = leaderState.tryAcquirePendingRequest(request.getMessage());
            if (permit == null) {
                cacheEntry.failWithException((Throwable)new ResourceUnavailableException(this.getMemberId() + ": Failed to acquire a pending write request for " + request));
                return cacheEntry.getReplyFuture();
            }
            try {
                this.state.appendLog(context);
            }
            catch (StateMachineException e) {
                RaftClientReply exceptionReply = new RaftClientReply(request, (RaftException)e, this.getCommitInfos());
                cacheEntry.failWithReply(exceptionReply);
                if (this.isLeader()) {
                    leaderState.submitStepDownEvent();
                }
                return CompletableFuture.completedFuture(exceptionReply);
            }
            pending = leaderState.addPendingRequest(permit, request, context);
            if (pending == null) {
                cacheEntry.failWithException((Throwable)new ResourceUnavailableException(this.getMemberId() + ": Failed to add a pending write request for " + request));
                return cacheEntry.getReplyFuture();
            }
            leaderState.notifySenders();
        }
        return pending.getFuture();
    }

    public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) throws IOException {
        CompletableFuture<RaftClientReply> replyFuture;
        Timer.Context timerContext;
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        LOG.debug("{}: receive client request({})", (Object)this.getMemberId(), (Object)request);
        Timer timer = this.raftServerMetrics.getClientRequestTimer(request);
        Timer.Context context = timerContext = timer != null ? timer.time() : null;
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            replyFuture = this.staleReadAsync(request);
        } else {
            CompletableFuture reply = this.checkLeaderState(request, null);
            if (reply != null) {
                return reply;
            }
            RaftClientRequest.Type type = request.getType();
            if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.STREAM) && type.getStream().getEndOfRequest()) {
                CompletableFuture f = this.streamEndOfRequestAsync(request);
                if (f.isCompletedExceptionally()) {
                    return f.thenApply(r -> null);
                }
                request = (RaftClientRequest)f.join();
                type = request.getType();
            }
            if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
                replyFuture = this.processQueryFuture(this.stateMachine.query(request.getMessage()), request);
            } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
                replyFuture = this.watchAsync(request);
            } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.STREAM)) {
                replyFuture = this.streamAsync(request);
            } else {
                RetryCache.CacheQueryResult previousResult = this.retryCache.queryCache(request.getClientId(), request.getCallId());
                if (previousResult.isRetry()) {
                    replyFuture = previousResult.getEntry().getReplyFuture();
                } else {
                    RetryCache.CacheEntry cacheEntry = previousResult.getEntry();
                    TransactionContext context2 = this.stateMachine.startTransaction(request);
                    if (context2.getException() != null) {
                        RaftClientReply exceptionReply = new RaftClientReply(request, (RaftException)new StateMachineException(this.getMemberId(), (Throwable)context2.getException()), this.getCommitInfos());
                        cacheEntry.failWithReply(exceptionReply);
                        replyFuture = CompletableFuture.completedFuture(exceptionReply);
                    } else {
                        replyFuture = this.appendTransaction(request, context2, cacheEntry);
                    }
                }
            }
        }
        replyFuture.whenComplete((clientReply, exception) -> {
            if (clientReply.isSuccess() && timerContext != null) {
                timerContext.stop();
            }
        });
        return replyFuture;
    }

    private CompletableFuture<RaftClientReply> watchAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.addWatchReqeust(request)).orElseGet(() -> CompletableFuture.completedFuture(new RaftClientReply(request, (RaftException)this.generateNotLeaderException(), this.getCommitInfos())));
    }

    private CompletableFuture<RaftClientReply> staleReadAsync(RaftClientRequest request) {
        long minIndex = request.getType().getStaleRead().getMinIndex();
        long commitIndex = this.state.getLog().getLastCommittedIndex();
        LOG.debug("{}: minIndex={}, commitIndex={}", new Object[]{this.getMemberId(), minIndex, commitIndex});
        if (commitIndex < minIndex) {
            StaleReadException e = new StaleReadException("Unable to serve stale-read due to server commit index = " + commitIndex + " < min = " + minIndex);
            return CompletableFuture.completedFuture(new RaftClientReply(request, (RaftException)new StateMachineException(this.getMemberId(), (Throwable)e), this.getCommitInfos()));
        }
        return this.processQueryFuture(this.stateMachine.queryStale(request.getMessage(), minIndex), request);
    }

    private CompletableFuture<RaftClientReply> streamAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.streamAsync(request)).orElseGet(() -> CompletableFuture.completedFuture(new RaftClientReply(request, (RaftException)this.generateNotLeaderException(), this.getCommitInfos())));
    }

    private CompletableFuture<RaftClientRequest> streamEndOfRequestAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.streamEndOfRequestAsync(request)).orElse(null);
    }

    CompletableFuture<RaftClientReply> processQueryFuture(CompletableFuture<Message> queryFuture, RaftClientRequest request) {
        return ((CompletableFuture)queryFuture.thenApply(r -> new RaftClientReply(request, r, this.getCommitInfos()))).exceptionally(e -> {
            if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof StateMachineException) {
                return new RaftClientReply(request, (RaftException)((StateMachineException)((Object)e)), this.getCommitInfos());
            }
            throw new CompletionException((Throwable)e);
        });
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.waitForReply(request, this.submitClientRequestAsync(request));
    }

    RaftClientReply waitForReply(RaftClientRequest request, CompletableFuture<RaftClientReply> future) throws IOException {
        return RaftServerImpl.waitForReply((Object)this.getMemberId(), (RaftClientRequest)request, future, (T e) -> new RaftClientReply(request, e, this.getCommitInfos()));
    }

    static <REPLY extends RaftClientReply> REPLY waitForReply(Object id, RaftClientRequest request, CompletableFuture<REPLY> future, Function<RaftException, REPLY> exceptionReply) throws IOException {
        try {
            return (REPLY)((RaftClientReply)future.get());
        }
        catch (InterruptedException e) {
            String s = id + ": Interrupted when waiting for reply, request=" + request;
            LOG.info(s, (Throwable)e);
            throw IOUtils.toInterruptedIOException((String)s, (InterruptedException)e);
        }
        catch (ExecutionException e) {
            RaftClientReply reply;
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IOException(e);
            }
            if ((cause instanceof NotLeaderException || cause instanceof StateMachineException) && (reply = (RaftClientReply)exceptionReply.apply((RaftException)cause)) != null) {
                return (REPLY)reply;
            }
            throw IOUtils.asIOException((Throwable)cause);
        }
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.waitForReply((RaftClientRequest)request, this.setConfigurationAsync(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftClientReply> setConfigurationAsync(SetConfigurationRequest request) throws IOException {
        PendingRequest pending;
        LOG.info("{}: receive setConfiguration {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup((Object)request.getRequestorId(), request.getRaftGroupId());
        CompletableFuture reply = this.checkLeaderState((RaftClientRequest)request, null);
        if (reply != null) {
            return reply;
        }
        List peersInNewConf = request.getPeersInNewConf();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            reply = this.checkLeaderState((RaftClientRequest)request, null);
            if (reply != null) {
                return reply;
            }
            RaftConfiguration current = this.getRaftConf();
            LeaderState leaderState = this.role.getLeaderStateNonNull();
            if (!current.isStable() || leaderState.inStagingState() || !this.state.isConfCommitted()) {
                throw new ReconfigurationInProgressException("Reconfiguration is already in progress: " + current);
            }
            if (current.hasNoChange((Collection)peersInNewConf)) {
                PendingRequest pending2 = new PendingRequest(request);
                pending2.setReply(new RaftClientReply((RaftClientRequest)request, this.getCommitInfos()));
                return pending2.getFuture();
            }
            this.getServerRpc().addPeers((Iterable)peersInNewConf);
            pending = leaderState.startSetConfiguration(request);
        }
        return pending.getFuture();
    }

    private boolean shouldWithholdVotes(long candidateTerm) {
        if (this.state.getCurrentTerm() < candidateTerm) {
            return false;
        }
        if (this.isLeader()) {
            return true;
        }
        return this.isFollower() && this.state.hasLeader() && this.role.getFollowerState().map(FollowerState::shouldWithholdVotes).orElse(false) != false;
    }

    private boolean shouldSendShutdown(RaftPeerId candidateId, TermIndex candidateLastEntry) {
        return this.isLeader() && this.getRaftConf().isStable() && this.getState().isConfCommitted() && !this.getRaftConf().containsInConf(candidateId) && candidateLastEntry.getIndex() < this.getRaftConf().getLogEntryIndex() && this.role.getLeaderState().map(ls -> !ls.isBootStrappingPeer(candidateId)).orElse(false) != false;
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        return this.requestVote(RaftPeerId.valueOf((ByteString)request.getRequestorId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), r.getCandidateTerm(), ServerProtoUtils.toTermIndex((RaftProtos.TermIndexProto)r.getCandidateLastEntry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.RequestVoteReplyProto requestVote(RaftPeerId candidateId, RaftGroupId candidateGroupId, long candidateTerm, TermIndex candidateLastEntry) throws IOException {
        RaftProtos.RequestVoteReplyProto reply;
        CodeInjectionForTesting.execute((String)REQUEST_VOTE, (Object)this.getId(), (Object)candidateId, (Object[])new Object[]{candidateTerm, candidateLastEntry});
        LOG.debug("{}: receive requestVote({}, {}, {}, {})", new Object[]{this.getMemberId(), candidateId, candidateGroupId, candidateTerm, candidateLastEntry});
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup((Object)candidateId, candidateGroupId);
        boolean voteGranted = false;
        boolean shouldShutdown = false;
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            FollowerState fs = this.role.getFollowerState().orElse(null);
            if (this.shouldWithholdVotes(candidateTerm)) {
                LOG.info("{}-{}: Withhold vote from candidate {} with term {}. State: leader={}, term={}, lastRpcElapsed={}", new Object[]{this.getMemberId(), this.role, candidateId, candidateTerm, this.state.getLeaderId(), this.state.getCurrentTerm(), fs != null ? fs.getLastRpcTime().elapsedTimeMs() + "ms" : null});
            } else if (this.state.recognizeCandidate(candidateId, candidateTerm)) {
                boolean termUpdated = this.changeToFollower(candidateTerm, true, (Object)("recognizeCandidate:" + candidateId));
                if (this.state.isLogUpToDate(candidateLastEntry) && fs != null) {
                    this.state.grantVote(candidateId);
                    voteGranted = true;
                }
                if (termUpdated || voteGranted) {
                    this.state.persistMetadata();
                }
            }
            if (voteGranted) {
                fs.updateLastRpcTime(FollowerState.UpdateType.REQUEST_VOTE);
            } else if (this.shouldSendShutdown(candidateId, candidateLastEntry)) {
                shouldShutdown = true;
            }
            reply = ServerProtoUtils.toRequestVoteReplyProto((RaftPeerId)candidateId, (RaftGroupMemberId)this.getMemberId(), (boolean)voteGranted, (long)this.state.getCurrentTerm(), (boolean)shouldShutdown);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} replies to vote request: {}. Peer's state: {}", new Object[]{this.getMemberId(), ServerProtoUtils.toString((RaftProtos.RequestVoteReplyProto)reply), this.state});
            }
        }
        return reply;
    }

    private void validateEntries(long expectedTerm, TermIndex previous, RaftProtos.LogEntryProto ... entries) {
        if (entries != null && entries.length > 0) {
            long index0 = entries[0].getIndex();
            if (previous == null || previous.getTerm() == 0L) {
                Preconditions.assertTrue((index0 == 0L ? 1 : 0) != 0, (String)"Unexpected Index: previous is null but entries[%s].getIndex()=%s", (Object[])new Object[]{0, index0});
            } else {
                Preconditions.assertTrue((previous.getIndex() == index0 - 1L ? 1 : 0) != 0, (String)"Unexpected Index: previous is %s but entries[%s].getIndex()=%s", (Object[])new Object[]{previous, 0, index0});
            }
            for (int i = 0; i < entries.length; ++i) {
                long t = entries[i].getTerm();
                Preconditions.assertTrue((expectedTerm >= t ? 1 : 0) != 0, (String)"Unexpected Term: entries[%s].getTerm()=%s but expectedTerm=%s", (Object[])new Object[]{i, t, expectedTerm});
                long indexi = entries[i].getIndex();
                Preconditions.assertTrue((indexi == index0 + (long)i ? 1 : 0) != 0, (String)"Unexpected Index: entries[%s].getIndex()=%s but entries[0].getIndex()=%s", (Object[])new Object[]{i, indexi, index0});
            }
        }
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        try {
            return (RaftProtos.AppendEntriesReplyProto)this.appendEntriesAsync(r).join();
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException((Throwable)JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        RaftProtos.LogEntryProto[] entries = r.getEntriesList().toArray(new RaftProtos.LogEntryProto[r.getEntriesCount()]);
        TermIndex previous = r.hasPreviousLog() ? ServerProtoUtils.toTermIndex((RaftProtos.TermIndexProto)r.getPreviousLog()) : null;
        RaftPeerId requestorId = RaftPeerId.valueOf((ByteString)request.getRequestorId());
        this.preAppendEntriesAsync(requestorId, ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), r.getLeaderTerm(), previous, r.getLeaderCommit(), r.getInitializing(), entries);
        try {
            return this.appendEntriesAsync(requestorId, r.getLeaderTerm(), previous, r.getLeaderCommit(), request.getCallId(), r.getInitializing(), r.getCommitInfosList(), entries);
        }
        catch (Throwable t) {
            LOG.error("{}: Failed appendEntriesAsync {}", new Object[]{this.getMemberId(), r, t});
            throw t;
        }
    }

    static void logAppendEntries(boolean isHeartbeat, Supplier<String> message) {
        if (isHeartbeat) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("HEARTBEAT: " + message.get());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(message.get());
        }
    }

    private Optional<FollowerState> updateLastRpcTime(FollowerState.UpdateType updateType) {
        Optional fs = this.role.getFollowerState();
        if (fs.isPresent() && this.lifeCycle.getCurrentState() == LifeCycle.State.RUNNING) {
            ((FollowerState)fs.get()).updateLastRpcTime(updateType);
            return fs;
        }
        return Optional.empty();
    }

    private void preAppendEntriesAsync(RaftPeerId leaderId, RaftGroupId leaderGroupId, long leaderTerm, TermIndex previous, long leaderCommit, boolean initializing, RaftProtos.LogEntryProto ... entries) throws IOException {
        CodeInjectionForTesting.execute((String)APPEND_ENTRIES, (Object)this.getId(), (Object)leaderId, (Object[])new Object[]{leaderTerm, previous, leaderCommit, initializing, entries});
        this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        if (!this.startComplete.get()) {
            throw new ServerNotReadyException(this.getMemberId() + ": The server role is not yet initialized.");
        }
        this.assertGroup((Object)leaderId, leaderGroupId);
        try {
            this.validateEntries(leaderTerm, previous, entries);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private RaftProtos.CommitInfoProto updateCommitInfoCache() {
        return this.commitInfoCache.update(this.getPeer(), this.state.getLog().getLastCommittedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftPeerId leaderId, long leaderTerm, TermIndex previous, long leaderCommit, long callId, boolean initializing, List<RaftProtos.CommitInfoProto> commitInfos, RaftProtos.LogEntryProto ... entries) {
        Optional followerState;
        long currentTerm;
        boolean isHeartbeat = entries.length == 0;
        RaftServerImpl.logAppendEntries((boolean)isHeartbeat, () -> this.getMemberId() + ": receive appendEntries(" + leaderId + ", " + leaderTerm + ", " + previous + ", " + leaderCommit + ", " + initializing + ", commits" + ProtoUtils.toString((Collection)commitInfos) + ", entries: " + ServerProtoUtils.toString((RaftProtos.LogEntryProto[])entries));
        long followerCommit = this.state.getLog().getLastCommittedIndex();
        Timer.Context timer = this.raftServerMetrics.getFollowerAppendEntryTimer(isHeartbeat).time();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (long)followerCommit, (long)this.state.getNextIndex(), (RaftProtos.AppendEntriesReplyProto.AppendResult)RaftProtos.AppendEntriesReplyProto.AppendResult.NOT_LEADER, (long)callId, (long)-1L, (boolean)isHeartbeat);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Not recognize {} (term={}) as leader, state: {} reply: {}", new Object[]{this.getMemberId(), leaderId, leaderTerm, this.state, ServerProtoUtils.toString((RaftProtos.AppendEntriesReplyProto)reply)});
                }
                return CompletableFuture.completedFuture(reply);
            }
            try {
                this.changeToFollowerAndPersistMetadata(leaderTerm, (Object)"appendEntries");
            }
            catch (IOException e) {
                return JavaUtils.completeExceptionally((Throwable)e);
            }
            this.state.setLeader(leaderId, "appendEntries");
            if (!initializing && this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING)) {
                this.role.startFollowerState(this);
            }
            followerState = this.updateLastRpcTime(FollowerState.UpdateType.APPEND_START);
            RaftProtos.AppendEntriesReplyProto inconsistencyReply = this.checkInconsistentAppendEntries(leaderId, currentTerm, followerCommit, previous, callId, isHeartbeat, entries);
            if (inconsistencyReply != null) {
                followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE));
                return CompletableFuture.completedFuture(inconsistencyReply);
            }
            this.state.updateConfiguration(entries);
        }
        List futures = entries.length == 0 ? Collections.emptyList() : this.state.getLog().append(entries);
        commitInfos.forEach(arg_0 -> ((CommitInfoCache)this.commitInfoCache).update(arg_0));
        if (!isHeartbeat) {
            CodeInjectionForTesting.execute((String)RaftLog.LOG_SYNC, (Object)this.getId(), null, (Object[])new Object[0]);
        }
        return ((CompletableFuture)JavaUtils.allOf((Collection)futures).whenCompleteAsync((r, t) -> followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE)))).thenApply(v -> {
            RaftProtos.AppendEntriesReplyProto reply;
            RaftServerImpl raftServerImpl = this;
            synchronized (raftServerImpl) {
                this.state.updateStatemachine(leaderCommit, currentTerm);
                this.updateCommitInfoCache();
                long n = isHeartbeat ? this.state.getLog().getNextIndex() : entries[entries.length - 1].getIndex() + 1L;
                long matchIndex = entries.length != 0 ? entries[entries.length - 1].getIndex() : -1L;
                reply = ServerProtoUtils.toAppendEntriesReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (long)this.state.getLog().getLastCommittedIndex(), (long)n, (RaftProtos.AppendEntriesReplyProto.AppendResult)RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS, (long)callId, (long)matchIndex, (boolean)isHeartbeat);
            }
            RaftServerImpl.logAppendEntries((boolean)isHeartbeat, () -> this.getMemberId() + ": succeeded to handle AppendEntries. Reply: " + ServerProtoUtils.toString((RaftProtos.AppendEntriesReplyProto)reply));
            timer.stop();
            return reply;
        });
    }

    private RaftProtos.AppendEntriesReplyProto checkInconsistentAppendEntries(RaftPeerId leaderId, long currentTerm, long followerCommit, TermIndex previous, long callId, boolean isHeartbeat, RaftProtos.LogEntryProto ... entries) {
        long replyNextIndex = this.checkInconsistentAppendEntries(previous, entries);
        if (replyNextIndex == -1L) {
            return null;
        }
        RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (long)followerCommit, (long)replyNextIndex, (RaftProtos.AppendEntriesReplyProto.AppendResult)RaftProtos.AppendEntriesReplyProto.AppendResult.INCONSISTENCY, (long)callId, (long)-1L, (boolean)isHeartbeat);
        LOG.info("{}: inconsistency entries. Reply:{}", (Object)this.getMemberId(), (Object)ServerProtoUtils.toString((RaftProtos.AppendEntriesReplyProto)reply));
        return reply;
    }

    private long checkInconsistentAppendEntries(TermIndex previous, RaftProtos.LogEntryProto ... entries) {
        TermIndex installSnapshot = (TermIndex)this.inProgressInstallSnapshotRequest.get();
        if (installSnapshot != null) {
            LOG.info("{}: Failed appendEntries as snapshot ({}) installation is in progress", (Object)this.getMemberId(), (Object)installSnapshot);
            return this.state.getNextIndex();
        }
        if (entries != null && entries.length > 0) {
            long firstEntryIndex = entries[0].getIndex();
            long snapshotIndex = this.state.getSnapshotIndex();
            if (snapshotIndex > 0L && snapshotIndex >= firstEntryIndex) {
                LOG.info("{}: Failed appendEntries: the first entry (index {}) is already in snapshot (snapshot index: {})", new Object[]{this.getMemberId(), firstEntryIndex, snapshotIndex});
                return snapshotIndex + 1L;
            }
            long commitIndex = this.state.getLog().getLastCommittedIndex();
            if (commitIndex > 0L && commitIndex >= firstEntryIndex) {
                LOG.info("{}: Failed appendEntries: the first entry (index {}) is already committed (commit index: {})", new Object[]{this.getMemberId(), firstEntryIndex, commitIndex});
                return commitIndex + 1L;
            }
        }
        if (previous != null && !this.state.containsTermIndex(previous)) {
            long replyNextIndex = Math.min(this.state.getNextIndex(), previous.getIndex());
            LOG.info("{}: Failed appendEntries as previous log entry ({}) is not found", (Object)this.getMemberId(), (Object)previous);
            return replyNextIndex;
        }
        return -1L;
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.InstallSnapshotReplyProto reply;
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: receive installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerProtoUtils.toString((RaftProtos.InstallSnapshotRequestProto)request));
        }
        try {
            reply = this.installSnapshotImpl(request);
        }
        catch (Throwable t) {
            LOG.error("{}: installSnapshot failed", (Object)this.getMemberId(), (Object)t);
            throw t;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: reply installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerProtoUtils.toString((RaftProtos.InstallSnapshotReplyProto)reply));
        }
        return reply;
    }

    private RaftProtos.InstallSnapshotReplyProto installSnapshotImpl(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.RaftRpcRequestProto r = request.getServerRequest();
        RaftPeerId leaderId = RaftPeerId.valueOf((ByteString)r.getRequestorId());
        RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)r.getRaftGroupId());
        CodeInjectionForTesting.execute((String)INSTALL_SNAPSHOT, (Object)this.getId(), (Object)leaderId, (Object[])new Object[]{request});
        this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        this.assertGroup((Object)leaderId, leaderGroupId);
        if (this.installSnapshotEnabled) {
            if (request.hasSnapshotChunk()) {
                return this.checkAndInstallSnapshot(request, leaderId);
            }
        } else if (request.hasNotification()) {
            return this.notifyStateMachineToInstallSnapshot(request, leaderId);
        }
        RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.CONF_MISMATCH);
        LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", new Object[]{this.getMemberId(), "raft.server.log.appender.install.snapshot.enabled", leaderId, request.hasSnapshotChunk(), this.getId(), this.installSnapshotEnabled});
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto checkAndInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long currentTerm;
        long leaderTerm = request.getLeaderTerm();
        RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto snapshotChunkRequest = request.getSnapshotChunk();
        TermIndex lastTermIndex = ServerProtoUtils.toTermIndex((RaftProtos.TermIndexProto)snapshotChunkRequest.getTermIndex());
        long lastIncludedIndex = lastTermIndex.getIndex();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (int)snapshotChunkRequest.getRequestIndex(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.NOT_LEADER);
                LOG.warn("{}: Failed to recognize leader for installSnapshot chunk.", (Object)this.getMemberId());
                return reply;
            }
            this.changeToFollowerAndPersistMetadata(leaderTerm, (Object)"installSnapshot");
            this.state.setLeader(leaderId, "installSnapshot");
            this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_START);
            try {
                Preconditions.assertTrue((this.state.getLog().getNextIndex() <= lastIncludedIndex ? 1 : 0) != 0, (String)"%s log's next id is %s, last included index in snapshot is %s", (Object[])new Object[]{this.getMemberId(), this.state.getLog().getNextIndex(), lastIncludedIndex});
                this.state.installSnapshot(request);
                if (snapshotChunkRequest.getDone()) {
                    this.state.reloadStateMachine(lastIncludedIndex);
                }
            }
            finally {
                this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_COMPLETE);
            }
        }
        if (snapshotChunkRequest.getDone()) {
            LOG.info("{}: successfully install the entire snapshot-{}", (Object)this.getMemberId(), (Object)lastIncludedIndex);
        }
        return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (int)snapshotChunkRequest.getRequestIndex(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto notifyStateMachineToInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long leaderTerm = request.getLeaderTerm();
        TermIndex firstAvailableLogTermIndex = ServerProtoUtils.toTermIndex((RaftProtos.TermIndexProto)request.getNotification().getFirstAvailableTermIndex());
        long firstAvailableLogIndex = firstAvailableLogTermIndex.getIndex();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            long currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply2 = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.NOT_LEADER, (long)-1L);
                LOG.warn("{}: Failed to recognize leader for installSnapshot notification.", (Object)this.getMemberId());
                return reply2;
            }
            this.changeToFollowerAndPersistMetadata(leaderTerm, (Object)"installSnapshot");
            this.state.setLeader(leaderId, "installSnapshot");
            this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_NOTIFICATION);
            if (this.inProgressInstallSnapshotRequest.compareAndSet(null, firstAvailableLogTermIndex)) {
                long snapshotIndex = this.state.getSnapshotIndex();
                if (snapshotIndex + 1L >= firstAvailableLogIndex) {
                    this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogTermIndex, null);
                    RaftProtos.InstallSnapshotReplyProto reply3 = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, (long)snapshotIndex);
                    LOG.info("{}: StateMachine snapshotIndex is {}", (Object)this.getMemberId(), (Object)snapshotIndex);
                    return reply3;
                }
                LOG.info("{}: notifyInstallSnapshot: nextIndex is {} but the leader's first available index is {}.", new Object[]{this.getMemberId(), this.state.getLog().getNextIndex(), firstAvailableLogIndex});
                try {
                    this.stateMachine.notifyInstallSnapshotFromLeader(this.getRoleInfoProto(), firstAvailableLogTermIndex).whenComplete((reply, exception) -> {
                        if (exception != null) {
                            LOG.warn("{}: Failed to notify StateMachine to InstallSnapshot. Exception: {}", (Object)this.getMemberId(), (Object)exception.getMessage());
                            this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogTermIndex, null);
                            return;
                        }
                        if (reply != null) {
                            LOG.info("{}: StateMachine successfully installed snapshot index {}. Reloading the StateMachine.", (Object)this.getMemberId(), (Object)reply.getIndex());
                            this.stateMachine.pause();
                            this.state.updateInstalledSnapshotIndex(reply);
                            this.state.reloadStateMachine(reply.getIndex());
                        }
                        this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogTermIndex, null);
                    });
                }
                catch (Throwable t) {
                    this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogTermIndex, null);
                    throw t;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Snapshot Installation Request received and is in progress", (Object)this.getMemberId());
                }
            } else {
                LOG.info("{}: Snapshot Installation by StateMachine is in progress.", (Object)this.getMemberId());
            }
            return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.IN_PROGRESS, (long)-1L);
        }
    }

    synchronized RaftProtos.InstallSnapshotRequestProto createInstallSnapshotRequest(RaftPeerId targetId, String requestId, int requestIndex, SnapshotInfo snapshot, List<RaftProtos.FileChunkProto> chunks, boolean done) {
        OptionalLong totalSize = snapshot.getFiles().stream().mapToLong(FileInfo::getFileSize).reduce(Long::sum);
        assert (totalSize.isPresent());
        return ServerProtoUtils.toInstallSnapshotRequestProto((RaftGroupMemberId)this.getMemberId(), (RaftPeerId)targetId, (String)requestId, (int)requestIndex, (long)this.state.getCurrentTerm(), (TermIndex)snapshot.getTermIndex(), chunks, (long)totalSize.getAsLong(), (boolean)done);
    }

    synchronized RaftProtos.InstallSnapshotRequestProto createInstallSnapshotRequest(RaftPeerId targetId, TermIndex firstAvailableLogTermIndex) {
        assert (firstAvailableLogTermIndex.getIndex() > 0L);
        return ServerProtoUtils.toInstallSnapshotRequestProto((RaftGroupMemberId)this.getMemberId(), (RaftPeerId)targetId, (long)this.state.getCurrentTerm(), (TermIndex)firstAvailableLogTermIndex);
    }

    synchronized RaftProtos.RequestVoteRequestProto createRequestVoteRequest(RaftPeerId targetId, long term, TermIndex lastEntry) {
        return ServerProtoUtils.toRequestVoteRequestProto((RaftGroupMemberId)this.getMemberId(), (RaftPeerId)targetId, (long)term, (TermIndex)lastEntry);
    }

    public void submitUpdateCommitEvent() {
        this.role.getLeaderState().ifPresent(LeaderState::submitUpdateCommitEvent);
    }

    private CompletableFuture<Message> replyPendingRequest(RaftProtos.LogEntryProto logEntry, CompletableFuture<Message> stateMachineFuture) {
        Preconditions.assertTrue((boolean)logEntry.hasStateMachineLogEntry());
        RaftProtos.StateMachineLogEntryProto smLog = logEntry.getStateMachineLogEntry();
        ClientId clientId = ClientId.valueOf((ByteString)smLog.getClientId());
        long callId = smLog.getCallId();
        RetryCache.CacheEntry cacheEntry = this.retryCache.getOrCreateEntry(clientId, callId);
        if (this.isLeader()) {
            Preconditions.assertTrue((cacheEntry != null && !cacheEntry.isCompletedNormally() ? 1 : 0) != 0, (String)"retry cache entry should be pending: %s", (Object[])new Object[]{cacheEntry});
        }
        if (cacheEntry.isFailed()) {
            this.retryCache.refreshEntry(new RetryCache.CacheEntry(cacheEntry.getKey()));
        }
        long logIndex = logEntry.getIndex();
        return stateMachineFuture.whenComplete((reply, exception) -> {
            RaftClientReply r;
            if (exception == null) {
                r = new RaftClientReply(clientId, this.getMemberId(), callId, true, reply, null, logIndex, this.getCommitInfos());
            } else {
                StateMachineException e = new StateMachineException(this.getMemberId(), exception);
                r = new RaftClientReply(clientId, this.getMemberId(), callId, false, null, (RaftException)e, logIndex, this.getCommitInfos());
            }
            RaftServerImpl raftServerImpl = this;
            synchronized (raftServerImpl) {
                LeaderState leaderState = this.role.getLeaderState().orElse(null);
                if (this.isLeader() && leaderState != null) {
                    leaderState.replyPendingRequest(logIndex, r);
                }
            }
            cacheEntry.updateResult(r);
        });
    }

    public long[] getFollowerNextIndices() {
        if (!this.isLeader()) {
            return null;
        }
        return this.role.getLeaderState().map(LeaderState::getFollowerNextIndices).orElse(null);
    }

    CompletableFuture<Message> applyLogToStateMachine(RaftProtos.LogEntryProto next) {
        if (!next.hasStateMachineLogEntry()) {
            this.stateMachine.notifyIndexUpdate(next.getTerm(), next.getIndex());
        }
        if (next.hasConfigurationEntry()) {
            this.state.writeRaftConfiguration(next);
        } else if (next.hasStateMachineLogEntry()) {
            TransactionContext trx = this.role.getLeaderState().map(leader -> leader.getTransactionContext(next.getIndex())).orElseGet(() -> TransactionContext.newBuilder().setServerRole(this.role.getCurrentRole()).setStateMachine(this.stateMachine).setLogEntry(next).build());
            trx = this.stateMachine.applyTransactionSerial(trx);
            try {
                CompletableFuture stateMachineFuture = this.stateMachine.applyTransaction(trx);
                return this.replyPendingRequest(next, stateMachineFuture);
            }
            catch (Throwable e) {
                LOG.error("{}: applyTransaction failed for index:{} proto:{}", new Object[]{this.getMemberId(), next.getIndex(), ServerProtoUtils.toString((RaftProtos.LogEntryProto[])new RaftProtos.LogEntryProto[]{next}), e});
                throw e;
            }
        }
        return null;
    }

    public void notifyTruncatedLogEntry(RaftProtos.LogEntryProto logEntry) {
        if (logEntry.hasStateMachineLogEntry()) {
            RaftProtos.StateMachineLogEntryProto smLog = logEntry.getStateMachineLogEntry();
            ClientId clientId = ClientId.valueOf((ByteString)smLog.getClientId());
            long callId = smLog.getCallId();
            RetryCache.CacheEntry cacheEntry = this.getRetryCache().get(clientId, callId);
            if (cacheEntry != null) {
                RaftClientReply reply = new RaftClientReply(clientId, this.getMemberId(), callId, false, null, (RaftException)this.generateNotLeaderException(), logEntry.getIndex(), this.getCommitInfos());
                cacheEntry.failWithReply(reply);
            }
        }
    }

    public LeaderElectionMetrics getLeaderElectionMetrics() {
        return this.leaderElectionMetrics;
    }

    public RaftServerMetrics getRaftServerMetrics() {
        return this.raftServerMetrics;
    }

    static /* synthetic */ RoleInfo access$100(RaftServerImpl x0) {
        return x0.role;
    }
}

