/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.Preconditions;

public final class RaftServerMetrics
extends RatisMetrics {
    public static final String RATIS_SERVER_METRICS = "server";
    public static final String RATIS_SERVER_METRICS_DESC = "Metrics for Raft server";
    public static final String FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC = "%s_lastHeartbeatElapsedTime";
    public static final String LEADER_METRIC_PEER_COMMIT_INDEX = "%s_peerCommitIndex";
    public static final String RAFT_CLIENT_READ_REQUEST = "clientReadRequest";
    public static final String RAFT_CLIENT_STALE_READ_REQUEST = "clientStaleReadRequest";
    public static final String RAFT_CLIENT_WRITE_REQUEST = "clientWriteRequest";
    public static final String RAFT_CLIENT_WATCH_REQUEST = "clientWatch%sRequest";
    public static final String REQUEST_QUEUE_LIMIT_HIT_COUNTER = "numRequestQueueLimitHits";
    public static final String RESOURCE_LIMIT_HIT_COUNTER = "leaderNumResourceLimitHits";
    public static final String REQUEST_BYTE_SIZE_LIMIT_HIT_COUNTER = "numRequestsByteSizeLimitHits";
    public static final String REQUEST_QUEUE_SIZE = "numPendingRequestInQueue";
    public static final String REQUEST_BYTE_SIZE = "numPendingRequestByteSize";
    public static final String RETRY_CACHE_ENTRY_COUNT_METRIC = "retryCacheEntryCount";
    public static final String RETRY_CACHE_HIT_COUNT_METRIC = "retryCacheHitCount";
    public static final String RETRY_CACHE_HIT_RATE_METRIC = "retryCacheHitRate";
    public static final String RETRY_CACHE_MISS_COUNT_METRIC = "retryCacheMissCount";
    public static final String RETRY_CACHE_MISS_RATE_METRIC = "retryCacheMissRate";
    private Map<String, Long> followerLastHeartbeatElapsedTimeMap = new HashMap();
    private CommitInfoCache commitInfoCache;
    private static Map<String, RaftServerMetrics> metricsMap = new ConcurrentHashMap();

    public static RaftServerMetrics getRaftServerMetrics(RaftServerImpl raftServer) {
        RaftServerMetrics serverMetrics = new RaftServerMetrics(raftServer);
        metricsMap.put(raftServer.getMemberId().toString(), serverMetrics);
        return serverMetrics;
    }

    public static void removeRaftServerMetrics(RaftServerImpl raftServer) {
        String memberId = raftServer.getMemberId().toString();
        if (metricsMap.containsKey(memberId)) {
            metricsMap.remove(memberId);
        }
    }

    private RaftServerMetrics(RaftServerImpl server) {
        this.registry = this.getMetricRegistryForRaftServer(server.getMemberId().toString());
        this.commitInfoCache = server.getCommitInfoCache();
        this.addPeerCommitIndexGauge(server.getId());
        this.addRetryCacheMetric(server);
    }

    private RatisMetricRegistry getMetricRegistryForRaftServer(String serverId) {
        return this.create(new MetricRegistryInfo(serverId, "ratis", RATIS_SERVER_METRICS, RATIS_SERVER_METRICS_DESC));
    }

    private void addRetryCacheMetric(RaftServerImpl raftServer) {
        this.registry.gauge(RETRY_CACHE_ENTRY_COUNT_METRIC, () -> () -> raftServer.getRetryCache().size());
        this.registry.gauge(RETRY_CACHE_HIT_COUNT_METRIC, () -> () -> raftServer.getRetryCache().stats().hitCount());
        this.registry.gauge(RETRY_CACHE_HIT_RATE_METRIC, () -> () -> raftServer.getRetryCache().stats().hitRate());
        this.registry.gauge(RETRY_CACHE_MISS_COUNT_METRIC, () -> () -> raftServer.getRetryCache().stats().missCount());
        this.registry.gauge(RETRY_CACHE_MISS_RATE_METRIC, () -> () -> raftServer.getRetryCache().stats().missRate());
    }

    public void addFollower(RaftPeer peer) {
        String followerName = peer.getId().toString();
        String followerHbMetricKey = String.format(FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC, followerName);
        this.followerLastHeartbeatElapsedTimeMap.put(followerName, 0L);
        this.registry.gauge(followerHbMetricKey, () -> () -> (Long)this.followerLastHeartbeatElapsedTimeMap.get(followerName));
        this.addPeerCommitIndexGauge(peer.getId());
    }

    public void addPeerCommitIndexGauge(RaftPeerId peerId) {
        String followerCommitIndexKey = String.format(LEADER_METRIC_PEER_COMMIT_INDEX, peerId);
        this.registry.gauge(followerCommitIndexKey, () -> () -> {
            RaftProtos.CommitInfoProto commitInfoProto = this.commitInfoCache.get(peerId);
            if (commitInfoProto != null) {
                return commitInfoProto.getCommitIndex();
            }
            return 0L;
        });
    }

    @VisibleForTesting
    public static Gauge getPeerCommitIndexGauge(RaftServerImpl server, RaftServerImpl peerServer) {
        RaftServerMetrics serverMetrics = (RaftServerMetrics)metricsMap.get(server.getMemberId().toString());
        if (serverMetrics == null) {
            return null;
        }
        String followerCommitIndexKey = String.format(LEADER_METRIC_PEER_COMMIT_INDEX, peerServer.getPeer().getId().toString());
        SortedMap map = serverMetrics.registry.getGauges((s, metric) -> s.contains(followerCommitIndexKey));
        Preconditions.assertTrue((map.size() <= 1 ? 1 : 0) != 0);
        return (Gauge)map.get(map.firstKey());
    }

    public void recordFollowerHeartbeatElapsedTime(RaftPeer peer, long elapsedTime) {
        this.followerLastHeartbeatElapsedTimeMap.put(peer.getId().toString(), elapsedTime);
    }

    public Timer getFollowerAppendEntryTimer(boolean isHeartbeat) {
        return this.registry.timer("follower_append_entry_latency" + (isHeartbeat ? "_heartbeat" : ""));
    }

    public Timer getTimer(String timerName) {
        return this.registry.timer(timerName);
    }

    public Counter getCounter(String counterName) {
        return this.registry.counter(counterName);
    }

    public Timer getClientRequestTimer(RaftClientRequest request) {
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
            return this.getTimer(RAFT_CLIENT_READ_REQUEST);
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            return this.getTimer(RAFT_CLIENT_STALE_READ_REQUEST);
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            String watchType = RaftClientRequest.Type.toString((RaftProtos.ReplicationLevel)request.getType().getWatch().getReplication());
            return this.getTimer(String.format(RAFT_CLIENT_WATCH_REQUEST, watchType));
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE)) {
            return this.getTimer(RAFT_CLIENT_WRITE_REQUEST);
        }
        return null;
    }

    public void onRequestQueueLimitHit() {
        this.registry.counter(REQUEST_QUEUE_LIMIT_HIT_COUNTER).inc();
    }

    void addNumPendingRequestsGauge(Gauge queueSize) {
        this.registry.gauge(REQUEST_QUEUE_SIZE, () -> queueSize);
    }

    boolean removeNumPendingRequestsGauge() {
        return this.registry.remove(REQUEST_QUEUE_SIZE);
    }

    void addNumPendingRequestsByteSize(Gauge byteSize) {
        this.registry.gauge(REQUEST_BYTE_SIZE, () -> byteSize);
    }

    boolean removeNumPendingRequestsByteSize() {
        return this.registry.remove(REQUEST_BYTE_SIZE);
    }

    void onRequestByteSizeLimitHit() {
        this.registry.counter(REQUEST_BYTE_SIZE_LIMIT_HIT_COUNTER).inc();
    }

    void onResourceLimitHit() {
        this.registry.counter(RESOURCE_LIMIT_HIT_COUNTER).inc();
    }

    public RatisMetricRegistry getRegistry() {
        return this.registry;
    }
}

