/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.server.impl.StateMachineUpdater;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftServerTestUtil {
    static final Logger LOG = LoggerFactory.getLogger(RaftServerTestUtil.class);

    public static void setWatchRequestsLogLevel(Level level) {
        Log4jUtils.setLogLevel((Logger)WatchRequests.LOG, (Level)level);
    }

    public static void setPendingRequestsLogLevel(Level level) {
        Log4jUtils.setLogLevel((Logger)PendingRequests.LOG, (Level)level);
    }

    public static void waitAndCheckNewConf(MiniRaftCluster cluster, RaftPeer[] peers, int numOfRemovedPeers, Collection<RaftPeerId> deadPeers) throws Exception {
        TimeDuration sleepTime = cluster.getTimeoutMax().apply(n -> n * (long)(numOfRemovedPeers + 2));
        JavaUtils.attempt(() -> RaftServerTestUtil.waitAndCheckNewConf((MiniRaftCluster)cluster, Arrays.asList(peers), (Collection)deadPeers), (int)10, (TimeDuration)sleepTime, (String)"waitAndCheckNewConf", (Logger)LOG);
    }

    private static void waitAndCheckNewConf(MiniRaftCluster cluster, Collection<RaftPeer> peers, Collection<RaftPeerId> deadPeers) {
        LOG.info("waitAndCheckNewConf: peers={}, deadPeers={}, {}", new Object[]{peers, deadPeers, cluster.printServers()});
        Assert.assertNotNull((Object)cluster.getLeader());
        int numIncluded = 0;
        int deadIncluded = 0;
        RaftConfiguration current = RaftConfiguration.newBuilder().setConf(peers).setLogEntryIndex(0L).build();
        for (RaftServerImpl server : cluster.iterateServerImpls()) {
            LOG.info("checking {}", (Object)server);
            if (deadPeers != null && deadPeers.contains(server.getId())) {
                if (!current.containsInConf(server.getId())) continue;
                ++deadIncluded;
                continue;
            }
            if (current.containsInConf(server.getId())) {
                ++numIncluded;
                Assert.assertTrue((boolean)server.getRaftConf().isStable());
                Assert.assertTrue((boolean)server.getRaftConf().hasNoChange(peers));
                continue;
            }
            if (!server.isAlive()) continue;
            Assert.assertTrue((boolean)server.getRaftConf().isStable());
            Assert.assertFalse((boolean)server.getRaftConf().containsInConf(server.getId()));
        }
        Assert.assertEquals((long)peers.size(), (long)(numIncluded + deadIncluded));
    }

    public static long getRetryCacheSize(RaftServerImpl server) {
        return server.getRetryCache().size();
    }

    public static RetryCache.CacheEntry getRetryEntry(RaftServerImpl server, ClientId clientId, long callId) {
        return server.getRetryCache().get(clientId, callId);
    }

    public static boolean isRetryCacheEntryFailed(RetryCache.CacheEntry entry) {
        return entry.isFailed();
    }

    public static RaftProtos.RaftPeerRole getRole(RaftServerImpl server) {
        return server.getRole().getRaftPeerRole();
    }

    private static Optional<LeaderState> getLeaderState(RaftServerImpl server) {
        return server.getRole().getLeaderState();
    }

    public static Stream<LogAppender> getLogAppenders(RaftServerImpl server) {
        return RaftServerTestUtil.getLeaderState((RaftServerImpl)server).map(LeaderState::getLogAppenders).orElse(null);
    }

    public static void restartLogAppenders(RaftServerImpl server) {
        LeaderState leaderState = (LeaderState)RaftServerTestUtil.getLeaderState((RaftServerImpl)server).orElseThrow(() -> new IllegalStateException(server + " is not the leader"));
        leaderState.getLogAppenders().forEach(arg_0 -> ((LeaderState)leaderState).restartSender(arg_0));
    }

    public static Logger getStateMachineUpdaterLog() {
        return StateMachineUpdater.LOG;
    }

    public static List<RaftServerImpl> getRaftServerImpls(RaftServerProxy proxy) {
        return (List)JavaUtils.callAsUnchecked(() -> ((RaftServerProxy)proxy).getImpls());
    }

    public static RaftServerImpl getRaftServerImpl(RaftServerProxy proxy, RaftGroupId groupId) {
        return (RaftServerImpl)JavaUtils.callAsUnchecked(() -> proxy.getImpl(groupId));
    }
}

