/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.impl.RaftStateMachineExceptionTests;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class RaftStateMachineExceptionTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    private static volatile boolean failPreAppend = false;

    public RaftStateMachineExceptionTests() {
        Log4jUtils.setLogLevel((Logger)RaftServerImpl.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithException.class, StateMachine.class);
    }

    @Test
    public void testHandleStateMachineException() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestHandleStateMachineException(arg_0));
    }

    private void runTestHandleStateMachineException(CLUSTER cluster) throws Exception {
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            client.send((Message)new RaftTestUtil.SimpleMessage("m"));
            Assert.fail((String)"Exception expected");
        }
        catch (StateMachineException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Fake Exception"));
        }
        cluster.shutdown();
    }

    @Test
    public void testRetryOnStateMachineException() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestRetryOnStateMachineException(arg_0));
    }

    private void runTestRetryOnStateMachineException(CLUSTER cluster) throws Exception {
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        cluster.getLeaderAndSendFirstMessage(true);
        long oldLastApplied = cluster.getLeader().getState().getLastAppliedIndex();
        try (RaftClient client = cluster.createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftTestUtil.SimpleMessage message = new RaftTestUtil.SimpleMessage("message");
            RaftClientRequest r = cluster.newRaftClientRequest(client.getId(), leaderId, 999L, (Message)message);
            RaftClientReply reply = rpc.sendRequest(r);
            Assert.assertFalse((boolean)reply.isSuccess());
            Assert.assertNotNull((Object)((Object)reply.getStateMachineException()));
            for (int i = 0; i < 5; ++i) {
                reply = rpc.sendRequest(r);
                Assert.assertEquals((Object)client.getId(), (Object)reply.getClientId());
                Assert.assertEquals((long)999L, (long)reply.getCallId());
                Assert.assertFalse((boolean)reply.isSuccess());
                Assert.assertNotNull((Object)((Object)reply.getStateMachineException()));
            }
            for (RaftServerImpl server : cluster.iterateServerImpls()) {
                this.LOG.info("check server " + server.getId());
                JavaUtils.attemptRepeatedly(() -> {
                    Assert.assertNotNull((Object)RaftServerTestUtil.getRetryEntry((RaftServerImpl)server, (ClientId)client.getId(), (long)999L));
                    return null;
                }, (int)5, (TimeDuration)BaseTest.ONE_SECOND, (String)"GetRetryEntry", (Logger)this.LOG);
                RaftLog log = server.getState().getLog();
                RaftTestUtil.logEntriesContains((RaftLog)log, (long)(oldLastApplied + 1L), (long)log.getNextIndex(), (RaftTestUtil.SimpleMessage[])new RaftTestUtil.SimpleMessage[]{message});
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testRetryOnExceptionDuringReplication() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestRetryOnExceptionDuringReplication(arg_0));
    }

    private void runTestRetryOnExceptionDuringReplication(CLUSTER cluster) throws Exception {
        RaftServerImpl oldLeader = RaftTestUtil.waitForLeader(cluster);
        cluster.getLeaderAndSendFirstMessage(true);
        failPreAppend = true;
        try (RaftClient client = cluster.createClient(oldLeader.getId());){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftTestUtil.SimpleMessage message = new RaftTestUtil.SimpleMessage("message");
            RaftClientRequest r = cluster.newRaftClientRequest(client.getId(), oldLeader.getId(), 999L, (Message)message);
            RaftClientReply reply = rpc.sendRequest(r);
            Objects.requireNonNull(reply.getStateMachineException());
            RetryCache.CacheEntry oldEntry = RaftServerTestUtil.getRetryEntry((RaftServerImpl)oldLeader, (ClientId)client.getId(), (long)999L);
            Assert.assertNotNull((Object)oldEntry);
            Assert.assertTrue((boolean)RaftServerTestUtil.isRetryCacheEntryFailed((RetryCache.CacheEntry)oldEntry));
            RaftServerImpl leader = RaftTestUtil.waitForLeader(cluster);
            r = cluster.newRaftClientRequest(client.getId(), leader.getId(), 999L, (Message)message);
            reply = rpc.sendRequest(r);
            Objects.requireNonNull(reply.getStateMachineException());
            RetryCache.CacheEntry currentEntry = RaftServerTestUtil.getRetryEntry((RaftServerImpl)leader, (ClientId)client.getId(), (long)999L);
            Assert.assertNotNull((Object)currentEntry);
            Assert.assertTrue((boolean)RaftServerTestUtil.isRetryCacheEntryFailed((RetryCache.CacheEntry)currentEntry));
            Assert.assertNotEquals((Object)oldEntry, (Object)currentEntry);
            failPreAppend = false;
        }
    }

    static /* synthetic */ boolean access$000() {
        return failPreAppend;
    }
}

