/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.TimeUnit;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;

public class RetryCacheTestUtil {
    public static RetryCache createRetryCache() {
        return new RetryCache(TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS));
    }

    public static void createEntry(RetryCache cache, RaftProtos.LogEntryProto logEntry) {
        if (logEntry.hasStateMachineLogEntry()) {
            RaftProtos.StateMachineLogEntryProto smLogEntry = logEntry.getStateMachineLogEntry();
            ClientId clientId = ClientId.valueOf((ByteString)smLogEntry.getClientId());
            long callId = smLogEntry.getCallId();
            cache.getOrCreateEntry(clientId, callId);
        }
    }

    public static void assertFailure(RetryCache cache, RaftProtos.LogEntryProto logEntry, boolean isFailed) {
        if (logEntry.hasStateMachineLogEntry()) {
            RaftProtos.StateMachineLogEntryProto smLogEntry = logEntry.getStateMachineLogEntry();
            ClientId clientId = ClientId.valueOf((ByteString)smLogEntry.getClientId());
            long callId = smLogEntry.getCallId();
            Assert.assertEquals((Object)isFailed, (Object)cache.get(clientId, callId).isFailed());
        }
    }

    public static void getOrCreateEntry(RetryCache cache, ClientId clientId, long callId) {
        cache.getOrCreateEntry(clientId, callId);
    }
}

