/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public interface ServerProtoUtils {
    public static TermIndex toTermIndex(RaftProtos.TermIndexProto p) {
        return p == null ? null : TermIndex.newTermIndex((long)p.getTerm(), (long)p.getIndex());
    }

    public static RaftProtos.TermIndexProto toTermIndexProto(TermIndex ti) {
        return ti == null ? null : RaftProtos.TermIndexProto.newBuilder().setTerm(ti.getTerm()).setIndex(ti.getIndex()).build();
    }

    public static TermIndex toTermIndex(RaftProtos.LogEntryProto entry) {
        return entry == null ? null : TermIndex.newTermIndex((long)entry.getTerm(), (long)entry.getIndex());
    }

    public static String toTermIndexString(RaftProtos.LogEntryProto entry) {
        return TermIndex.toString((long)entry.getTerm(), (long)entry.getIndex());
    }

    public static String toTermIndexString(RaftProtos.TermIndexProto proto) {
        return TermIndex.toString((long)proto.getTerm(), (long)proto.getIndex());
    }

    public static String toLogEntryString(RaftProtos.LogEntryProto entry) {
        return ServerProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry, null);
    }

    public static String toStateMachineLogEntryString(RaftProtos.StateMachineLogEntryProto smLog, Function<RaftProtos.StateMachineLogEntryProto, String> function) {
        ByteString clientId = smLog.getClientId();
        String callIdString = (clientId.isEmpty() ? "<empty clientId>" : ClientId.valueOf((ByteString)clientId)) + ", cid=" + smLog.getCallId();
        String smString = "";
        if (function != null) {
            smString = "\n\t State Machine: " + function.apply(smLog);
        }
        return callIdString + smString;
    }

    public static String toLogEntryString(RaftProtos.LogEntryProto entry, Function<RaftProtos.StateMachineLogEntryProto, String> function) {
        String s;
        if (entry == null) {
            return null;
        }
        if (entry.hasStateMachineLogEntry()) {
            s = ", " + ServerProtoUtils.toStateMachineLogEntryString((RaftProtos.StateMachineLogEntryProto)entry.getStateMachineLogEntry(), function);
        } else if (entry.hasMetadataEntry()) {
            RaftProtos.MetadataProto metadata = entry.getMetadataEntry();
            s = "(c:" + metadata.getCommitIndex() + ")";
        } else {
            s = "";
        }
        return ServerProtoUtils.toTermIndexString((RaftProtos.LogEntryProto)entry) + ", " + entry.getLogEntryBodyCase() + s;
    }

    public static String toString(RaftProtos.LogEntryProto ... entries) {
        return entries == null ? "null" : (entries.length == 0 ? "[]" : (entries.length == 1 ? ServerProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entries[0]) : "" + Arrays.stream(entries).map(ServerProtoUtils::toLogEntryString).collect(Collectors.toList())));
    }

    public static String toShortString(List<RaftProtos.LogEntryProto> entries) {
        return entries.size() == 0 ? "<empty>" : "size=" + entries.size() + ", first=" + ServerProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entries.get(0));
    }

    public static String toString(RaftProtos.AppendEntriesRequestProto proto) {
        if (proto == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)proto.getServerRequest()) + "-t" + proto.getLeaderTerm() + ", previous=" + ServerProtoUtils.toTermIndexString((RaftProtos.TermIndexProto)proto.getPreviousLog()) + ", leaderCommit=" + proto.getLeaderCommit() + ", initializing? " + proto.getInitializing() + ", entries: " + ServerProtoUtils.toShortString((List)proto.getEntriesList());
    }

    public static String toString(RaftProtos.AppendEntriesReplyProto reply) {
        if (reply == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)reply.getServerReply()) + "," + reply.getResult() + ",nextIndex:" + reply.getNextIndex() + ",term:" + reply.getTerm() + ",followerCommit:" + reply.getFollowerCommit();
    }

    public static String toString(RaftProtos.RequestVoteReplyProto proto) {
        if (proto == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)proto.getServerReply()) + "-t" + proto.getTerm();
    }

    public static String toString(RaftProtos.InstallSnapshotRequestProto proto) {
        String s;
        if (proto == null) {
            return null;
        }
        switch (1.$SwitchMap$org$apache$ratis$proto$RaftProtos$InstallSnapshotRequestProto$InstallSnapshotRequestBodyCase[proto.getInstallSnapshotRequestBodyCase().ordinal()]) {
            case 1: {
                RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto chunk = proto.getSnapshotChunk();
                s = "chunk:" + chunk.getRequestId() + "," + chunk.getRequestIndex();
                break;
            }
            case 2: {
                RaftProtos.InstallSnapshotRequestProto.NotificationProto notification = proto.getNotification();
                s = "notify:" + ServerProtoUtils.toTermIndexString((RaftProtos.TermIndexProto)notification.getFirstAvailableTermIndex());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected body case in " + proto);
            }
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)proto.getServerRequest()) + "-t" + proto.getLeaderTerm() + "," + s;
    }

    public static String toString(RaftProtos.InstallSnapshotReplyProto proto) {
        String s;
        if (proto == null) {
            return null;
        }
        switch (1.$SwitchMap$org$apache$ratis$proto$RaftProtos$InstallSnapshotReplyProto$InstallSnapshotReplyBodyCase[proto.getInstallSnapshotReplyBodyCase().ordinal()]) {
            case 1: {
                s = ",requestIndex=" + proto.getRequestIndex();
                break;
            }
            case 2: {
                s = ",snapshotIndex=" + proto.getSnapshotIndex();
                break;
            }
            default: {
                s = "";
            }
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)proto.getServerReply()) + "-t" + proto.getTerm() + "," + proto.getResult() + s;
    }

    public static RaftProtos.RaftConfigurationProto.Builder toRaftConfigurationProto(RaftConfiguration conf) {
        return RaftProtos.RaftConfigurationProto.newBuilder().addAllPeers(ProtoUtils.toRaftPeerProtos((Collection)conf.getPeersInConf())).addAllOldPeers(ProtoUtils.toRaftPeerProtos((Collection)conf.getPeersInOldConf()));
    }

    public static RaftConfiguration toRaftConfiguration(RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue((boolean)entry.hasConfigurationEntry());
        RaftProtos.RaftConfigurationProto proto = entry.getConfigurationEntry();
        RaftConfiguration.Builder b = RaftConfiguration.newBuilder().setConf((Iterable)ProtoUtils.toRaftPeers((List)proto.getPeersList())).setLogEntryIndex(entry.getIndex());
        if (proto.getOldPeersCount() > 0) {
            b.setOldConf((Iterable)ProtoUtils.toRaftPeers((List)proto.getOldPeersList()));
        }
        return b.build();
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftConfiguration conf, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setConfigurationEntry(ServerProtoUtils.toRaftConfigurationProto((RaftConfiguration)conf)).build();
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftProtos.StateMachineLogEntryProto smLog, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setStateMachineLogEntry(smLog).build();
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(long commitIndex, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setMetadataEntry(ServerProtoUtils.toMetadataEntryBuilder((long)commitIndex)).build();
    }

    public static RaftProtos.MetadataProto.Builder toMetadataEntryBuilder(long commitIndex) {
        return RaftProtos.MetadataProto.newBuilder().setCommitIndex(commitIndex);
    }

    public static RaftProtos.StateMachineEntryProto.Builder toStateMachineEntryProtoBuilder(ByteString stateMachineData) {
        return RaftProtos.StateMachineEntryProto.newBuilder().setStateMachineData(stateMachineData);
    }

    public static RaftProtos.StateMachineEntryProto.Builder toStateMachineEntryProtoBuilder(int logEntryProtoSerializedSize) {
        return RaftProtos.StateMachineEntryProto.newBuilder().setLogEntryProtoSerializedSize(logEntryProtoSerializedSize);
    }

    public static RaftProtos.StateMachineLogEntryProto toStateMachineLogEntryProto(RaftClientRequest request, ByteString logData, ByteString stateMachineData) {
        if (logData == null) {
            logData = request.getMessage().getContent();
        }
        return ServerProtoUtils.toStateMachineLogEntryProto((ClientId)request.getClientId(), (long)request.getCallId(), (ByteString)logData, (ByteString)stateMachineData);
    }

    public static RaftProtos.StateMachineLogEntryProto toStateMachineLogEntryProto(ClientId clientId, long callId, ByteString logData, ByteString stateMachineData) {
        RaftProtos.StateMachineLogEntryProto.Builder b = RaftProtos.StateMachineLogEntryProto.newBuilder().setClientId(clientId.toByteString()).setCallId(callId).setLogData(logData);
        if (stateMachineData != null) {
            b.setStateMachineEntry(ServerProtoUtils.toStateMachineEntryProtoBuilder((ByteString)stateMachineData));
        }
        return b.build();
    }

    public static Optional<RaftProtos.StateMachineEntryProto> getStateMachineEntry(RaftProtos.LogEntryProto entry) {
        return Optional.of(entry).filter(RaftProtos.LogEntryProto::hasStateMachineLogEntry).map(RaftProtos.LogEntryProto::getStateMachineLogEntry).filter(RaftProtos.StateMachineLogEntryProto::hasStateMachineEntry).map(RaftProtos.StateMachineLogEntryProto::getStateMachineEntry);
    }

    public static Optional<ByteString> getStateMachineData(RaftProtos.LogEntryProto entry) {
        return ServerProtoUtils.getStateMachineEntry((RaftProtos.LogEntryProto)entry).map(RaftProtos.StateMachineEntryProto::getStateMachineData);
    }

    public static boolean shouldReadStateMachineData(RaftProtos.LogEntryProto entry) {
        return ServerProtoUtils.getStateMachineData((RaftProtos.LogEntryProto)entry).map(ByteString::isEmpty).orElse(false);
    }

    public static RaftProtos.LogEntryProto removeStateMachineData(RaftProtos.LogEntryProto entry) {
        return ServerProtoUtils.getStateMachineData((RaftProtos.LogEntryProto)entry).filter(stateMachineData -> !stateMachineData.isEmpty()).map(_dummy -> ServerProtoUtils.rebuildLogEntryProto((RaftProtos.LogEntryProto)entry, (RaftProtos.StateMachineEntryProto.Builder)ServerProtoUtils.toStateMachineEntryProtoBuilder((int)entry.getSerializedSize()))).orElse(entry);
    }

    public static RaftProtos.LogEntryProto rebuildLogEntryProto(RaftProtos.LogEntryProto entry, RaftProtos.StateMachineEntryProto.Builder smEntry) {
        return RaftProtos.LogEntryProto.newBuilder((RaftProtos.LogEntryProto)entry).setStateMachineLogEntry(RaftProtos.StateMachineLogEntryProto.newBuilder((RaftProtos.StateMachineLogEntryProto)entry.getStateMachineLogEntry()).setStateMachineEntry(smEntry)).build();
    }

    public static RaftProtos.LogEntryProto addStateMachineData(ByteString stateMachineData, RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue((boolean)ServerProtoUtils.shouldReadStateMachineData((RaftProtos.LogEntryProto)entry), () -> "Failed to addStateMachineData to " + entry + " since shouldReadStateMachineData is false.");
        return ServerProtoUtils.rebuildLogEntryProto((RaftProtos.LogEntryProto)entry, (RaftProtos.StateMachineEntryProto.Builder)ServerProtoUtils.toStateMachineEntryProtoBuilder((ByteString)stateMachineData));
    }

    public static int getSerializedSize(RaftProtos.LogEntryProto entry) {
        return ServerProtoUtils.getStateMachineEntry((RaftProtos.LogEntryProto)entry).filter(smEnty -> smEnty.getStateMachineData().isEmpty()).map(RaftProtos.StateMachineEntryProto::getLogEntryProtoSerializedSize).orElseGet(() -> ((RaftProtos.LogEntryProto)entry).getSerializedSize());
    }

    public static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success) {
        return ClientProtoUtils.toRaftRpcReplyProtoBuilder((ByteString)requestorId.toByteString(), (ByteString)replyId.getPeerId().toByteString(), (RaftGroupId)replyId.getGroupId(), (long)0L, (boolean)success);
    }

    public static RaftProtos.RequestVoteReplyProto toRequestVoteReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success, long term, boolean shouldShutdown) {
        return RaftProtos.RequestVoteReplyProto.newBuilder().setServerReply(ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (boolean)success)).setTerm(term).setShouldShutdown(shouldShutdown).build();
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftGroupMemberId requestorId, RaftPeerId replyId) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder((ByteString)requestorId.getPeerId().toByteString(), (ByteString)replyId.toByteString(), (RaftGroupId)requestorId.getGroupId(), (long)0L, null);
    }

    public static RaftProtos.RequestVoteRequestProto toRequestVoteRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, long term, TermIndex lastEntry) {
        RaftProtos.RequestVoteRequestProto.Builder b = RaftProtos.RequestVoteRequestProto.newBuilder().setServerRequest(ServerProtoUtils.toRaftRpcRequestProtoBuilder((RaftGroupMemberId)requestorId, (RaftPeerId)replyId)).setCandidateTerm(term);
        if (lastEntry != null) {
            b.setCandidateLastEntry(ServerProtoUtils.toTermIndexProto((TermIndex)lastEntry));
        }
        return b.build();
    }

    public static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long currentTerm, int requestIndex, RaftProtos.InstallSnapshotResult result) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.InstallSnapshotResult.SUCCESS ? 1 : 0) != 0);
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setTerm(currentTerm).setResult(result).setRequestIndex(requestIndex);
        return builder.build();
    }

    public static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long currentTerm, RaftProtos.InstallSnapshotResult result, long installedSnapshotIndex) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.InstallSnapshotResult.SUCCESS ? 1 : 0) != 0);
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setTerm(currentTerm).setResult(result);
        if (installedSnapshotIndex > 0L) {
            builder.setSnapshotIndex(installedSnapshotIndex);
        }
        return builder.build();
    }

    public static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, RaftProtos.InstallSnapshotResult result) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.InstallSnapshotResult.SUCCESS ? 1 : 0) != 0);
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setResult(result);
        return builder.build();
    }

    public static RaftProtos.InstallSnapshotRequestProto toInstallSnapshotRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, String requestId, int requestIndex, long term, TermIndex lastTermIndex, List<RaftProtos.FileChunkProto> chunks, long totalSize, boolean done) {
        RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto.Builder snapshotChunkProto = RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto.newBuilder().setRequestId(requestId).setRequestIndex(requestIndex).setTermIndex(ServerProtoUtils.toTermIndexProto((TermIndex)lastTermIndex)).addAllFileChunks(chunks).setTotalSize(totalSize).setDone(done);
        return RaftProtos.InstallSnapshotRequestProto.newBuilder().setServerRequest(ServerProtoUtils.toRaftRpcRequestProtoBuilder((RaftGroupMemberId)requestorId, (RaftPeerId)replyId)).setLeaderTerm(term).setSnapshotChunk(snapshotChunkProto).build();
    }

    public static RaftProtos.InstallSnapshotRequestProto toInstallSnapshotRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, long leaderTerm, TermIndex firstAvailable) {
        RaftProtos.InstallSnapshotRequestProto.NotificationProto.Builder notificationProto = RaftProtos.InstallSnapshotRequestProto.NotificationProto.newBuilder().setFirstAvailableTermIndex(ServerProtoUtils.toTermIndexProto((TermIndex)firstAvailable));
        return RaftProtos.InstallSnapshotRequestProto.newBuilder().setServerRequest(ServerProtoUtils.toRaftRpcRequestProtoBuilder((RaftGroupMemberId)requestorId, (RaftPeerId)replyId)).setLeaderTerm(leaderTerm).setNotification(notificationProto).build();
    }

    public static RaftProtos.AppendEntriesReplyProto toAppendEntriesReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long term, long followerCommit, long nextIndex, RaftProtos.AppendEntriesReplyProto.AppendResult result, long callId, long matchIndex, boolean isHeartbeat) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS ? 1 : 0) != 0).setCallId(callId);
        return RaftProtos.AppendEntriesReplyProto.newBuilder().setServerReply(rpcReply).setTerm(term).setNextIndex(nextIndex).setMatchIndex(matchIndex).setFollowerCommit(followerCommit).setResult(result).setIsHearbeat(isHeartbeat).build();
    }

    public static RaftProtos.AppendEntriesRequestProto toAppendEntriesRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, long leaderTerm, List<RaftProtos.LogEntryProto> entries, long leaderCommit, boolean initializing, TermIndex previous, Collection<RaftProtos.CommitInfoProto> commitInfos, long callId) {
        RaftProtos.RaftRpcRequestProto.Builder rpcRequest = ServerProtoUtils.toRaftRpcRequestProtoBuilder((RaftGroupMemberId)requestorId, (RaftPeerId)replyId).setCallId(callId);
        RaftProtos.AppendEntriesRequestProto.Builder b = RaftProtos.AppendEntriesRequestProto.newBuilder().setServerRequest(rpcRequest).setLeaderTerm(leaderTerm).setLeaderCommit(leaderCommit).setInitializing(initializing);
        if (entries != null && !entries.isEmpty()) {
            b.addAllEntries(entries);
        }
        if (previous != null) {
            b.setPreviousLog(ServerProtoUtils.toTermIndexProto((TermIndex)previous));
        }
        ProtoUtils.addCommitInfos(commitInfos, arg_0 -> ((RaftProtos.AppendEntriesRequestProto.Builder)b).addCommitInfos(arg_0));
        return b.build();
    }

    public static RaftProtos.ServerRpcProto toServerRpcProto(RaftPeer peer, long delay) {
        if (peer == null) {
            return RaftProtos.ServerRpcProto.getDefaultInstance();
        }
        return RaftProtos.ServerRpcProto.newBuilder().setId(peer.getRaftPeerProto()).setLastRpcElapsedTimeMs(delay).build();
    }
}

