/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.exceptions.StreamException;
import org.apache.ratis.server.impl.StreamRequests;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamRequests {
    public static final Logger LOG = LoggerFactory.getLogger(StreamRequests.class);
    private final String name;
    private final StreamMap streams = new StreamMap();

    StreamRequests(Object name) {
        this.name = name + "-" + this.getClass().getSimpleName();
    }

    CompletableFuture<?> streamAsync(RaftClientRequest request) {
        RaftProtos.StreamRequestTypeProto stream = request.getType().getStream();
        Preconditions.assertTrue((!stream.getEndOfRequest() ? 1 : 0) != 0);
        Key key = new Key(request.getClientId(), stream.getStreamId());
        PendingStream pending = this.streams.computeIfAbsent(key);
        return pending.append(stream.getMessageId(), request.getMessage());
    }

    CompletableFuture<ByteString> streamEndOfRequestAsync(RaftClientRequest request) {
        RaftProtos.StreamRequestTypeProto stream = request.getType().getStream();
        Preconditions.assertTrue((boolean)stream.getEndOfRequest());
        Key key = new Key(request.getClientId(), stream.getStreamId());
        PendingStream pending = this.streams.remove(key);
        if (pending == null) {
            return JavaUtils.completeExceptionally((Throwable)new StreamException(this.name + ": " + key + " not found"));
        }
        return pending.getBytes(stream.getMessageId(), request.getMessage());
    }

    void clear() {
        this.streams.clear();
    }
}

