/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Gauge;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.TestLogAppenderMetrics;
import org.apache.ratis.server.metrics.LogAppenderMetrics;
import org.apache.ratis.util.Timestamp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLogAppenderMetrics {
    private RatisMetricRegistry ratisMetricRegistry;
    private RaftPeerId raftPeerId;
    private FollowerInfo followerInfo;

    @Before
    public void setup() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        this.raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftPeer raftPeer = new RaftPeer(this.raftPeerId);
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)this.raftPeerId, (RaftGroupId)raftGroupId);
        LogAppender logAppender = (LogAppender)Mockito.mock(LogAppender.class);
        this.followerInfo = new TestFollowerInfo(raftGroupMemberId, raftPeer, Timestamp.currentTime(), 100L, true, 1000);
        Mockito.when((Object)logAppender.getFollower()).thenReturn((Object)this.followerInfo);
        LogAppenderMetrics logAppenderMetrics = new LogAppenderMetrics(raftGroupMemberId);
        this.ratisMetricRegistry = logAppenderMetrics.getRegistry();
        logAppenderMetrics.addFollowerGauges(this.followerInfo);
    }

    @Test
    public void testLogAppenderGauges() {
        Gauge nextIndex = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_next_index", this.raftPeerId.toString()))).values().iterator().next();
        Assert.assertEquals((Object)100L, (Object)nextIndex.getValue());
        Gauge matchIndex = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_match_index", this.raftPeerId.toString()))).values().iterator().next();
        Assert.assertEquals((Object)0L, (Object)matchIndex.getValue());
        Gauge rpcTime = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_rpc_response_time", this.raftPeerId.toString()))).values().iterator().next();
        Assert.assertTrue(((Long)rpcTime.getValue() > 0L ? 1 : 0) != 0);
        this.followerInfo.updateNextIndex(200L);
        this.followerInfo.updateMatchIndex(100L);
        this.followerInfo.updateLastRpcResponseTime();
        Assert.assertEquals((Object)200L, (Object)nextIndex.getValue());
        Assert.assertEquals((Object)100L, (Object)matchIndex.getValue());
        Assert.assertNotNull((Object)rpcTime.getValue());
    }
}

