/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Gauge;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerMetrics;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRetryCacheMetrics {
    private static RatisMetricRegistry ratisMetricRegistry;
    private static RetryCache retryCache;

    @BeforeClass
    public static void setUp() {
        RaftServerImpl raftServer = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        RaftPeerId raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        Mockito.when((Object)raftServer.getMemberId()).thenReturn((Object)raftGroupMemberId);
        retryCache = new RetryCache(TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS));
        Mockito.when((Object)raftServer.getRetryCache()).thenReturn((Object)retryCache);
        RaftServerMetrics raftServerMetrics = RaftServerMetrics.getRaftServerMetrics((RaftServerImpl)raftServer);
        ratisMetricRegistry = raftServerMetrics.getRegistry();
    }

    @Test
    public void testRetryCacheEntryCount() {
        TestRetryCacheMetrics.checkEntryCount((long)0L);
        ClientId clientId = ClientId.randomId();
        RetryCache.CacheKey key = new RetryCache.CacheKey(clientId, 1L);
        RetryCache.CacheEntry entry = new RetryCache.CacheEntry(key);
        retryCache.refreshEntry(entry);
        TestRetryCacheMetrics.checkEntryCount((long)1L);
        retryCache.close();
        TestRetryCacheMetrics.checkEntryCount((long)0L);
    }

    @Test
    public void testRetryCacheHitMissCount() {
        TestRetryCacheMetrics.checkHit((long)0L, (double)1.0);
        TestRetryCacheMetrics.checkMiss((long)0L, (double)0.0);
        ClientId clientId = ClientId.randomId();
        retryCache.getOrCreateEntry(clientId, 2L);
        TestRetryCacheMetrics.checkHit((long)0L, (double)0.0);
        TestRetryCacheMetrics.checkMiss((long)1L, (double)1.0);
        retryCache.getOrCreateEntry(clientId, 2L);
        TestRetryCacheMetrics.checkHit((long)1L, (double)0.5);
        TestRetryCacheMetrics.checkMiss((long)1L, (double)0.5);
    }

    private static void checkHit(long count, double rate) {
        Long hitCount = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheHitCount")).values().iterator().next()).getValue();
        Assert.assertEquals((long)hitCount, (long)count);
        Double hitRate = (Double)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheHitRate")).values().iterator().next()).getValue();
        Assert.assertEquals((double)hitRate, (double)rate, (double)0.0);
    }

    private static void checkMiss(long count, double rate) {
        Long missCount = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheMissCount")).values().iterator().next()).getValue();
        Assert.assertEquals((long)missCount, (long)count);
        Double missRate = (Double)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheMissRate")).values().iterator().next()).getValue();
        Assert.assertEquals((double)missRate, (double)rate, (double)0.0);
    }

    private static void checkEntryCount(long count) {
        Long entryCount = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheEntryCount")).values().iterator().next()).getValue();
        Assert.assertEquals((long)entryCount, (long)count);
    }
}

