/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import com.codahale.metrics.Gauge;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLeaderElectionMetrics {
    private static LeaderElectionMetrics leaderElectionMetrics;
    private static RatisMetricRegistry ratisMetricRegistry;

    @BeforeClass
    public static void setUp() throws Exception {
        RaftServerImpl raftServer = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        ServerState serverStateMock = (ServerState)Mockito.mock(ServerState.class);
        Mockito.when((Object)raftServer.getState()).thenReturn((Object)serverStateMock);
        Mockito.when((Object)serverStateMock.getLastLeaderElapsedTimeMs()).thenReturn((Object)1000L);
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        RaftPeerId raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        Mockito.when((Object)raftServer.getMemberId()).thenReturn((Object)raftGroupMemberId);
        leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftServerImpl)raftServer);
        ratisMetricRegistry = leaderElectionMetrics.getRegistry();
    }

    @Test
    public void testOnNewLeaderElection() throws Exception {
        long numLeaderElections = ratisMetricRegistry.counter("electionCount").getCount();
        Assert.assertTrue((numLeaderElections == 0L ? 1 : 0) != 0);
        leaderElectionMetrics.onNewLeaderElection();
        numLeaderElections = ratisMetricRegistry.counter("electionCount").getCount();
        Assert.assertEquals((long)1L, (long)numLeaderElections);
    }

    @Test
    public void testOnLeaderElectionCompletion() throws Exception {
        leaderElectionMetrics.onLeaderElectionCompletion(500L);
        Long leaderElectionLatency = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("electionLatency")).values().iterator().next()).getValue();
        Assert.assertEquals((long)500L, (long)leaderElectionLatency);
    }

    @Test
    public void testOnLeaderElectionTimeout() throws Exception {
        long numLeaderElectionTimeouts = ratisMetricRegistry.counter("electionTimeoutCount").getCount();
        Assert.assertTrue((numLeaderElectionTimeouts == 0L ? 1 : 0) != 0);
        leaderElectionMetrics.onLeaderElectionTimeout();
        numLeaderElectionTimeouts = ratisMetricRegistry.counter("electionTimeoutCount").getCount();
        Assert.assertEquals((long)1L, (long)numLeaderElectionTimeouts);
    }
}

