/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.protocol;

import java.util.function.LongFunction;
import org.apache.ratis.server.impl.ServerImplUtils;

public interface TermIndex
extends Comparable<TermIndex> {
    public static final TermIndex[] EMPTY_TERMINDEX_ARRAY = new TermIndex[0];
    public static final LongFunction<String> LONG_TO_STRING = n -> n >= 0L ? String.valueOf(n) : "~";

    public long getTerm();

    public long getIndex();

    public static boolean isValidTerm(int term) {
        return term > 0;
    }

    public static TermIndex newTermIndex(long term, long index) {
        return ServerImplUtils.newTermIndex((long)term, (long)index);
    }

    public static String toString(long term, long index) {
        return String.format("(t:%s, i:%s)", LONG_TO_STRING.apply(term), LONG_TO_STRING.apply(index));
    }
}

