/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.metrics.RaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogFormat;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogInputStream;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogSegment
implements Comparable<Long> {
    static final Logger LOG = LoggerFactory.getLogger(LogSegment.class);
    private volatile boolean isOpen;
    private long totalSize = SegmentedRaftLogFormat.getHeaderLength();
    private long startIndex;
    private volatile long endIndex;
    private RaftStorage storage;
    private RaftLogMetrics raftLogMetrics;
    private final LogEntryLoader cacheLoader = new LogEntryLoader(this, this.raftLogMetrics);
    private final AtomicInteger loadingTimes = new AtomicInteger();
    private final List<LogRecord> records = new ArrayList();
    private final Map<TermIndex, RaftProtos.LogEntryProto> entryCache = new ConcurrentHashMap();
    private final Set<TermIndex> configEntries = new HashSet();

    static long getEntrySize(RaftProtos.LogEntryProto entry) {
        int serialized = ServerProtoUtils.removeStateMachineData((RaftProtos.LogEntryProto)entry).getSerializedSize();
        return serialized + CodedOutputStream.computeUInt32SizeNoTag((int)serialized) + 4;
    }

    static LogSegment newOpenSegment(RaftStorage storage, long start, RaftLogMetrics raftLogMetrics) {
        Preconditions.assertTrue((start >= 0L ? 1 : 0) != 0);
        return new LogSegment(storage, true, start, start - 1L, raftLogMetrics);
    }

    @VisibleForTesting
    static LogSegment newCloseSegment(RaftStorage storage, long start, long end, RaftLogMetrics raftLogMetrics) {
        Preconditions.assertTrue((start >= 0L && end >= start ? 1 : 0) != 0);
        return new LogSegment(storage, false, start, end, raftLogMetrics);
    }

    public static int readSegmentFile(File file, long start, long end, boolean isOpen, RaftServerConfigKeys.Log.CorruptionPolicy corruptionPolicy, RaftLogMetrics raftLogMetrics, Consumer<RaftProtos.LogEntryProto> entryConsumer) throws IOException {
        int count = 0;
        try (SegmentedRaftLogInputStream in = new SegmentedRaftLogInputStream(file, start, end, isOpen, raftLogMetrics);){
            RaftProtos.LogEntryProto next;
            RaftProtos.LogEntryProto prev = null;
            while ((next = in.nextEntry()) != null) {
                if (prev != null) {
                    Preconditions.assertTrue((next.getIndex() == prev.getIndex() + 1L ? 1 : 0) != 0, (String)"gap between entry %s and entry %s", (Object[])new Object[]{prev, next});
                }
                if (entryConsumer != null) {
                    entryConsumer.accept(next);
                }
                ++count;
                prev = next;
            }
        }
        catch (IOException ioe) {
            switch (1.$SwitchMap$org$apache$ratis$server$RaftServerConfigKeys$Log$CorruptionPolicy[corruptionPolicy.ordinal()]) {
                case 1: {
                    throw ioe;
                }
                case 2: {
                    LOG.warn("Failed to read segment file {} (start={}, end={}, isOpen? {}): only {} entries read successfully", new Object[]{file, start, end, isOpen, count, ioe});
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected enum value: " + corruptionPolicy + ", class=" + RaftServerConfigKeys.Log.CorruptionPolicy.class);
                }
            }
        }
        return count;
    }

    static LogSegment loadSegment(RaftStorage storage, File file, long start, long end, boolean isOpen, boolean keepEntryInCache, Consumer<RaftProtos.LogEntryProto> logConsumer, RaftLogMetrics raftLogMetrics) throws IOException {
        int expectedEntryCount;
        boolean corrupted;
        LogSegment segment = isOpen ? LogSegment.newOpenSegment((RaftStorage)storage, (long)start, (RaftLogMetrics)raftLogMetrics) : LogSegment.newCloseSegment((RaftStorage)storage, (long)start, (long)end, (RaftLogMetrics)raftLogMetrics);
        RaftServerConfigKeys.Log.CorruptionPolicy corruptionPolicy = RaftServerConfigKeys.Log.CorruptionPolicy.get((Object)storage, RaftStorage::getLogCorruptionPolicy);
        int entryCount = LogSegment.readSegmentFile((File)file, (long)start, (long)end, (boolean)isOpen, (RaftServerConfigKeys.Log.CorruptionPolicy)corruptionPolicy, (RaftLogMetrics)raftLogMetrics, (T entry) -> {
            segment.append(keepEntryInCache || isOpen, entry);
            if (logConsumer != null) {
                logConsumer.accept((RaftProtos.LogEntryProto)entry);
            }
        });
        LOG.info("Successfully read {} entries from segment file {}", (Object)entryCount, (Object)file);
        if (isOpen) {
            end = segment.getEndIndex();
        }
        boolean bl = corrupted = entryCount != (expectedEntryCount = Math.toIntExact(end - start + 1L));
        if (corrupted) {
            LOG.warn("Segment file is corrupted: expected to have {} entries but only {} entries read successfully", (Object)expectedEntryCount, (Object)entryCount);
        }
        if (entryCount == 0) {
            FileUtils.deleteFile((File)file);
            return null;
        }
        if (file.length() > segment.getTotalSize()) {
            FileUtils.truncateFile((File)file, (long)segment.getTotalSize());
        }
        try {
            segment.assertSegment(start, entryCount, corrupted, end);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read segment file " + file, e);
        }
        return segment;
    }

    private void assertSegment(long expectedStart, int expectedEntryCount, boolean corrupted, long expectedEnd) {
        Preconditions.assertSame((long)expectedStart, (long)this.getStartIndex(), (String)"Segment start index");
        Preconditions.assertSame((long)expectedEntryCount, (long)this.records.size(), (String)"Number of records");
        long expectedLastIndex = expectedStart + (long)expectedEntryCount - 1L;
        Preconditions.assertSame((long)expectedLastIndex, (long)this.getEndIndex(), (String)"Segment end index");
        LogRecord last = this.getLastRecord();
        if (last != null) {
            Preconditions.assertSame((long)expectedLastIndex, (long)last.getTermIndex().getIndex(), (String)"Index at the last record");
            Preconditions.assertSame((long)expectedStart, (long)((LogRecord)this.records.get(0)).getTermIndex().getIndex(), (String)"Index at the first record");
        }
        if (!corrupted) {
            Preconditions.assertSame((long)expectedEnd, (long)expectedLastIndex, (String)"End/last Index");
        }
    }

    private File getSegmentFile() {
        return this.isOpen ? this.storage.getStorageDir().getOpenLogFile(this.startIndex) : this.storage.getStorageDir().getClosedLogFile(this.startIndex, this.endIndex);
    }

    private LogSegment(RaftStorage storage, boolean isOpen, long start, long end, RaftLogMetrics raftLogMetrics) {
        this.storage = storage;
        this.isOpen = isOpen;
        this.startIndex = start;
        this.endIndex = end;
        this.raftLogMetrics = raftLogMetrics;
    }

    long getStartIndex() {
        return this.startIndex;
    }

    long getEndIndex() {
        return this.endIndex;
    }

    boolean isOpen() {
        return this.isOpen;
    }

    int numOfEntries() {
        return Math.toIntExact(this.endIndex - this.startIndex + 1L);
    }

    RaftServerConfigKeys.Log.CorruptionPolicy getLogCorruptionPolicy() {
        return RaftServerConfigKeys.Log.CorruptionPolicy.get((Object)this.storage, RaftStorage::getLogCorruptionPolicy);
    }

    void appendToOpenSegment(RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue((boolean)this.isOpen(), (String)"The log segment %s is not open for append", (Object[])new Object[]{this});
        this.append(true, entry);
    }

    private void append(boolean keepEntryInCache, RaftProtos.LogEntryProto entry) {
        LogRecord currentLast;
        Objects.requireNonNull(entry, "entry == null");
        if (this.records.isEmpty()) {
            Preconditions.assertTrue((entry.getIndex() == this.startIndex ? 1 : 0) != 0, (String)"gap between start index %s and first entry to append %s", (Object[])new Object[]{this.startIndex, entry.getIndex()});
        }
        if ((currentLast = this.getLastRecord()) != null) {
            Preconditions.assertTrue((entry.getIndex() == currentLast.getTermIndex().getIndex() + 1L ? 1 : 0) != 0, (String)"gap between entries %s and %s", (Object[])new Object[]{entry.getIndex(), currentLast.getTermIndex().getIndex()});
        }
        LogRecord record = new LogRecord(this.totalSize, entry);
        this.records.add(record);
        if (keepEntryInCache) {
            this.entryCache.put(record.getTermIndex(), entry);
        }
        if (entry.hasConfigurationEntry()) {
            this.configEntries.add(record.getTermIndex());
        }
        this.totalSize += LogSegment.getEntrySize((RaftProtos.LogEntryProto)entry);
        this.endIndex = entry.getIndex();
    }

    RaftProtos.LogEntryProto getEntryFromCache(TermIndex ti) {
        return (RaftProtos.LogEntryProto)this.entryCache.get(ti);
    }

    synchronized RaftProtos.LogEntryProto loadCache(LogRecord record) throws RaftLogIOException {
        RaftProtos.LogEntryProto entry = (RaftProtos.LogEntryProto)this.entryCache.get(record.getTermIndex());
        if (entry != null) {
            return entry;
        }
        try {
            return this.cacheLoader.load(record);
        }
        catch (Exception e) {
            throw new RaftLogIOException((Throwable)e);
        }
    }

    LogRecord getLogRecord(long index) {
        if (index >= this.startIndex && index <= this.endIndex) {
            return (LogRecord)this.records.get(Math.toIntExact(index - this.startIndex));
        }
        return null;
    }

    private LogRecord getLastRecord() {
        return this.records.isEmpty() ? null : (LogRecord)this.records.get(this.records.size() - 1);
    }

    TermIndex getLastTermIndex() {
        LogRecord last = this.getLastRecord();
        return last == null ? null : last.getTermIndex();
    }

    boolean isConfigEntry(TermIndex ti) {
        return this.configEntries.contains(ti);
    }

    long getTotalSize() {
        return this.totalSize;
    }

    synchronized void truncate(long fromIndex) {
        Preconditions.assertTrue((fromIndex >= this.startIndex && fromIndex <= this.endIndex ? 1 : 0) != 0);
        for (long index = this.endIndex; index >= fromIndex; --index) {
            LogRecord removed = (LogRecord)this.records.remove(Math.toIntExact(index - this.startIndex));
            this.entryCache.remove(removed.getTermIndex());
            this.configEntries.remove(removed.getTermIndex());
            this.totalSize = LogRecord.access$600((LogRecord)removed);
        }
        this.isOpen = false;
        this.endIndex = fromIndex - 1L;
    }

    void close() {
        Preconditions.assertTrue((boolean)this.isOpen());
        this.isOpen = false;
    }

    public String toString() {
        return this.isOpen() ? "log_inprogress_" + this.startIndex : "log-" + this.startIndex + "_" + this.endIndex;
    }

    @Override
    public int compareTo(Long l) {
        return l >= this.getStartIndex() && l <= this.getEndIndex() ? 0 : (this.getEndIndex() < l ? -1 : 1);
    }

    synchronized void clear() {
        this.records.clear();
        this.entryCache.clear();
        this.configEntries.clear();
        this.endIndex = this.startIndex - 1L;
    }

    int getLoadingTimes() {
        return this.loadingTimes.get();
    }

    synchronized void evictCache() {
        this.entryCache.clear();
    }

    boolean hasCache() {
        return this.isOpen || !this.entryCache.isEmpty();
    }

    boolean containsIndex(long index) {
        return this.startIndex <= index && this.endIndex >= index;
    }

    static /* synthetic */ File access$000(LogSegment x0) {
        return x0.getSegmentFile();
    }

    static /* synthetic */ long access$100(LogSegment x0) {
        return x0.startIndex;
    }

    static /* synthetic */ long access$200(LogSegment x0) {
        return x0.endIndex;
    }

    static /* synthetic */ boolean access$300(LogSegment x0) {
        return x0.isOpen;
    }

    static /* synthetic */ AtomicInteger access$400(LogSegment x0) {
        return x0.loadingTimes;
    }

    static /* synthetic */ Map access$500(LogSegment x0) {
        return x0.entryCache;
    }
}

