/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.metrics.RaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.segmented.CacheInvalidationPolicy;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SegmentedRaftLogCache {
    public static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogCache.class);
    private final String name;
    private volatile LogSegment openSegment;
    private final LogSegmentList closedSegments;
    private final RaftStorage storage;
    private final RaftLogMetrics raftLogMetrics;
    private final int maxCachedSegments;
    private final CacheInvalidationPolicy evictionPolicy = new CacheInvalidationPolicy.CacheInvalidationPolicyDefault();

    SegmentedRaftLogCache(Object name, RaftStorage storage, RaftProperties properties) {
        this(name, storage, properties, null);
    }

    SegmentedRaftLogCache(Object name, RaftStorage storage, RaftProperties properties, RaftLogMetrics raftLogMetrics) {
        this.name = name + "-" + this.getClass().getSimpleName();
        this.closedSegments = new LogSegmentList(name);
        this.storage = storage;
        this.raftLogMetrics = raftLogMetrics;
        this.raftLogMetrics.addClosedSegmentsNum(this);
        this.raftLogMetrics.addClosedSegmentsSizeInBytes(this);
        this.raftLogMetrics.addOpenSegmentSizeInBytes(this);
        this.maxCachedSegments = RaftServerConfigKeys.Log.segmentCacheNumMax((RaftProperties)properties);
    }

    int getMaxCachedSegments() {
        return this.maxCachedSegments;
    }

    void loadSegment(RaftStorageDirectory.LogPathAndIndex pi, boolean keepEntryInCache, Consumer<RaftProtos.LogEntryProto> logConsumer, long lastIndexInSnapshot) throws IOException {
        LogSegment logSegment = LogSegment.loadSegment((RaftStorage)this.storage, (File)pi.getPath().toFile(), (long)pi.getStartIndex(), (long)pi.getEndIndex(), (boolean)pi.isOpen(), (boolean)keepEntryInCache, logConsumer, (RaftLogMetrics)this.raftLogMetrics);
        if (logSegment != null && logSegment.getEndIndex() > lastIndexInSnapshot) {
            this.addSegment(logSegment);
        }
    }

    public long getCachedSegmentNum() {
        return this.closedSegments.countCached();
    }

    public long getClosedSegmentsSizeInBytes() {
        return this.closedSegments.sizeInBytes();
    }

    public long getOpenSegmentSizeInBytes() {
        return this.openSegment.getTotalSize();
    }

    boolean shouldEvict() {
        return this.closedSegments.countCached() > (long)this.maxCachedSegments;
    }

    void evictCache(long[] followerIndices, long safeEvictIndex, long lastAppliedIndex) {
        List toEvict = this.evictionPolicy.evict(followerIndices, safeEvictIndex, lastAppliedIndex, this.closedSegments, this.maxCachedSegments);
        for (LogSegment s : toEvict) {
            s.evictCache();
        }
    }

    private void validateAdding(LogSegment segment) {
        LogSegment lastClosed = this.closedSegments.getLast();
        if (lastClosed != null) {
            Preconditions.assertTrue((!lastClosed.isOpen() ? 1 : 0) != 0);
            Preconditions.assertTrue((lastClosed.getEndIndex() + 1L == segment.getStartIndex() ? 1 : 0) != 0);
        }
    }

    void addSegment(LogSegment segment) {
        this.validateAdding(segment);
        if (segment.isOpen()) {
            this.setOpenSegment(segment);
        } else {
            this.closedSegments.add(segment);
        }
    }

    void addOpenSegment(long startIndex) {
        this.setOpenSegment(LogSegment.newOpenSegment((RaftStorage)this.storage, (long)startIndex, (RaftLogMetrics)this.raftLogMetrics));
    }

    private void setOpenSegment(LogSegment openSegment) {
        LOG.trace("{}: setOpenSegment to {}", (Object)this.name, (Object)openSegment);
        Preconditions.assertTrue((this.openSegment == null ? 1 : 0) != 0);
        this.openSegment = Objects.requireNonNull(openSegment);
    }

    private void clearOpenSegment() {
        LOG.trace("{}: clearOpenSegment {}", (Object)this.name, (Object)this.openSegment);
        Objects.requireNonNull(this.openSegment);
        this.openSegment = null;
    }

    LogSegment getOpenSegment() {
        return this.openSegment;
    }

    void rollOpenSegment(boolean createNewOpen) {
        Preconditions.assertTrue((this.openSegment != null && this.openSegment.numOfEntries() > 0 ? 1 : 0) != 0);
        long nextIndex = this.openSegment.getEndIndex() + 1L;
        this.openSegment.close();
        this.closedSegments.add(this.openSegment);
        this.clearOpenSegment();
        if (createNewOpen) {
            this.addOpenSegment(nextIndex);
        }
    }

    LogSegment getSegment(long index) {
        if (this.openSegment != null && index >= this.openSegment.getStartIndex()) {
            return this.openSegment;
        }
        return this.closedSegments.search(index);
    }

    LogSegment.LogRecord getLogRecord(long index) {
        LogSegment segment = this.getSegment(index);
        return segment == null ? null : segment.getLogRecord(index);
    }

    TermIndex[] getTermIndices(long startIndex, long endIndex) {
        if (startIndex < 0L || startIndex < this.getStartIndex()) {
            throw new IndexOutOfBoundsException("startIndex = " + startIndex + ", log cache starts from index " + this.getStartIndex());
        }
        if (startIndex > endIndex) {
            throw new IndexOutOfBoundsException("startIndex(" + startIndex + ") > endIndex(" + endIndex + ")");
        }
        long realEnd = Math.min(this.getEndIndex() + 1L, endIndex);
        if (startIndex >= realEnd) {
            return TermIndex.EMPTY_TERMINDEX_ARRAY;
        }
        return this.closedSegments.getTermIndex(startIndex, realEnd, this.openSegment);
    }

    private static void getFromSegment(LogSegment segment, long startIndex, TermIndex[] entries, int offset, int size) {
        long endIndex = segment.getEndIndex();
        endIndex = Math.min(endIndex, startIndex + (long)size - 1L);
        int index = offset;
        for (long i = startIndex; i <= endIndex; ++i) {
            LogSegment.LogRecord r = segment.getLogRecord(i);
            entries[index++] = r == null ? null : r.getTermIndex();
        }
    }

    boolean isConfigEntry(TermIndex ti) {
        LogSegment segment = this.getSegment(ti.getIndex());
        return segment != null && segment.isConfigEntry(ti);
    }

    long getStartIndex() {
        if (this.closedSegments.isEmpty()) {
            return this.openSegment != null ? this.openSegment.getStartIndex() : -1L;
        }
        return this.closedSegments.get(0).getStartIndex();
    }

    long getEndIndex() {
        return this.openSegment != null ? this.openSegment.getEndIndex() : (this.closedSegments.isEmpty() ? -1L : this.closedSegments.get(this.closedSegments.size() - 1).getEndIndex());
    }

    long getLastIndexInClosedSegments() {
        return this.closedSegments.isEmpty() ? -1L : this.closedSegments.get(this.closedSegments.size() - 1).getEndIndex();
    }

    TermIndex getLastTermIndex() {
        return this.openSegment != null && this.openSegment.numOfEntries() > 0 ? this.openSegment.getLastTermIndex() : (this.closedSegments.isEmpty() ? null : this.closedSegments.get(this.closedSegments.size() - 1).getLastTermIndex());
    }

    void appendEntry(RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue((this.openSegment != null ? 1 : 0) != 0);
        this.openSegment.appendToOpenSegment(entry);
    }

    TruncationSegments truncate(long index) {
        return this.closedSegments.truncate(index, this.openSegment, () -> this.clearOpenSegment());
    }

    TruncationSegments purge(long index) {
        return this.closedSegments.purge(index);
    }

    Iterator<TermIndex> iterator(long startIndex) {
        return new EntryIterator(this, startIndex);
    }

    TruncateIndices computeTruncateIndices(Consumer<TermIndex> failClientRequest, RaftProtos.LogEntryProto ... entries) {
        int arrayIndex;
        long truncateIndex = -1L;
        try (AutoCloseableLock readLock = this.closedSegments.readLock();){
            Iterator i = this.iterator(entries[0].getIndex());
            for (arrayIndex = 0; i.hasNext() && arrayIndex < entries.length; ++arrayIndex) {
                TermIndex storedEntry = (TermIndex)i.next();
                Preconditions.assertTrue((storedEntry.getIndex() == entries[arrayIndex].getIndex() ? 1 : 0) != 0, (String)"The stored entry's index %s is not consistent with the received entries[%s]'s index %s", (Object[])new Object[]{storedEntry.getIndex(), arrayIndex, entries[arrayIndex].getIndex()});
                if (storedEntry.getTerm() == entries[arrayIndex].getTerm()) continue;
                truncateIndex = storedEntry.getIndex();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}: truncate to {}, arrayIndex={}, ti={}, storedEntry={}, entries={}", new Object[]{this.name, truncateIndex, arrayIndex, ServerProtoUtils.toTermIndex((RaftProtos.LogEntryProto)entries[arrayIndex]), storedEntry, ServerProtoUtils.toString((RaftProtos.LogEntryProto[])entries)});
                }
                failClientRequest.accept(storedEntry);
                while (i.hasNext()) {
                    failClientRequest.accept((TermIndex)i.next());
                }
                break;
            }
        }
        return new TruncateIndices(arrayIndex, truncateIndex);
    }

    int getNumOfSegments() {
        return this.closedSegments.size() + (this.openSegment == null ? 0 : 1);
    }

    boolean isEmpty() {
        return this.closedSegments.isEmpty() && this.openSegment == null;
    }

    void clear() {
        if (this.openSegment != null) {
            this.openSegment.clear();
            this.clearOpenSegment();
        }
        this.closedSegments.clear();
    }

    static /* synthetic */ void access$100(LogSegment x0, long x1, TermIndex[] x2, int x3, int x4) {
        SegmentedRaftLogCache.getFromSegment((LogSegment)x0, (long)x1, (TermIndex[])x2, (int)x3, (int)x4);
    }

    static /* synthetic */ LogSegmentList access$300(SegmentedRaftLogCache x0) {
        return x0.closedSegments;
    }

    static /* synthetic */ LogSegment access$400(SegmentedRaftLogCache x0) {
        return x0.openSegment;
    }
}

