/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.simulation.RaftServerReply;
import org.apache.ratis.server.simulation.RaftServerRequest;
import org.apache.ratis.server.simulation.SimulatedClientRpc;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.server.simulation.SimulatedRpc;
import org.apache.ratis.statemachine.StateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniRaftClusterWithSimulatedRpc
extends MiniRaftCluster {
    static final Logger LOG = LoggerFactory.getLogger(MiniRaftClusterWithSimulatedRpc.class);
    public static final MiniRaftCluster.Factory<MiniRaftClusterWithSimulatedRpc> FACTORY = new /* Unavailable Anonymous Inner Class!! */;
    private final SimulatedRequestReply<RaftServerRequest, RaftServerReply> serverRequestReply;
    private final SimulatedClientRpc client2serverRequestReply;

    private MiniRaftClusterWithSimulatedRpc(String[] ids, RaftProperties properties, SimulatedRequestReply<RaftServerRequest, RaftServerReply> serverRequestReply, SimulatedClientRpc client2serverRequestReply) {
        super(ids, properties, SimulatedRpc.Factory.newRaftParameters(serverRequestReply, (SimulatedClientRpc)client2serverRequestReply));
        this.serverRequestReply = serverRequestReply;
        this.client2serverRequestReply = client2serverRequestReply;
    }

    public void restart(boolean format) throws IOException {
        this.serverRequestReply.clear();
        this.client2serverRequestReply.clear();
        super.restart(format);
    }

    protected RaftServerProxy newRaftServer(RaftPeerId id, StateMachine.Registry stateMachineRegistry, RaftGroup group, RaftProperties properties) throws IOException {
        this.serverRequestReply.addPeer(id);
        this.client2serverRequestReply.addPeer(id);
        return ServerImplUtils.newRaftServer((RaftPeerId)id, (RaftGroup)group, (StateMachine.Registry)stateMachineRegistry, (RaftProperties)properties, (Parameters)this.parameters);
    }

    public void blockQueueAndSetDelay(String leaderId, int delayMs) throws InterruptedException {
        boolean block = delayMs > 0;
        LOG.debug("{} leader queue {} and set {}ms delay for the other queues", new Object[]{block ? "Block" : "Unblock", leaderId, delayMs});
        this.serverRequestReply.getQueue((String)leaderId).blockSendRequestTo.set(block);
        this.getServers().stream().filter(s -> !s.getId().toString().equals(leaderId)).map(s -> this.serverRequestReply.getQueue(s.getId().toString())).forEach(q -> q.delayTakeRequestTo.set(delayMs));
        long sleepMs = 3L * this.getTimeoutMax().toLong(TimeUnit.MILLISECONDS) / 2L;
        Thread.sleep(sleepMs);
    }

    public void setBlockRequestsFrom(String src, boolean block) {
        this.serverRequestReply.getQueue((String)src).blockTakeRequestFrom.set(block);
    }
}

