/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RaftRpcMessage;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.Preconditions;

class SimulatedRequestReply<REQUEST extends RaftRpcMessage, REPLY extends RaftRpcMessage> {
    static final String SIMULATE_LATENCY_KEY = SimulatedRequestReply.class.getName() + ".simulateLatencyMs";
    static final int SIMULATE_LATENCY_DEFAULT = RaftServerConfigKeys.Rpc.TIMEOUT_MIN_DEFAULT.toIntExact(TimeUnit.MILLISECONDS);
    static final long TIMEOUT = 3000L;
    private final Map<String, EventQueue<REQUEST, REPLY>> queues = new ConcurrentHashMap();
    private final int simulateLatencyMs;

    SimulatedRequestReply(int simulateLatencyMs) {
        this.simulateLatencyMs = simulateLatencyMs;
    }

    EventQueue<REQUEST, REPLY> getQueue(String qid) {
        return (EventQueue)this.queues.get(qid);
    }

    public REPLY sendRequest(REQUEST request) throws IOException {
        String qid = request.getReplierId();
        EventQueue q = (EventQueue)this.queues.get(qid);
        if (q == null) {
            throw new IOException("The peer " + qid + " is not alive.");
        }
        try {
            RaftTestUtil.block(q.blockSendRequestTo::get);
            return (REPLY)((RaftRpcMessage)q.request(request));
        }
        catch (InterruptedException e) {
            throw IOUtils.toInterruptedIOException((String)"", (InterruptedException)e);
        }
    }

    public REQUEST takeRequest(String qid) throws IOException {
        RaftRpcMessage request;
        EventQueue q = (EventQueue)this.queues.get(qid);
        if (q == null) {
            throw new IOException("The RPC of " + qid + " has already shutdown.");
        }
        try {
            RaftTestUtil.delay(q.delayTakeRequestTo::get);
            request = (RaftRpcMessage)q.takeRequest();
            Preconditions.assertTrue((boolean)qid.equals(request.getReplierId()));
            EventQueue reqQ = (EventQueue)this.queues.get(request.getRequestorId());
            if (reqQ != null) {
                RaftTestUtil.delay(reqQ.delayTakeRequestFrom::get);
                RaftTestUtil.block(reqQ.blockTakeRequestFrom::get);
            }
        }
        catch (InterruptedException e) {
            throw IOUtils.toInterruptedIOException((String)"", (InterruptedException)e);
        }
        return (REQUEST)request;
    }

    public void sendReply(REQUEST request, REPLY reply, IOException ioe) throws IOException {
        if (reply != null) {
            Preconditions.assertTrue((boolean)request.getRequestorId().equals(reply.getRequestorId()));
            Preconditions.assertTrue((boolean)request.getReplierId().equals(reply.getReplierId()));
        }
        this.simulateLatency();
        String qid = request.getReplierId();
        EventQueue q = (EventQueue)this.queues.get(qid);
        if (q != null) {
            q.reply(request, reply, ioe);
        }
    }

    public void shutdown(String id) {
        this.queues.remove(id);
    }

    public void clear() {
        this.queues.clear();
    }

    public void addPeer(RaftPeerId newPeer) {
        this.queues.put(newPeer.toString(), new EventQueue());
    }

    private void simulateLatency() throws IOException {
        if (this.simulateLatencyMs > 0) {
            int waitExpetation = this.simulateLatencyMs / 10;
            int waitHalfRange = waitExpetation / 3;
            int randomSleepMs = ThreadLocalRandom.current().nextInt(2 * waitHalfRange) + waitExpetation - waitHalfRange;
            try {
                Thread.sleep(randomSleepMs);
            }
            catch (InterruptedException ie) {
                throw IOUtils.toInterruptedIOException((String)"", (InterruptedException)ie);
            }
        }
    }
}

