/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.util.function.Consumer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.util.AutoCloseableLock;

/*
 * Exception performing whole class analysis ignored.
 */
public interface RaftStorageTestUtils {
    public static String getLogFlushTimeMetric(String memberId) {
        return RaftStorageTestUtils.getRaftLogFullMetric((String)memberId, (String)"flushTime");
    }

    public static String getRaftLogFullMetric(String memberId, String metricName) {
        return "ratis.log_worker." + memberId + "." + metricName;
    }

    public static void printLog(RaftLog log, Consumer<String> println) {
        long committed;
        long flushed;
        TermIndex last;
        if (log == null) {
            println.accept("log == null");
            return;
        }
        try (AutoCloseableLock readlock = log.readLock();){
            last = log.getLastEntryTermIndex();
            flushed = log.getFlushIndex();
            committed = log.getLastCommittedIndex();
        }
        StringBuilder b = new StringBuilder();
        for (long i = 0L; i <= last.getIndex(); ++i) {
            b.setLength(0);
            b.append(i == flushed ? (char)'f' : ' ');
            b.append(i == committed ? (char)'c' : ' ');
            b.append(String.format("%3d: ", i));
            try {
                b.append(ServerProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)log.get(i)));
            }
            catch (RaftLogIOException e) {
                b.append((Object)e);
            }
            println.accept(b.toString());
        }
    }
}

