/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.statemachine.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RaftSnapshotBaseTest
extends BaseTest {
    static final Logger LOG = LoggerFactory.getLogger(RaftSnapshotBaseTest.class);
    private static final int SNAPSHOT_TRIGGER_THRESHOLD = 10;
    private MiniRaftCluster cluster;

    public RaftSnapshotBaseTest() {
        Log4jUtils.setLogLevel((Logger)RaftServerImpl.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    public static List<File> getSnapshotFiles(MiniRaftCluster cluster, long startIndex, long endIndex) {
        RaftServerImpl leader = cluster.getLeader();
        SimpleStateMachineStorage storage = SimpleStateMachine4Testing.get((RaftServerImpl)leader).getStateMachineStorage();
        long term = leader.getState().getCurrentTerm();
        return LongStream.range(startIndex, endIndex).mapToObj(i -> storage.getSnapshotFile(term, i)).collect(Collectors.toList());
    }

    public static void assertLeaderContent(MiniRaftCluster cluster) throws Exception {
        RaftServerImpl leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        RaftLog leaderLog = leader.getState().getLog();
        long lastIndex = leaderLog.getLastEntryTermIndex().getIndex();
        RaftProtos.LogEntryProto e = leaderLog.get(lastIndex);
        Assert.assertTrue((boolean)e.hasMetadataEntry());
        JavaUtils.attemptRepeatedly(() -> {
            Assert.assertEquals((long)(leaderLog.getLastCommittedIndex() - 1L), (long)e.getMetadataEntry().getCommitIndex());
            return null;
        }, (int)50, (TimeDuration)BaseTest.HUNDRED_MILLIS, (String)"CheckMetadataEntry", (Logger)LOG);
        SimpleStateMachine4Testing simpleStateMachine = SimpleStateMachine4Testing.get((RaftServerImpl)leader);
        Assert.assertTrue((String)"Is not notified as a leader", (boolean)simpleStateMachine.isNotifiedAsLeader());
        RaftProtos.LogEntryProto[] entries = simpleStateMachine.getContent();
        long message = 0L;
        for (int i = 0; i < entries.length; ++i) {
            LOG.info("{}) {} {}", new Object[]{i, message, entries[i]});
            if (!entries[i].hasStateMachineLogEntry()) continue;
            RaftTestUtil.SimpleMessage m = new RaftTestUtil.SimpleMessage("m" + message++);
            Assert.assertArrayEquals((byte[])m.getContent().toByteArray(), (byte[])entries[i].getStateMachineLogEntry().getLogData().toByteArray());
        }
    }

    public abstract MiniRaftCluster.Factory<?> getFactory();

    @Before
    public void setup() throws IOException {
        RaftProperties prop = new RaftProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)prop, (long)10L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)prop, (boolean)true);
        this.cluster = this.getFactory().newCluster(1, prop);
        this.cluster.start();
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartPeer() throws Exception {
        RaftTestUtil.waitForLeader((MiniRaftCluster)this.cluster);
        RaftPeerId leaderId = this.cluster.getLeader().getId();
        try (RaftClient client = this.cluster.createClient(leaderId);){
            for (int i = 0; i < 19; ++i) {
                RaftClientReply reply = client.send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
        }
        long nextIndex = this.cluster.getLeader().getState().getLog().getNextIndex();
        LOG.info("nextIndex = {}", (Object)nextIndex);
        List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles((MiniRaftCluster)this.cluster, (long)(nextIndex - 10L), (long)nextIndex);
        JavaUtils.attemptRepeatedly(() -> {
            Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
            return null;
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
        this.cluster.restart(false);
        try {
            RaftSnapshotBaseTest.assertLeaderContent((MiniRaftCluster)this.cluster);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    public static boolean exists(File f) {
        if (f.exists()) {
            LOG.info("File exists: " + f);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicInstallSnapshot() throws Exception {
        List logs;
        int i;
        try {
            RaftTestUtil.waitForLeader((MiniRaftCluster)this.cluster);
            RaftPeerId leaderId = this.cluster.getLeader().getId();
            try (RaftClient client = this.cluster.createClient(leaderId);){
                for (i = 0; i < 19; ++i) {
                    RaftClientReply reply = client.send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftStorageDirectory storageDirectory = this.cluster.getLeader().getState().getStorage().getStorageDir();
            long nextIndex = this.cluster.getLeader().getState().getLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles((MiniRaftCluster)this.cluster, (long)(nextIndex - 10L), (long)nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            RaftSnapshotBaseTest.verifyTakeSnapshotMetric((RaftServerImpl)this.cluster.getLeader());
            logs = storageDirectory.getLogSegmentFiles();
        }
        finally {
            this.cluster.shutdown();
        }
        for (Object path : logs) {
            FileUtils.delete((Path)path.getPath());
        }
        LOG.info("Restarting the cluster");
        this.cluster.restart(false);
        try {
            Object path;
            RaftSnapshotBaseTest.assertLeaderContent((MiniRaftCluster)this.cluster);
            RaftClient client = this.cluster.createClient(this.cluster.getLeader().getId());
            path = null;
            try {
                Assert.assertTrue((boolean)client.send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            catch (Throwable nextIndex) {
                path = nextIndex;
                throw nextIndex;
            }
            finally {
                if (client != null) {
                    if (path != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable nextIndex) {
                            ((Throwable)path).addSuppressed(nextIndex);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            MiniRaftCluster.PeerChanges change = this.cluster.addNewPeers(new String[]{"s3", "s4"}, true);
            this.cluster.setConfiguration(change.allPeersInNewConf);
            this.verifyInstallSnapshotMetric(this.cluster.getLeader());
            RaftServerTestUtil.waitAndCheckNewConf((MiniRaftCluster)this.cluster, (RaftPeer[])change.allPeersInNewConf, (int)0, null);
            Timer timer = RaftSnapshotBaseTest.getTakeSnapshotTimer((RaftServerImpl)this.cluster.getLeader());
            long count = timer.getCount();
            this.cluster.restartServer(this.cluster.getLeader().getId(), false);
            RaftSnapshotBaseTest.assertLeaderContent((MiniRaftCluster)this.cluster);
            Assert.assertTrue((count < timer.getCount() ? 1 : 0) != 0);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    protected void verifyInstallSnapshotMetric(RaftServerImpl leader) {
        Counter installSnapshotCounter = leader.getRaftServerMetrics().getCounter("numInstallSnapshot");
        Assert.assertNotNull((Object)installSnapshotCounter);
        Assert.assertTrue((installSnapshotCounter.getCount() >= 1L ? 1 : 0) != 0);
    }

    private static void verifyTakeSnapshotMetric(RaftServerImpl leader) {
        Timer timer = RaftSnapshotBaseTest.getTakeSnapshotTimer((RaftServerImpl)leader);
        Assert.assertTrue((timer.getCount() > 0L ? 1 : 0) != 0);
    }

    private static Timer getTakeSnapshotTimer(RaftServerImpl leader) {
        MetricRegistryInfo info = new MetricRegistryInfo(leader.getMemberId().toString(), "ratis", "state_machine", "Metrics for State Machine Updater");
        Optional opt = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)opt.isPresent());
        RatisMetricRegistry metricRegistry = (RatisMetricRegistry)opt.get();
        Assert.assertNotNull((Object)metricRegistry);
        return metricRegistry.timer("takeSnapshot");
    }
}

