/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;

public class BaseStateMachine
implements StateMachine,
StateMachine.DataApi {
    private final CompletableFuture<RaftServer> server = new CompletableFuture();
    private volatile RaftGroupId groupId;
    private final LifeCycle lifeCycle = new LifeCycle((Object)this.getClass().getSimpleName());
    private final AtomicReference<TermIndex> lastAppliedTermIndex = new AtomicReference();
    private final SortedMap<Long, CompletableFuture<Void>> transactionFutures = new TreeMap();

    public BaseStateMachine() {
        this.setLastAppliedTermIndex(TermIndex.newTermIndex((long)0L, (long)-1L));
    }

    public RaftPeerId getId() {
        return this.server.isDone() ? ((RaftServer)this.server.join()).getId() : null;
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public CompletableFuture<RaftServer> getServer() {
        return this.server;
    }

    public RaftGroupId getGroupId() {
        return this.groupId;
    }

    public LifeCycle.State getLifeCycleState() {
        return this.lifeCycle.getCurrentState();
    }

    public void initialize(RaftServer raftServer, RaftGroupId raftGroupId, RaftStorage storage) throws IOException {
        this.groupId = raftGroupId;
        this.server.complete(raftServer);
        this.lifeCycle.setName("" + this);
    }

    public SnapshotInfo getLatestSnapshot() {
        return this.getStateMachineStorage().getLatestSnapshot();
    }

    public void notifyNotLeader(Collection<TransactionContext> pendingEntries) throws IOException {
    }

    public void pause() {
    }

    public void reinitialize() throws IOException {
    }

    public TransactionContext applyTransactionSerial(TransactionContext trx) {
        return trx;
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        RaftProtos.LogEntryProto entry = Objects.requireNonNull(trx.getLogEntry());
        this.updateLastAppliedTermIndex(entry.getTerm(), entry.getIndex());
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)trx.getLogEntry().getStateMachineLogEntry().getLogData()));
    }

    public TermIndex getLastAppliedTermIndex() {
        return (TermIndex)this.lastAppliedTermIndex.get();
    }

    protected void setLastAppliedTermIndex(TermIndex newTI) {
        this.lastAppliedTermIndex.set(newTI);
    }

    public void notifyIndexUpdate(long term, long index) {
        this.updateLastAppliedTermIndex(term, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateLastAppliedTermIndex(long term, long index) {
        TermIndex oldTI;
        TermIndex newTI = TermIndex.newTermIndex((long)term, (long)index);
        if (!newTI.equals(oldTI = this.lastAppliedTermIndex.getAndSet(newTI))) {
            LOG.trace("{}: update lastAppliedTermIndex from {} to {}", new Object[]{this.getId(), oldTI, newTI});
            if (oldTI != null) {
                Preconditions.assertTrue((newTI.compareTo((Object)oldTI) >= 0 ? 1 : 0) != 0, () -> this.getId() + ": Failed updateLastAppliedTermIndex: newTI = " + newTI + " < oldTI = " + oldTI);
            }
            return true;
        }
        SortedMap sortedMap = this.transactionFutures;
        synchronized (sortedMap) {
            long i;
            while (!this.transactionFutures.isEmpty() && (i = ((Long)this.transactionFutures.firstKey()).longValue()) <= index) {
                ((CompletableFuture)this.transactionFutures.remove(i)).complete(null);
            }
        }
        return false;
    }

    public long takeSnapshot() throws IOException {
        return -1L;
    }

    public StateMachineStorage getStateMachineStorage() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Message> queryStale(Message request, long minIndex) {
        if (this.getLastAppliedTermIndex().getIndex() < minIndex) {
            SortedMap sortedMap = this.transactionFutures;
            synchronized (sortedMap) {
                if (this.getLastAppliedTermIndex().getIndex() < minIndex) {
                    return this.transactionFutures.computeIfAbsent(minIndex, key -> new CompletableFuture()).thenCompose(v -> this.query(request));
                }
            }
        }
        return this.query(request);
    }

    public CompletableFuture<Message> query(Message request) {
        return CompletableFuture.completedFuture(null);
    }

    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        return TransactionContext.newBuilder().setStateMachine((StateMachine)this).setClientRequest(request).build();
    }

    public TransactionContext cancelTransaction(TransactionContext trx) throws IOException {
        return trx;
    }

    public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
        return trx;
    }

    public void close() throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + (!this.server.isDone() ? "uninitialized" : this.getId() + ":" + this.groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Message> recordTime(Timer timer, Task task) {
        Timer.Context timerContext = timer.time();
        try {
            CompletableFuture completableFuture = task.run();
            return completableFuture;
        }
        finally {
            timerContext.stop();
        }
    }
}

