/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;

public class TransactionContextImpl
implements TransactionContext {
    private final RaftProtos.RaftPeerRole serverRole;
    private final StateMachine stateMachine;
    private RaftClientRequest clientRequest;
    private Exception exception;
    private RaftProtos.StateMachineLogEntryProto smLogEntryProto;
    private Object stateMachineContext;
    private boolean shouldCommit = true;
    private RaftProtos.LogEntryProto logEntry;

    private TransactionContextImpl(RaftProtos.RaftPeerRole serverRole, StateMachine stateMachine) {
        this.serverRole = serverRole;
        this.stateMachine = stateMachine;
    }

    public TransactionContextImpl(StateMachine stateMachine, RaftClientRequest clientRequest, RaftProtos.StateMachineLogEntryProto smLogEntryProto, Object stateMachineContext) {
        this(RaftProtos.RaftPeerRole.LEADER, stateMachine);
        this.clientRequest = clientRequest;
        this.smLogEntryProto = smLogEntryProto != null ? smLogEntryProto : ServerProtoUtils.toStateMachineLogEntryProto((RaftClientRequest)clientRequest, null, null);
        this.stateMachineContext = stateMachineContext;
    }

    public TransactionContextImpl(RaftProtos.RaftPeerRole serverRole, StateMachine stateMachine, RaftProtos.LogEntryProto logEntry) {
        this(serverRole, stateMachine);
        this.logEntry = logEntry;
        this.smLogEntryProto = logEntry.getStateMachineLogEntry();
    }

    public RaftProtos.RaftPeerRole getServerRole() {
        return this.serverRole;
    }

    public RaftClientRequest getClientRequest() {
        return this.clientRequest;
    }

    public RaftProtos.StateMachineLogEntryProto getStateMachineLogEntry() {
        return this.smLogEntryProto;
    }

    public Exception getException() {
        return this.exception;
    }

    public TransactionContext setStateMachineContext(Object context) {
        this.stateMachineContext = context;
        return this;
    }

    public Object getStateMachineContext() {
        return this.stateMachineContext;
    }

    public RaftProtos.LogEntryProto initLogEntry(long term, long index) {
        Preconditions.assertTrue((this.serverRole == RaftProtos.RaftPeerRole.LEADER ? 1 : 0) != 0);
        Preconditions.assertNull((Object)this.logEntry, (String)"logEntry");
        Objects.requireNonNull(this.smLogEntryProto, "smLogEntryProto == null");
        this.logEntry = ServerProtoUtils.toLogEntryProto((RaftProtos.StateMachineLogEntryProto)this.smLogEntryProto, (long)term, (long)index);
        return this.logEntry;
    }

    public TransactionContext setStateMachineLogEntryProto(RaftProtos.StateMachineLogEntryProto logEntryProto) {
        this.smLogEntryProto = logEntryProto;
        return this;
    }

    public RaftProtos.LogEntryProto getLogEntry() {
        return this.logEntry;
    }

    public TransactionContext setException(Exception ioe) {
        this.exception = ioe;
        return this;
    }

    public TransactionContext setShouldCommit(boolean sCommit) {
        this.shouldCommit = sCommit;
        return this;
    }

    public boolean shouldCommit() {
        return this.shouldCommit;
    }

    public TransactionContext preAppendTransaction() throws IOException {
        return this.stateMachine.preAppendTransaction((TransactionContext)this);
    }

    public TransactionContext cancelTransaction() throws IOException {
        return this.stateMachine.cancelTransaction((TransactionContext)this);
    }
}

