/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.common.cache.Cache;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheStats;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryCache
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(RetryCache.class);
    private final Cache<CacheKey, CacheEntry> cache;

    RetryCache(TimeDuration expirationTime) {
        this.cache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(expirationTime.getDuration(), expirationTime.getUnit()).build();
    }

    CacheEntry getOrCreateEntry(ClientId clientId, long callId) {
        CacheEntry entry;
        CacheKey key = new CacheKey(clientId, callId);
        try {
            entry = (CacheEntry)this.cache.get((Object)key, () -> new CacheEntry(key));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        return entry;
    }

    CacheEntry refreshEntry(CacheEntry newEntry) {
        this.cache.put((Object)newEntry.key, (Object)newEntry);
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheQueryResult queryCache(ClientId clientId, long callId) {
        CacheEntry cacheEntry;
        CacheKey key = new CacheKey(clientId, callId);
        CacheEntry newEntry = new CacheEntry(key);
        try {
            cacheEntry = (CacheEntry)this.cache.get((Object)key, () -> newEntry);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        if (cacheEntry == newEntry) {
            return new CacheQueryResult(cacheEntry, false);
        }
        if (!cacheEntry.isDone() || !cacheEntry.isFailed()) {
            return new CacheQueryResult(cacheEntry, true);
        }
        RetryCache retryCache = this;
        synchronized (retryCache) {
            CacheEntry currentEntry = (CacheEntry)this.cache.getIfPresent((Object)key);
            if (currentEntry == cacheEntry || currentEntry == null) {
                return new CacheQueryResult(this.refreshEntry(newEntry), false);
            }
            return new CacheQueryResult(currentEntry, true);
        }
    }

    @VisibleForTesting
    public long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    @VisibleForTesting
    CacheEntry get(ClientId clientId, long callId) {
        return (CacheEntry)this.cache.getIfPresent((Object)new CacheKey(clientId, callId));
    }

    @Override
    public synchronized void close() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    static CompletableFuture<RaftClientReply> failWithReply(RaftClientReply reply, CacheEntry entry) {
        if (entry != null) {
            entry.failWithReply(reply);
            return entry.getReplyFuture();
        }
        return CompletableFuture.completedFuture(reply);
    }

    static CompletableFuture<RaftClientReply> failWithException(Throwable t, CacheEntry entry) {
        if (entry != null) {
            entry.failWithException(t);
            return entry.getReplyFuture();
        }
        return JavaUtils.completeExceptionally((Throwable)t);
    }

    static class CacheQueryResult {
        private final CacheEntry entry;
        private final boolean isRetry;

        CacheQueryResult(CacheEntry entry, boolean isRetry) {
            this.entry = entry;
            this.isRetry = isRetry;
        }

        public CacheEntry getEntry() {
            return this.entry;
        }

        public boolean isRetry() {
            return this.isRetry;
        }
    }

    @VisibleForTesting
    public static class CacheEntry {
        private final CacheKey key;
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();
        private volatile boolean failed = false;

        CacheEntry(CacheKey key) {
            this.key = key;
        }

        public String toString() {
            return this.key + ":" + (this.isDone() ? "done" : "pending");
        }

        boolean isDone() {
            return this.isFailed() || this.replyFuture.isDone();
        }

        boolean isCompletedNormally() {
            return !this.failed && this.replyFuture.isDone() && !this.replyFuture.isCompletedExceptionally() && !this.replyFuture.isCancelled();
        }

        void updateResult(RaftClientReply reply) {
            assert (!this.replyFuture.isDone() && !this.replyFuture.isCancelled());
            this.replyFuture.complete(reply);
        }

        boolean isFailed() {
            return this.failed || this.replyFuture.isCompletedExceptionally();
        }

        void failWithReply(RaftClientReply reply) {
            this.failed = true;
            this.replyFuture.complete(reply);
        }

        void failWithException(Throwable t) {
            this.failed = true;
            this.replyFuture.completeExceptionally(t);
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        CacheKey getKey() {
            return this.key;
        }
    }

    static class CacheKey {
        private final ClientId clientId;
        private final long callId;

        CacheKey(ClientId clientId, long callId) {
            this.clientId = clientId;
            this.callId = callId;
        }

        public int hashCode() {
            return this.clientId.hashCode() ^ Long.hashCode(this.callId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey e = (CacheKey)obj;
                return e.clientId.equals((Object)this.clientId) && this.callId == e.callId;
            }
            return false;
        }

        public String toString() {
            return this.clientId.toString() + ":" + this.callId;
        }
    }
}

