/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.server.impl.RaftServerImpl;

public final class LeaderElectionMetrics
extends RatisMetrics {
    public static final String RATIS_LEADER_ELECTION_METRICS = "leader_election";
    public static final String RATIS_LEADER_ELECTION_METRICS_DESC = "Metrics for Ratis Leader Election.";
    public static final String LEADER_ELECTION_COUNT_METRIC = "electionCount";
    public static final String LEADER_ELECTION_TIMEOUT_COUNT_METRIC = "electionTimeoutCount";
    public static final String LEADER_ELECTION_LATENCY = "electionLatency";
    public static final String LAST_LEADER_ELAPSED_TIME = "lastLeaderElapsedTime";
    private long leaderElectionCompletionLatency = 0L;

    private LeaderElectionMetrics(RaftServerImpl raftServer) {
        this.registry = this.getMetricRegistryForLeaderElection(raftServer.getMemberId().toString());
        this.registry.gauge(LEADER_ELECTION_LATENCY, () -> () -> this.leaderElectionCompletionLatency);
        this.registry.gauge(LAST_LEADER_ELAPSED_TIME, () -> () -> raftServer.getState().getLastLeaderElapsedTimeMs());
    }

    private RatisMetricRegistry getMetricRegistryForLeaderElection(String serverId) {
        return this.create(new MetricRegistryInfo(serverId, "ratis", RATIS_LEADER_ELECTION_METRICS, RATIS_LEADER_ELECTION_METRICS_DESC));
    }

    public static LeaderElectionMetrics getLeaderElectionMetrics(RaftServerImpl raftServer) {
        return new LeaderElectionMetrics(raftServer);
    }

    public void onNewLeaderElection() {
        this.registry.counter(LEADER_ELECTION_COUNT_METRIC).inc();
    }

    public void onLeaderElectionCompletion(long elapsedTime) {
        this.leaderElectionCompletionLatency = elapsedTime;
    }

    public void onLeaderElectionTimeout() {
        this.registry.counter(LEADER_ELECTION_TIMEOUT_COUNT_METRIC).inc();
    }
}

