/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.impl.FollowerInfo;

public final class LogAppenderMetrics
extends RatisMetrics {
    public static final String RATIS_LOG_APPENDER_METRICS = "log_appender";
    public static final String RATIS_LOG_APPENDER_METRICS_DESC = "Metrics for log appender";

    public LogAppenderMetrics(RaftGroupMemberId groupMemberId) {
        this.registry = this.getMetricRegistryForLogAppender(groupMemberId.toString());
    }

    private RatisMetricRegistry getMetricRegistryForLogAppender(String serverId) {
        return this.create(new MetricRegistryInfo(serverId, "ratis", RATIS_LOG_APPENDER_METRICS, RATIS_LOG_APPENDER_METRICS_DESC));
    }

    public void addFollowerGauges(FollowerInfo followerInfo) {
        this.registry.gauge(String.format("follower_%s_next_index", followerInfo.getPeer().getId().toString()), () -> followerInfo::getNextIndex);
        this.registry.gauge(String.format("follower_%s_match_index", followerInfo.getPeer().getId().toString()), () -> followerInfo::getMatchIndex);
        this.registry.gauge(String.format("follower_%s_rpc_response_time", followerInfo.getPeer().getId().toString()), () -> () -> followerInfo.getLastRpcTime().elapsedTimeMs());
    }
}

