/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.TransactionContextImpl;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;

public interface TransactionContext {
    public RaftProtos.RaftPeerRole getServerRole();

    public RaftClientRequest getClientRequest();

    public RaftProtos.StateMachineLogEntryProto getStateMachineLogEntry();

    public TransactionContext setException(Exception var1);

    public Exception getException();

    public TransactionContext setStateMachineContext(Object var1);

    public Object getStateMachineContext();

    public RaftProtos.LogEntryProto initLogEntry(long var1, long var3);

    public TransactionContext setStateMachineLogEntryProto(RaftProtos.StateMachineLogEntryProto var1);

    public RaftProtos.LogEntryProto getLogEntry();

    public TransactionContext setShouldCommit(boolean var1);

    public boolean shouldCommit();

    public TransactionContext preAppendTransaction() throws IOException;

    public TransactionContext cancelTransaction() throws IOException;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private RaftProtos.RaftPeerRole serverRole = RaftProtos.RaftPeerRole.LEADER;
        private StateMachine stateMachine;
        private Object stateMachineContext;
        private RaftClientRequest clientRequest;
        private RaftProtos.LogEntryProto logEntry;
        private RaftProtos.StateMachineLogEntryProto stateMachineLogEntry;
        private ByteString logData;
        private ByteString stateMachineData;

        public Builder setServerRole(RaftProtos.RaftPeerRole serverRole) {
            this.serverRole = serverRole;
            return this;
        }

        public Builder setStateMachine(StateMachine stateMachine) {
            this.stateMachine = stateMachine;
            return this;
        }

        public Builder setStateMachineContext(Object stateMachineContext) {
            this.stateMachineContext = stateMachineContext;
            return this;
        }

        public Builder setClientRequest(RaftClientRequest clientRequest) {
            this.clientRequest = clientRequest;
            return this;
        }

        public Builder setLogEntry(RaftProtos.LogEntryProto logEntry) {
            this.logEntry = logEntry;
            return this;
        }

        public Builder setStateMachineLogEntry(RaftProtos.StateMachineLogEntryProto stateMachineLogEntry) {
            this.stateMachineLogEntry = stateMachineLogEntry;
            return this;
        }

        public Builder setLogData(ByteString logData) {
            this.logData = logData;
            return this;
        }

        public Builder setStateMachineData(ByteString stateMachineData) {
            this.stateMachineData = stateMachineData;
            return this;
        }

        public TransactionContext build() {
            Objects.requireNonNull(this.serverRole, "serverRole == null");
            Objects.requireNonNull(this.stateMachine, "stateMachine == null");
            if (this.clientRequest != null) {
                Preconditions.assertTrue((this.serverRole == RaftProtos.RaftPeerRole.LEADER ? 1 : 0) != 0, () -> "serverRole MUST be LEADER since clientRequest != null, serverRole is " + this.serverRole);
                Preconditions.assertNull((Object)this.logEntry, () -> "logEntry MUST be null since clientRequest != null");
                if (this.stateMachineLogEntry == null) {
                    this.stateMachineLogEntry = ServerProtoUtils.toStateMachineLogEntryProto(this.clientRequest, this.logData, this.stateMachineData);
                }
                return new TransactionContextImpl(this.stateMachine, this.clientRequest, this.stateMachineLogEntry, this.stateMachineContext);
            }
            Objects.requireNonNull(this.logEntry, "logEntry MUST NOT be null since clientRequest == null");
            Preconditions.assertTrue((boolean)this.logEntry.hasStateMachineLogEntry(), () -> "Unexpected logEntry: stateMachineLogEntry not found, logEntry=" + this.logEntry);
            return new TransactionContextImpl(this.serverRole, this.stateMachine, this.logEntry);
        }
    }
}

