/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;

public class FileChunkReader
implements Closeable {
    private final FileInfo info;
    private final Path relativePath;
    private final FileInputStream in;
    private long offset = 0L;
    private int chunkIndex = 0;

    public FileChunkReader(FileInfo info, RaftStorageDirectory directory) throws IOException {
        this.info = info;
        this.relativePath = Optional.of(info.getPath()).filter(Path::isAbsolute).map(p -> directory.getRoot().toPath().relativize((Path)p)).orElse(info.getPath());
        File f = info.getPath().toFile();
        this.in = new FileInputStream(f);
    }

    public RaftProtos.FileChunkProto readFileChunk(int chunkMaxSize) throws IOException {
        long remaining = this.info.getFileSize() - this.offset;
        int chunkLength = remaining < (long)chunkMaxSize ? (int)remaining : chunkMaxSize;
        ByteString data = ByteString.readFrom((InputStream)this.in, (int)chunkLength);
        RaftProtos.FileChunkProto proto = RaftProtos.FileChunkProto.newBuilder().setFilename(this.relativePath.toString()).setOffset(this.offset).setChunkIndex(this.chunkIndex).setDone(this.offset + (long)chunkLength == this.info.getFileSize()).setData(data).setFileDigest(ByteString.copyFrom((byte[])this.info.getFileDigest().getDigest())).build();
        ++this.chunkIndex;
        this.offset += (long)chunkLength;
        return proto;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + "{chunkIndex=" + this.chunkIndex + ", offset=" + this.offset + ", " + this.info + '}';
    }
}

