/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectoryImpl;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.server.storage.RaftStorageMetadataFile;
import org.apache.ratis.server.storage.RaftStorageMetadataFileImpl;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

public class RaftStorageImpl
implements RaftStorage {
    private final RaftStorageDirectoryImpl storageDir;
    private final RaftStorageDirectoryImpl.StorageState state;
    private final RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy;
    private volatile RaftStorageMetadataFileImpl metaFile;

    public RaftStorageImpl(File dir, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy) throws IOException {
        this(dir, logCorruptionPolicy, null);
    }

    RaftStorageImpl(File dir, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy, StartupOption option) throws IOException {
        this.storageDir = new RaftStorageDirectoryImpl(dir);
        if (option == StartupOption.FORMAT) {
            if (this.storageDir.analyzeStorage(false) == RaftStorageDirectoryImpl.StorageState.NON_EXISTENT) {
                throw new IOException("Cannot format " + this.storageDir);
            }
            this.storageDir.lock();
            this.format();
            this.state = this.storageDir.analyzeStorage(false);
            Preconditions.assertTrue((this.state == RaftStorageDirectoryImpl.StorageState.NORMAL ? 1 : 0) != 0);
        } else {
            this.state = this.analyzeAndRecoverStorage(true);
            if (this.state != RaftStorageDirectoryImpl.StorageState.NORMAL) {
                this.storageDir.unlock();
                throw new IOException("Cannot load " + this.storageDir + ". Its state: " + (Object)((Object)this.state));
            }
        }
        this.logCorruptionPolicy = Optional.ofNullable(logCorruptionPolicy).orElseGet(RaftServerConfigKeys.Log.CorruptionPolicy::getDefault);
    }

    RaftStorageDirectoryImpl.StorageState getState() {
        return this.state;
    }

    public RaftServerConfigKeys.Log.CorruptionPolicy getLogCorruptionPolicy() {
        return this.logCorruptionPolicy;
    }

    private void format() throws IOException {
        this.storageDir.clearDirectory();
        this.metaFile = new RaftStorageMetadataFileImpl(this.storageDir.getMetaFile());
        this.metaFile.persist(RaftStorageMetadata.getDefault());
        LOG.info("Storage directory " + this.storageDir.getRoot() + " has been successfully formatted.");
    }

    private void cleanMetaTmpFile() throws IOException {
        Files.deleteIfExists(this.storageDir.getMetaTmpFile().toPath());
    }

    private RaftStorageDirectoryImpl.StorageState analyzeAndRecoverStorage(boolean toLock) throws IOException {
        RaftStorageDirectoryImpl.StorageState storageState = this.storageDir.analyzeStorage(toLock);
        if (storageState != RaftStorageDirectoryImpl.StorageState.NON_EXISTENT) {
            this.cleanMetaTmpFile();
        }
        if (storageState == RaftStorageDirectoryImpl.StorageState.NORMAL) {
            File f = this.storageDir.getMetaFile();
            if (!f.exists()) {
                throw new FileNotFoundException("Metadata file " + f + " does not exists.");
            }
            this.metaFile = new RaftStorageMetadataFileImpl(f);
            RaftStorageMetadata metadata = this.metaFile.getMetadata();
            LOG.info("Read {} from {}", (Object)metadata, (Object)f);
            return RaftStorageDirectoryImpl.StorageState.NORMAL;
        }
        if (storageState == RaftStorageDirectoryImpl.StorageState.NOT_FORMATTED && this.storageDir.isCurrentEmpty()) {
            this.format();
            return RaftStorageDirectoryImpl.StorageState.NORMAL;
        }
        return storageState;
    }

    public RaftStorageDirectoryImpl getStorageDir() {
        return this.storageDir;
    }

    public void close() throws IOException {
        this.storageDir.unlock();
    }

    public RaftStorageMetadataFile getMetadataFile() {
        return this.metaFile;
    }

    public void writeRaftConfiguration(RaftProtos.LogEntryProto conf) {
        File confFile = this.storageDir.getMetaConfFile();
        try (FileOutputStream fio = new FileOutputStream(confFile);){
            conf.writeTo((OutputStream)fio);
        }
        catch (Exception e) {
            LOG.error("Failed writing configuration to file:" + confFile, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RaftConfiguration readRaftConfiguration() {
        File confFile = this.storageDir.getMetaConfFile();
        try (FileInputStream fio = new FileInputStream(confFile);){
            RaftProtos.LogEntryProto confProto = ((RaftProtos.LogEntryProto.Builder)RaftProtos.LogEntryProto.newBuilder().mergeFrom((InputStream)fio)).build();
            RaftConfiguration raftConfiguration = LogProtoUtils.toRaftConfiguration(confProto);
            return raftConfiguration;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error("Failed reading configuration from file:" + confFile, (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.getStorageDir();
    }

    public static enum StartupOption {
        FORMAT;

    }
}

