/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.ReconfigurationInProgressException;
import org.apache.ratis.protocol.exceptions.ReconfigurationTimeoutException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.BlockRequestHandlingInjection;
import org.apache.ratis.server.impl.ConfigurationManager;
import org.apache.ratis.server.impl.DelayLocalExecutionInjection;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogBase;
import org.apache.ratis.server.storage.RaftStorageTestUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class RaftReconfigurationBaseTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    private static final DelayLocalExecutionInjection logSyncDelay;
    private static final DelayLocalExecutionInjection leaderPlaceHolderDelay;
    static final int STAGING_CATCHUP_GAP = 10;

    public RaftReconfigurationBaseTest() {
        RaftServerConfigKeys.setStagingCatchupGap((RaftProperties)this.getProperties(), (int)10);
    }

    private void checkPriority(CLUSTER cluster, RaftGroupId groupId, List<RaftPeer> peersWithPriority) throws InterruptedException {
        RaftTestUtil.waitForLeader(cluster, (RaftGroupId)groupId);
        for (int i = 0; i < peersWithPriority.size(); ++i) {
            RaftPeerId peerId = peersWithPriority.get(i).getId();
            RaftServer.Division server = cluster.getDivision(peerId, groupId);
            RaftConfiguration conf = server.getRaftConf();
            for (int j = 0; j < peersWithPriority.size(); ++j) {
                int priorityInConf = conf.getPeer(peersWithPriority.get(j).getId()).getPriority();
                Assert.assertEquals((long)priorityInConf, (long)peersWithPriority.get(j).getPriority());
            }
        }
    }

    @Test
    public void testRestorePriority() throws Exception {
        this.runWithNewCluster(3, cluster -> {
            List peers = cluster.getPeers();
            ArrayList<RaftPeer> peersWithPriority = new ArrayList<RaftPeer>();
            for (int i = 0; i < peers.size(); ++i) {
                RaftPeer peer = (RaftPeer)peers.get(i);
                peersWithPriority.add(RaftPeer.newBuilder((RaftPeer)peer).setPriority(i).build());
            }
            RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), peersWithPriority);
            this.LOG.info("add new group: " + newGroup);
            try (RaftClient client = cluster.createClient(newGroup);){
                for (RaftPeer p : newGroup.getPeers()) {
                    client.getGroupManagementApi(p.getId()).add(newGroup);
                }
            }
            RaftGroupId groupId = newGroup.getGroupId();
            this.checkPriority(cluster, groupId, peersWithPriority);
            cluster.restart(false);
            this.checkPriority(cluster, groupId, peersWithPriority);
        });
    }

    @Test
    public void testAddPeers() throws Exception {
        this.runWithNewCluster(3, cluster -> {
            RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
            RaftPeer[] allPeers = cluster.addNewPeers((int)2, (boolean)true).allPeersInNewConf;
            cluster.setConfiguration(allPeers);
            RaftServerTestUtil.waitAndCheckNewConf((MiniRaftCluster)cluster, (RaftPeer[])allPeers, (int)0, null);
        });
    }

    @Test
    public void testRemovePeers() throws Exception {
        this.runWithNewCluster(5, cluster -> {
            RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
            RaftPeer[] allPeers = cluster.removePeers((int)2, (boolean)false, Collections.emptyList()).allPeersInNewConf;
            cluster.setConfiguration(allPeers);
            RaftServerTestUtil.waitAndCheckNewConf((MiniRaftCluster)cluster, (RaftPeer[])allPeers, (int)2, null);
        });
    }

    @Test
    public void testAddRemovePeers() throws Exception {
        this.runWithNewCluster(5, cluster -> this.runTestAddRemovePeers(false, cluster));
    }

    @Test
    public void testLeaderStepDown() throws Exception {
        this.runWithNewCluster(5, cluster -> this.runTestAddRemovePeers(true, cluster));
    }

    private void runTestAddRemovePeers(boolean leaderStepdown, CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true);
        RaftPeer[] allPeers = cluster.removePeers((int)2, (boolean)leaderStepdown, Arrays.asList(change.newPeers)).allPeersInNewConf;
        cluster.setConfiguration(allPeers);
        RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])allPeers, (int)2, null);
    }

    @Test(timeout=30000L)
    public void testReconfTwice() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestReconfTwice(arg_0));
    }

    void runTestReconfTwice(CLUSTER cluster) throws Exception {
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            for (int i = 0; i < 20; ++i) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
            AtomicBoolean reconf1 = new AtomicBoolean(false);
            AtomicBoolean reconf2 = new AtomicBoolean(false);
            AtomicReference<Object> finalPeers = new AtomicReference<Object>(null);
            AtomicReference<Object> deadPeers = new AtomicReference<Object>(null);
            CountDownLatch latch = new CountDownLatch(1);
            Thread clientThread = new Thread(() -> {
                try {
                    MiniRaftCluster.PeerChanges c1 = cluster.addNewPeers(2, true);
                    this.LOG.info("Start changing the configuration: {}", Arrays.asList(c1.allPeersInNewConf));
                    RaftClientReply reply = client.admin().setConfiguration(c1.allPeersInNewConf);
                    reconf1.set(reply.isSuccess());
                    MiniRaftCluster.PeerChanges c2 = cluster.removePeers(2, true, Arrays.asList(c1.newPeers));
                    finalPeers.set(c2.allPeersInNewConf);
                    deadPeers.set(c2.removedPeers);
                    this.LOG.info("Start changing the configuration again: {}", Arrays.asList(c2.allPeersInNewConf));
                    reply = client.admin().setConfiguration(c2.allPeersInNewConf);
                    reconf2.set(reply.isSuccess());
                    latch.countDown();
                }
                catch (Exception ignored) {
                    this.LOG.warn("{} is ignored", (Object)JavaUtils.getClassSimpleName(ignored.getClass()), (Object)ignored);
                }
            });
            clientThread.start();
            latch.await();
            Assert.assertTrue((boolean)reconf1.get());
            Assert.assertTrue((boolean)reconf2.get());
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])finalPeers.get(), (int)2, null);
            RaftPeerId leader2 = RaftTestUtil.waitForLeader(cluster).getId();
            cluster.getServerAliveStream().forEach(server -> {
                ConfigurationManager confManager = RaftServerTestUtil.getConfigurationManager((RaftServer.Division)server);
                int expectedConf = leader2.equals((Object)leaderId) ? 6 : 7;
                Assert.assertEquals((String)(server.getId() + ": " + confManager), (long)expectedConf, (long)confManager.numOfConf());
            });
        }
    }

    @Test
    public void testReconfTimeout() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestReconfTimeout(arg_0));
    }

    void runTestReconfTimeout(CLUSTER cluster) throws Exception {
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            MiniRaftCluster.PeerChanges c1 = cluster.addNewPeers(2, false);
            this.LOG.info("Start changing the configuration: {}", Arrays.asList(c1.allPeersInNewConf));
            Assert.assertFalse((boolean)((RaftConfigurationImpl)cluster.getLeader().getRaftConf()).isTransitional());
            RaftClientRpc sender = client.getClientRpc();
            SetConfigurationRequest request = cluster.newSetConfigurationRequest(client.getId(), leaderId, c1.allPeersInNewConf);
            try {
                sender.sendRequest((RaftClientRequest)request);
                Assert.fail((String)"did not get expected exception");
            }
            catch (IOException e) {
                Assert.assertTrue((String)("Got exception " + e), (boolean)(e instanceof ReconfigurationTimeoutException));
            }
            this.LOG.info(cluster.printServers());
            try {
                sender.sendRequest((RaftClientRequest)request);
                Assert.fail((String)"did not get expected exception");
            }
            catch (IOException e) {
                Assert.assertTrue((String)("Got exception " + e), (boolean)(e instanceof ReconfigurationTimeoutException));
            }
            this.LOG.info("Start new peers");
            for (RaftPeer np : c1.newPeers) {
                cluster.restartServer(np.getId(), false);
            }
            Assert.assertTrue((boolean)client.admin().setConfiguration(c1.allPeersInNewConf).isSuccess());
        }
    }

    @Test
    public void testBootstrapReconfWithSingleNodeAddOne() throws Exception {
        this.runWithNewCluster(1, cluster -> this.runTestBootstrapReconf(1, false, cluster));
    }

    @Test
    public void testBootstrapReconfWithSingleNodeAddTwo() throws Exception {
        this.runWithNewCluster(1, cluster -> this.runTestBootstrapReconf(2, false, cluster));
    }

    @Test
    public void testBootstrapReconf() throws Exception {
        this.runWithNewCluster(3, cluster -> this.runTestBootstrapReconf(2, true, cluster));
    }

    void runTestBootstrapReconf(int numNewPeer, boolean startNewPeer, CLUSTER cluster) throws Exception {
        this.LOG.info("Originally {} peer(s), add {} more, startNewPeer={}", new Object[]{cluster.getNumServers(), numNewPeer, startNewPeer});
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = cluster.getLeader().getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            for (int i = 0; i < 20; ++i) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
            MiniRaftCluster.PeerChanges c1 = cluster.addNewPeers(numNewPeer, startNewPeer);
            this.LOG.info("Start changing the configuration: {}", Arrays.asList(c1.allPeersInNewConf));
            AtomicReference success = new AtomicReference();
            Thread clientThread = new Thread(() -> {
                try {
                    RaftClientReply reply = client.admin().setConfiguration(c1.allPeersInNewConf);
                    success.set(reply.isSuccess());
                }
                catch (IOException ioe) {
                    this.LOG.error("FAILED", (Throwable)ioe);
                }
            });
            clientThread.start();
            if (!startNewPeer) {
                RaftTestUtil.waitFor(() -> clientThread.isAlive(), (int)300, (int)5000);
                ONE_SECOND.sleep();
                this.LOG.info("start new peer(s): {}", (Object[])c1.newPeers);
                for (RaftPeer p : c1.newPeers) {
                    cluster.restartServer(p.getId(), true);
                }
            }
            RaftTestUtil.waitFor(() -> success.get() != null && (Boolean)success.get() != false, (int)300, (int)15000);
            this.LOG.info(cluster.printServers());
            RaftLog leaderLog = cluster.getLeader().getRaftLog();
            for (RaftPeer newPeer : c1.newPeers) {
                RaftServer.Division d = cluster.getDivision(newPeer.getId());
                RaftTestUtil.waitFor(() -> leaderLog.getEntries(0L, Long.MAX_VALUE).length == d.getRaftLog().getEntries(0L, Long.MAX_VALUE).length, (int)300, (int)15000);
                Assert.assertArrayEquals((Object[])leaderLog.getEntries(0L, Long.MAX_VALUE), (Object[])d.getRaftLog().getEntries(0L, Long.MAX_VALUE));
            }
        }
    }

    @Test
    public void testKillLeaderDuringReconf() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestKillLeaderDuringReconf(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestKillLeaderDuringReconf(CLUSTER cluster) throws Exception {
        AtomicBoolean clientRunning = new AtomicBoolean(true);
        Thread clientThread = null;
        try {
            RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
            MiniRaftCluster.PeerChanges c1 = cluster.addNewPeers(1, false);
            MiniRaftCluster.PeerChanges c2 = cluster.removePeers(1, false, Arrays.asList(c1.newPeers));
            this.LOG.info("Start setConf: {}", Arrays.asList(c2.allPeersInNewConf));
            this.LOG.info(cluster.printServers());
            CompletableFuture setConf = new CompletableFuture();
            clientThread = new Thread(() -> {
                try (RaftClient client = cluster.createClient(leaderId);){
                    int i = 0;
                    while (clientRunning.get() && !setConf.isDone()) {
                        RaftClientReply reply = client.admin().setConfiguration(c2.allPeersInNewConf);
                        if (reply.isSuccess()) {
                            setConf.complete(null);
                        }
                        this.LOG.info("setConf attempt #{} failed, {}", (Object)i, (Object)cluster.printServers());
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Failed to setConf", (Throwable)e);
                    setConf.completeExceptionally(e);
                }
            });
            clientThread.start();
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertFalse((boolean)((RaftConfigurationImpl)cluster.getLeader().getRaftConf()).isTransitional());
            RaftLog leaderLog = cluster.getLeader().getRaftLog();
            for (RaftProtos.LogEntryProto e : RaftTestUtil.getLogEntryProtos((RaftLog)leaderLog)) {
                this.LOG.info("{}", (Object)LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)e));
            }
            long commitIndex = leaderLog.getLastCommittedIndex();
            Assert.assertTrue((String)("commitIndex = " + commitIndex + " > 2"), (commitIndex <= 2L ? 1 : 0) != 0);
            RaftPeerId killed = RaftTestUtil.waitAndKillLeader(cluster);
            Assert.assertEquals((Object)leaderId, (Object)killed);
            RaftPeerId newLeaderId = RaftTestUtil.waitForLeader(cluster).getId();
            this.LOG.info("newLeaderId: {}", (Object)newLeaderId);
            this.LOG.info("start new peers: {}", Arrays.asList(c1.newPeers));
            for (RaftPeer np : c1.newPeers) {
                cluster.restartServer(np.getId(), false);
            }
            try {
                setConf.get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])c2.allPeersInNewConf, (int)2, Collections.singletonList(leaderId));
            setConf.get(1L, TimeUnit.SECONDS);
        }
        finally {
            if (clientThread != null) {
                clientRunning.set(false);
                clientThread.interrupt();
            }
        }
    }

    @Test
    public void testNoChangeRequest() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestNoChangeRequest(arg_0));
    }

    void runTestNoChangeRequest(CLUSTER cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = cluster.createClient(leader.getId());){
            client.io().send((Message)new RaftTestUtil.SimpleMessage("m"));
            RaftLog leaderLog = leader.getRaftLog();
            long committedIndex = leaderLog.getLastCommittedIndex();
            RaftConfiguration confBefore = cluster.getLeader().getRaftConf();
            RaftClientReply reply = client.admin().setConfiguration(cluster.getPeers().toArray(RaftPeer.emptyArray()));
            Assert.assertTrue((boolean)reply.isSuccess());
            long newCommittedIndex = leaderLog.getLastCommittedIndex();
            for (long i = committedIndex + 1L; i <= newCommittedIndex; ++i) {
                RaftProtos.LogEntryProto e = leaderLog.get(i);
                Assert.assertTrue((boolean)e.hasMetadataEntry());
            }
            Assert.assertSame((Object)confBefore, (Object)cluster.getLeader().getRaftConf());
        }
    }

    @Test
    public void testOverlappedSetConfRequests() throws Exception {
        TimeDuration oldTimeoutMin = RaftServerConfigKeys.Rpc.timeoutMin((RaftProperties)this.getProperties());
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)this.getProperties(), (TimeDuration)TimeDuration.valueOf((long)2L, (TimeUnit)TimeUnit.SECONDS));
        TimeDuration oldTimeoutMax = RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)this.getProperties());
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)this.getProperties(), (TimeDuration)TimeDuration.valueOf((long)4L, (TimeUnit)TimeUnit.SECONDS));
        this.runWithNewCluster(3, arg_0 -> this.runTestOverlappedSetConfRequests(arg_0));
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)this.getProperties(), (TimeDuration)oldTimeoutMin);
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)this.getProperties(), (TimeDuration)oldTimeoutMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestOverlappedSetConfRequests(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            RaftPeer[] newPeers = cluster.addNewPeers((int)2, (boolean)true).allPeersInNewConf;
            cluster.getPeers().forEach(peer -> logSyncDelay.setDelayMs(peer.getId().toString(), 1000));
            CountDownLatch latch = new CountDownLatch(1);
            RaftPeer[] peersInRequest2 = cluster.getPeers().toArray(new RaftPeer[0]);
            AtomicBoolean caughtException = new AtomicBoolean(false);
            new Thread(() -> {
                try (RaftClient client2 = cluster.createClient(leaderId);){
                    latch.await();
                    this.LOG.info("client2 starts to change conf");
                    RaftClientRpc sender2 = client2.getClientRpc();
                    sender2.sendRequest((RaftClientRequest)cluster.newSetConfigurationRequest(client2.getId(), leaderId, peersInRequest2));
                }
                catch (ReconfigurationInProgressException e) {
                    caughtException.set(true);
                }
                catch (Exception e) {
                    this.LOG.warn("Got unexpected exception when client2 changes conf", (Throwable)e);
                }
            }).start();
            AtomicBoolean confChanged = new AtomicBoolean(false);
            new Thread(() -> {
                try (RaftClient client1 = cluster.createClient(leaderId);){
                    this.LOG.info("client1 starts to change conf");
                    confChanged.set(client1.admin().setConfiguration(newPeers).isSuccess());
                }
                catch (IOException e) {
                    this.LOG.warn("Got unexpected exception when client1 changes conf", (Throwable)e);
                }
            }).start();
            Thread.sleep(100L);
            latch.countDown();
            for (int i = 0; i < 10 && !confChanged.get(); ++i) {
                Thread.sleep(1000L);
            }
            Assert.assertTrue((boolean)confChanged.get());
            Assert.assertTrue((boolean)caughtException.get());
        }
        finally {
            logSyncDelay.clear();
        }
    }

    @Test
    public void testRevertConfigurationChange() throws Exception {
        this.runWithNewCluster(5, arg_0 -> this.runTestRevertConfigurationChange(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestRevertConfigurationChange(CLUSTER cluster) throws Exception {
        RaftLogBase log2 = null;
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftServer.Division leader = cluster.getLeader();
            RaftPeerId leaderId = leader.getId();
            RaftLog log = leader.getRaftLog();
            log2 = (RaftLogBase)log;
            Thread.sleep(1000L);
            this.LOG.info("start blocking the leader");
            BlockRequestHandlingInjection.getInstance().blockReplier(leaderId.toString());
            cluster.setBlockRequestsFrom(leaderId.toString(), true);
            MiniRaftCluster.PeerChanges change = cluster.removePeers(1, false, new ArrayList());
            AtomicBoolean gotNotLeader = new AtomicBoolean(false);
            Thread clientThread = new Thread(() -> {
                try (RaftClient client = cluster.createClient(leaderId);){
                    this.LOG.info("client starts to change conf");
                    RaftClientRpc sender = client.getClientRpc();
                    RaftClientReply reply = sender.sendRequest((RaftClientRequest)cluster.newSetConfigurationRequest(client.getId(), leaderId, change.allPeersInNewConf));
                    if (reply.getNotLeaderException() != null) {
                        gotNotLeader.set(true);
                    }
                }
                catch (IOException e) {
                    this.LOG.warn("Got unexpected exception when client1 changes conf", (Throwable)e);
                }
            });
            clientThread.start();
            TimeDuration sleepTime = TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            long confIndex = (Long)JavaUtils.attemptRepeatedly(() -> {
                long last;
                for (long i = last = log.getLastEntryTermIndex().getIndex(); i >= 1L; --i) {
                    if (!log.get(i).hasConfigurationEntry()) continue;
                    return i;
                }
                throw new Exception("ConfigurationEntry not found: last=" + last);
            }, (int)10, (TimeDuration)sleepTime, (String)"confIndex", (Logger)this.LOG);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((log.getFlushIndex() >= confIndex ? 1 : 0) != 0);
                return null;
            }, (int)10, (TimeDuration)sleepTime, (String)"FLUSH", (Logger)this.LOG);
            long committed = log.getLastCommittedIndex();
            Assert.assertTrue((committed < confIndex ? 1 : 0) != 0);
            BlockRequestHandlingInjection.getInstance().unblockReplier(leaderId.toString());
            cluster.setBlockRequestsFrom(leaderId.toString(), false);
            clientThread.join(5000L);
            Assert.assertTrue((boolean)gotNotLeader.get());
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((log.getLastCommittedIndex() >= confIndex ? 1 : 0) != 0);
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"COMMIT", (Logger)this.LOG);
            Assert.assertTrue((boolean)log.get(confIndex).hasConfigurationEntry());
            log2 = null;
        }
        catch (Throwable throwable) {
            RaftStorageTestUtils.printLog(log2, s -> this.LOG.info(s));
            throw throwable;
        }
        RaftStorageTestUtils.printLog((RaftLogBase)log2, s -> this.LOG.info(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderNotReadyException() throws Exception {
        this.LOG.info("Start testLeaderNotReadyException");
        MiniRaftCluster cluster = this.newCluster(1).initServers();
        try {
            cluster.getServers().forEach(peer -> leaderPlaceHolderDelay.setDelayMs(peer.getId().toString(), 2000));
            cluster.start();
            AtomicBoolean caughtNotReady = new AtomicBoolean(false);
            AtomicBoolean success = new AtomicBoolean(false);
            RaftPeerId leaderId = ((RaftPeer)cluster.getPeers().iterator().next()).getId();
            new Thread(() -> {
                try (RaftClient client = cluster.createClient(leaderId);){
                    RaftClientRpc sender = client.getClientRpc();
                    RaftClientRequest request = cluster.newRaftClientRequest(client.getId(), leaderId, (Message)new RaftTestUtil.SimpleMessage("test"));
                    while (!success.get()) {
                        try {
                            RaftClientReply reply = sender.sendRequest(request);
                            success.set(reply.isSuccess());
                            if (reply.getException() != null && reply.getException() instanceof LeaderNotReadyException) {
                                caughtNotReady.set(true);
                            }
                        }
                        catch (IOException e) {
                            this.LOG.info("Hit other IOException", (Throwable)e);
                        }
                        if (success.get()) continue;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (Exception ignored) {
                    this.LOG.warn("{} is ignored", (Object)JavaUtils.getClassSimpleName(ignored.getClass()), (Object)ignored);
                }
            }).start();
            RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
            for (int i = 0; !success.get() && i < 5; ++i) {
                Thread.sleep(1000L);
            }
            Assert.assertTrue((boolean)success.get());
            Assert.assertTrue((boolean)caughtNotReady.get());
        }
        finally {
            leaderPlaceHolderDelay.clear();
            cluster.shutdown();
        }
    }

    static {
        Log4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        logSyncDelay = RaftServerTestUtil.getLogSyncDelay();
        leaderPlaceHolderDelay = new DelayLocalExecutionInjection(new String[]{LeaderStateImpl.APPEND_PLACEHOLDER});
    }
}

