/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ServerImplUtils {
    private ServerImplUtils() {
    }

    public static RaftServerProxy newRaftServer(RaftPeerId id, RaftGroup group, StateMachine.Registry stateMachineRegistry, RaftProperties properties, Parameters parameters) throws IOException {
        RaftServer.LOG.debug("newRaftServer: {}, {}", (Object)id, (Object)group);
        RaftServerProxy proxy = ServerImplUtils.newRaftServer((RaftPeerId)id, (StateMachine.Registry)stateMachineRegistry, (RaftProperties)properties, (Parameters)parameters);
        proxy.initGroups(group);
        return proxy;
    }

    private static RaftServerProxy newRaftServer(RaftPeerId id, StateMachine.Registry stateMachineRegistry, RaftProperties properties, Parameters parameters) throws IOException {
        RaftServerProxy proxy;
        TimeDuration sleepTime = TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            proxy = (RaftServerProxy)JavaUtils.attemptRepeatedly(() -> new RaftServerProxy(id, stateMachineRegistry, properties, parameters), (int)5, (TimeDuration)sleepTime, (String)"new RaftServerProxy", (Logger)RaftServer.LOG);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)("Interrupted when creating RaftServer " + id), (InterruptedException)e);
        }
        return proxy;
    }

    public static RaftConfiguration newRaftConfiguration(List<RaftPeer> conf, long index, List<RaftPeer> oldConf) {
        RaftConfigurationImpl.Builder b = RaftConfigurationImpl.newBuilder().setConf(conf).setLogEntryIndex(index);
        Optional.ofNullable(oldConf).filter(p -> p.size() > 0).ifPresent(arg_0 -> ((RaftConfigurationImpl.Builder)b).setOldConf(arg_0));
        return b.build();
    }

    static long effectiveCommitIndex(long leaderCommitIndex, TermIndex followerPrevious, int numAppendEntries) {
        long p = Optional.ofNullable(followerPrevious).map(TermIndex::getIndex).orElse(0L);
        return Math.min(leaderCommitIndex, p + (long)numAppendEntries);
    }
}

