/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.raftlog.RaftLog;
import org.junit.Assert;
import org.junit.Test;

public abstract class ServerPauseResumeTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final int NUM_SERVERS = 3;

    @Test
    public void testPauseResume() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestPauseResume(arg_0));
    }

    void runTestPauseResume(CLUSTER cluster) throws InterruptedException, IOException {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        List followers = cluster.getFollowers();
        Assert.assertTrue((followers.size() >= 1 ? 1 : 0) != 0);
        RaftServerImpl follower = (RaftServerImpl)followers.get(0);
        RaftTestUtil.SimpleMessage[] batch1 = RaftTestUtil.SimpleMessage.create((int)100, (String)"batch1");
        Thread writeThread = RaftTestUtil.sendMessageInNewThread(cluster, (RaftPeerId)leaderId, (RaftTestUtil.SimpleMessage[])batch1);
        writeThread.join();
        Thread.sleep(cluster.getTimeoutMax().toLong(TimeUnit.MILLISECONDS) * 5L);
        RaftLog leaderLog = leader.getRaftLog();
        Assert.assertTrue((boolean)RaftTestUtil.logEntriesContains((RaftLog)leaderLog, (RaftTestUtil.SimpleMessage[])batch1));
        RaftLog followerLog = follower.getRaftLog();
        Assert.assertTrue((boolean)RaftTestUtil.logEntriesContains((RaftLog)followerLog, (RaftTestUtil.SimpleMessage[])batch1));
        boolean isSuccess = follower.pause();
        Assert.assertTrue((boolean)isSuccess);
        Assert.assertTrue((boolean)follower.getInfo().getLifeCycleState().isPausingOrPaused());
        RaftTestUtil.SimpleMessage[] batch2 = RaftTestUtil.SimpleMessage.create((int)100, (String)"batch2");
        Thread writeThread2 = RaftTestUtil.sendMessageInNewThread(cluster, (RaftPeerId)leaderId, (RaftTestUtil.SimpleMessage[])batch2);
        writeThread2.join();
        Thread.sleep(cluster.getTimeoutMax().toLong(TimeUnit.MILLISECONDS) * 5L);
        Assert.assertTrue((boolean)RaftTestUtil.logEntriesNotContains((RaftLog)followerLog, (RaftTestUtil.SimpleMessage[])batch2));
        isSuccess = follower.resume();
        Assert.assertTrue((boolean)isSuccess);
        Assert.assertFalse((boolean)follower.getInfo().getLifeCycleState().isPausingOrPaused());
        Thread.sleep(cluster.getTimeoutMax().toLong(TimeUnit.MILLISECONDS) * 5L);
        Assert.assertTrue((boolean)RaftTestUtil.logEntriesContains((RaftLog)followerLog, (RaftTestUtil.SimpleMessage[])batch2));
    }
}

