/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.ProtoUtils;

/*
 * Exception performing whole class analysis ignored.
 */
final class ServerProtoUtils {
    private ServerProtoUtils() {
    }

    private static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success) {
        return ClientProtoUtils.toRaftRpcReplyProtoBuilder((ByteString)requestorId.toByteString(), (ByteString)replyId.getPeerId().toByteString(), (RaftGroupId)replyId.getGroupId(), null, (boolean)success);
    }

    static RaftProtos.RequestVoteReplyProto toRequestVoteReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success, long term, boolean shouldShutdown) {
        return RaftProtos.RequestVoteReplyProto.newBuilder().setServerReply(ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (boolean)success)).setTerm(term).setShouldShutdown(shouldShutdown).build();
    }

    static RaftProtos.RequestVoteRequestProto toRequestVoteRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, long term, TermIndex lastEntry, boolean preVote) {
        RaftProtos.RequestVoteRequestProto.Builder b = RaftProtos.RequestVoteRequestProto.newBuilder().setServerRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftGroupMemberId)requestorId, (RaftPeerId)replyId)).setCandidateTerm(term).setPreVote(preVote);
        Optional.ofNullable(lastEntry).map(TermIndex::toProto).ifPresent(arg_0 -> ((RaftProtos.RequestVoteRequestProto.Builder)b).setCandidateLastEntry(arg_0));
        return b.build();
    }

    static RaftProtos.StartLeaderElectionReplyProto toStartLeaderElectionReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success) {
        return RaftProtos.StartLeaderElectionReplyProto.newBuilder().setServerReply(ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (boolean)success)).build();
    }

    static RaftProtos.StartLeaderElectionRequestProto toStartLeaderElectionRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, TermIndex lastEntry) {
        RaftProtos.StartLeaderElectionRequestProto.Builder b = RaftProtos.StartLeaderElectionRequestProto.newBuilder().setServerRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftGroupMemberId)requestorId, (RaftPeerId)replyId));
        if (lastEntry != null) {
            b.setLeaderLastEntry(lastEntry.toProto());
        }
        return b.build();
    }

    static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long currentTerm, int requestIndex, RaftProtos.InstallSnapshotResult result) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.InstallSnapshotResult.SUCCESS ? 1 : 0) != 0);
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setTerm(currentTerm).setResult(result).setRequestIndex(requestIndex);
        return builder.build();
    }

    static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long currentTerm, RaftProtos.InstallSnapshotResult result, long installedSnapshotIndex) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.InstallSnapshotResult.SUCCESS ? 1 : 0) != 0);
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setTerm(currentTerm).setResult(result);
        if (installedSnapshotIndex > 0L) {
            builder.setSnapshotIndex(installedSnapshotIndex);
        }
        return builder.build();
    }

    static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, RaftProtos.InstallSnapshotResult result) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.InstallSnapshotResult.SUCCESS ? 1 : 0) != 0);
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setResult(result);
        return builder.build();
    }

    static RaftProtos.AppendEntriesReplyProto toAppendEntriesReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long term, long followerCommit, long nextIndex, RaftProtos.AppendEntriesReplyProto.AppendResult result, long callId, long matchIndex, boolean isHeartbeat) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = ServerProtoUtils.toRaftRpcReplyProtoBuilder((RaftPeerId)requestorId, (RaftGroupMemberId)replyId, (result == RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS ? 1 : 0) != 0).setCallId(callId);
        return RaftProtos.AppendEntriesReplyProto.newBuilder().setServerReply(rpcReply).setTerm(term).setNextIndex(nextIndex).setMatchIndex(matchIndex).setFollowerCommit(followerCommit).setResult(result).setIsHearbeat(isHeartbeat).build();
    }

    static RaftProtos.AppendEntriesRequestProto toAppendEntriesRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, long leaderTerm, List<RaftProtos.LogEntryProto> entries, long leaderCommit, boolean initializing, TermIndex previous, Collection<RaftProtos.CommitInfoProto> commitInfos, long callId) {
        RaftProtos.RaftRpcRequestProto.Builder rpcRequest = ClientProtoUtils.toRaftRpcRequestProtoBuilder((RaftGroupMemberId)requestorId, (RaftPeerId)replyId).setCallId(callId);
        RaftProtos.AppendEntriesRequestProto.Builder b = RaftProtos.AppendEntriesRequestProto.newBuilder().setServerRequest(rpcRequest).setLeaderTerm(leaderTerm).setLeaderCommit(leaderCommit).setInitializing(initializing);
        if (entries != null && !entries.isEmpty()) {
            b.addAllEntries(entries);
        }
        Optional.ofNullable(previous).map(TermIndex::toProto).ifPresent(arg_0 -> ((RaftProtos.AppendEntriesRequestProto.Builder)b).setPreviousLog(arg_0));
        ProtoUtils.addCommitInfos(commitInfos, arg_0 -> ((RaftProtos.AppendEntriesRequestProto.Builder)b).addCommitInfos(arg_0));
        return b.build();
    }

    static RaftProtos.ServerRpcProto toServerRpcProto(RaftPeer peer, long delay) {
        if (peer == null) {
            return RaftProtos.ServerRpcProto.getDefaultInstance();
        }
        return RaftProtos.ServerRpcProto.newBuilder().setId(peer.getRaftPeerProto()).setLastRpcElapsedTimeMs(delay).build();
    }
}

