/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.SizeInBytes;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class LogAppenderTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public LogAppenderTests() {
        Log4jUtils.setLogLevel((Logger)LogAppender.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        SizeInBytes n = SizeInBytes.valueOf((String)"8KB");
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)n);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)prop, (SizeInBytes)n);
    }

    static RaftTestUtil.SimpleMessage[] generateMsgs(int num) {
        RaftTestUtil.SimpleMessage[] msgs = new RaftTestUtil.SimpleMessage[num * 6];
        for (int i = 0; i < num; ++i) {
            for (int j = 0; j < 6; ++j) {
                byte[] bytes = new byte[1024 * (j + 1)];
                Arrays.fill(bytes, (byte)(j + 48));
                msgs[i * 6 + j] = new RaftTestUtil.SimpleMessage(new String(bytes));
            }
        }
        return msgs;
    }

    @Test
    public void testSingleElementBuffer() throws Exception {
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)this.getProperties(), (int)1);
        this.runWithNewCluster(3, this::runTest);
    }

    @Test
    public void testUnlimitedElementBuffer() throws Exception {
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)this.getProperties(), (int)0);
        this.runWithNewCluster(3, this::runTest);
    }

    @Test
    public void testFollowerHeartbeatMetric() throws IOException, InterruptedException {
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftServer.Division leaderServer = RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = cluster.createClient(leaderServer.getId());){
            for (int i = 1; i <= 10; ++i) {
                client.io().send((Message)new RaftTestUtil.SimpleMessage("Msg to make leader ready " + i));
            }
        }
        RatisMetricRegistry ratisMetricRegistry = ((RaftServerMetricsImpl)leaderServer.getRaftServerMetrics()).getRegistry();
        SortedMap heartbeatElapsedTimeGauges = ratisMetricRegistry.getGauges((s, metric) -> s.contains("lastHeartbeatElapsedTime"));
        Assert.assertTrue((heartbeatElapsedTimeGauges.size() == 2 ? 1 : 0) != 0);
        for (RaftServer.Division followerServer : cluster.getFollowers()) {
            String followerId = followerServer.getId().toString();
            Gauge metric2 = (Gauge)((Map.Entry)heartbeatElapsedTimeGauges.entrySet().parallelStream().filter(e -> ((String)e.getKey()).contains(followerId)).iterator().next()).getValue();
            Assert.assertTrue((metric2 != null ? 1 : 0) != 0);
            Assert.assertTrue(((Long)metric2.getValue() > 0L ? 1 : 0) != 0);
            RaftServerMetricsImpl followerMetrics = (RaftServerMetricsImpl)followerServer.getRaftServerMetrics();
            Assert.assertTrue((boolean)followerMetrics.getRegistry().getGauges((s, m) -> s.contains("lastHeartbeatElapsedTime")).isEmpty());
            for (boolean heartbeat : new boolean[]{true, false}) {
                Assert.assertTrue((followerMetrics.getFollowerAppendEntryTimer(heartbeat).getMeanRate() > 0.0 ? 1 : 0) != 0);
                Assert.assertTrue((followerMetrics.getFollowerAppendEntryTimer(heartbeat).getCount() > 0L ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTest(CLUSTER cluster) throws Exception {
        int numMsgs = 10;
        int numClients = 5;
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        ArrayList<RaftClient> clients = new ArrayList<RaftClient>();
        try {
            ArrayList<Sender> senders = new ArrayList<Sender>();
            CountDownLatch latch = new CountDownLatch(1);
            for (int i = 0; i < 5; ++i) {
                RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);
                clients.add(client);
                senders.add(new Sender(client, 10, latch));
            }
            senders.forEach(Thread::start);
            latch.countDown();
            for (Sender s : senders) {
                s.join();
                Exception e = (Exception)s.exception.get();
                if (e != null) {
                    throw e;
                }
                Assert.assertTrue((boolean)s.succeed.get());
            }
        }
        finally {
            for (int i = 0; i < clients.size(); ++i) {
                try {
                    ((RaftClient)clients.get(i)).close();
                    continue;
                }
                catch (Exception ignored) {
                    this.LOG.warn("{} is ignored", (Object)JavaUtils.getClassSimpleName(ignored.getClass()), (Object)ignored);
                }
            }
        }
        RaftServer.Division leader = ((MiniRaftCluster)cluster).getLeader();
        RaftLog leaderLog = ((MiniRaftCluster)cluster).getLeader().getRaftLog();
        EnumMap<RaftProtos.LogEntryProto.LogEntryBodyCase, AtomicLong> counts = RaftTestUtil.countEntries(leaderLog);
        this.LOG.info("counts = " + counts);
        Assert.assertEquals((long)300L, (long)counts.get(RaftProtos.LogEntryProto.LogEntryBodyCase.STATEMACHINELOGENTRY).get());
        RaftProtos.LogEntryProto last = RaftTestUtil.getLastEntry(RaftProtos.LogEntryProto.LogEntryBodyCase.STATEMACHINELOGENTRY, leaderLog);
        this.LOG.info("last = {}", (Object)LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)last));
        Assert.assertNotNull((Object)last);
        Assert.assertTrue((last.getIndex() <= leader.getInfo().getLastAppliedIndex() ? 1 : 0) != 0);
    }

    private static class Sender
    extends Thread {
        private final RaftClient client;
        private final CountDownLatch latch;
        private final RaftTestUtil.SimpleMessage[] messages;
        private final AtomicBoolean succeed = new AtomicBoolean(false);
        private final AtomicReference<Exception> exception = new AtomicReference();

        Sender(RaftClient client, int numMessages, CountDownLatch latch) {
            this.latch = latch;
            this.client = client;
            this.messages = LogAppenderTests.generateMsgs(numMessages);
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                for (RaftTestUtil.SimpleMessage msg : this.messages) {
                    this.client.io().send((Message)msg);
                }
                this.client.close();
                this.succeed.set(true);
            }
            catch (Exception e) {
                this.exception.compareAndSet(null, e);
            }
        }
    }
}

