/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.BlockRequestHandlingInjection;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogTestUtils;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public abstract class LeaderElectionTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public LeaderElectionTests() {
        Log4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    @Test
    public void testBasicLeaderElection() throws Exception {
        this.LOG.info("Running testBasicLeaderElection");
        MiniRaftCluster cluster = this.newCluster(5);
        cluster.start();
        RaftTestUtil.waitAndKillLeader(cluster);
        RaftTestUtil.waitAndKillLeader(cluster);
        RaftTestUtil.waitAndKillLeader(cluster);
        this.testFailureCase("waitForLeader after killed a majority of servers", () -> RaftTestUtil.waitForLeader(cluster, null, false), IllegalStateException.class, new Class[0]);
        cluster.shutdown();
    }

    @Test
    public void testChangeLeader() throws Exception {
        SegmentedRaftLogTestUtils.setRaftLogWorkerLogLevel(Level.TRACE);
        this.LOG.info("Running testChangeLeader");
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftPeerId leader = RaftTestUtil.waitForLeader(cluster).getId();
        for (int i = 0; i < 10; ++i) {
            leader = RaftTestUtil.changeLeader(cluster, leader, IllegalStateException::new);
            ExitUtils.assertNotTerminated();
        }
        SegmentedRaftLogTestUtils.setRaftLogWorkerLogLevel(Level.INFO);
        cluster.shutdown();
    }

    @Test
    public void testLostMajorityHeartbeats() throws Exception {
        this.runWithNewCluster(3, this::runTestLostMajorityHeartbeats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestLostMajorityHeartbeats(CLUSTER cluster) throws Exception {
        TimeDuration maxTimeout = RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)this.getProperties());
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        try {
            this.isolate((MiniRaftCluster)cluster, leader.getId());
            maxTimeout.sleep();
            maxTimeout.sleep();
            RaftServerTestUtil.assertLostMajorityHeartbeatsRecently(leader);
        }
        finally {
            this.deIsolate((MiniRaftCluster)cluster, leader.getId());
        }
    }

    @Test
    public void testTransferLeader() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List<RaftServer.Division> followers = cluster.getFollowers();
                Assert.assertEquals((long)followers.size(), (long)2L);
                RaftServer.Division newLeader = followers.get(0);
                List<RaftPeer> peers = cluster.getPeers();
                List peersWithNewPriority = this.getPeersWithPriority(peers, newLeader.getPeer());
                RaftClientReply reply = client.admin().setConfiguration(peersWithNewPriority.toArray(new RaftPeer[0]));
                Assert.assertTrue((boolean)reply.isSuccess());
                reply = client.admin().transferLeadership(newLeader.getId(), 20000L);
                Assert.assertTrue((boolean)reply.isSuccess());
                RaftServer.Division currLeader = RaftTestUtil.waitForLeader(cluster);
                Assert.assertTrue((newLeader.getId() == currLeader.getId() ? 1 : 0) != 0);
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assert.assertTrue((boolean)reply.getReplierId().equals(newLeader.getId().toString()));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testTransferLeaderTimeout() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                List<RaftServer.Division> followers = cluster.getFollowers();
                Assert.assertEquals((long)followers.size(), (long)2L);
                RaftServer.Division newLeader = followers.get(0);
                this.isolate(cluster, newLeader.getId());
                List<RaftPeer> peers = cluster.getPeers();
                List peersWithNewPriority = this.getPeersWithPriority(peers, newLeader.getPeer());
                RaftClientReply reply = client.admin().setConfiguration(peersWithNewPriority.toArray(new RaftPeer[0]));
                Assert.assertTrue((boolean)reply.isSuccess());
                CompletableFuture<Boolean> transferTimeoutFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        long timeoutMs = 5000L;
                        long start = System.currentTimeMillis();
                        try {
                            client.admin().transferLeadership(newLeader.getId(), timeoutMs);
                        }
                        catch (TransferLeadershipException e) {
                            long cost = System.currentTimeMillis() - start;
                            Assert.assertTrue((cost > timeoutMs ? 1 : 0) != 0);
                            Assert.assertTrue((boolean)e.getMessage().contains("Failed to transfer leadership to"));
                            Assert.assertTrue((boolean)e.getMessage().contains("timed out"));
                        }
                        return true;
                    }
                    catch (IOException e) {
                        return false;
                    }
                });
                JavaUtils.attemptRepeatedly(() -> {
                    try {
                        client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                    }
                    catch (LeaderSteppingDownException e) {
                        Assert.assertTrue((boolean)e.getMessage().contains("is stepping down"));
                    }
                    return null;
                }, (int)5, (TimeDuration)TimeDuration.ONE_SECOND, (String)"check leader steppingDown", (Logger)RaftServer.LOG);
                Assert.assertTrue((boolean)transferTimeoutFuture.get());
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assert.assertTrue((boolean)reply.getReplierId().equals(leader.getId().toString()));
                Assert.assertTrue((boolean)reply.isSuccess());
                this.deIsolate(cluster, newLeader.getId());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testEnforceLeader() throws Exception {
        this.LOG.info("Running testEnforceLeader");
        int numServer = 5;
        try (MiniRaftCluster cluster = this.newCluster(5);){
            cluster.start();
            RaftPeerId firstLeader = RaftTestUtil.waitForLeader(cluster).getId();
            this.LOG.info("firstLeader = {}", (Object)firstLeader);
            int first = MiniRaftCluster.getIdIndex(firstLeader.toString());
            int random = ThreadLocalRandom.current().nextInt(4);
            String newLeader = "s" + (random < first ? random : random + 1);
            this.LOG.info("enforce leader to {}", (Object)newLeader);
            LeaderElectionTests.enforceLeader(cluster, newLeader, this.LOG);
        }
    }

    static void enforceLeader(MiniRaftCluster cluster, String newLeader, Logger LOG) throws InterruptedException {
        LOG.info(cluster.printServers());
        for (int i = 0; !cluster.tryEnforceLeader(newLeader) && i < 10; ++i) {
            RaftServer.Division currLeader = cluster.getLeader();
            LOG.info("try enforcing leader to " + newLeader + " but " + (currLeader == null ? "no leader for round " + i : "new leader is " + currLeader.getId()));
        }
        LOG.info(cluster.printServers());
        RaftServer.Division leader = cluster.getLeader();
        Assert.assertEquals((Object)newLeader, (Object)leader.getId().toString());
    }

    @Test
    public void testLateServerStart() throws Exception {
        int numServer = 3;
        this.LOG.info("Running testLateServerStart");
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.initServers();
        Iterator<RaftServer> i = cluster.getServers().iterator();
        for (int j = 1; j < 3; ++j) {
            i.next().start();
        }
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        TimeDuration sleepTime = TimeDuration.valueOf((long)3L, (TimeUnit)TimeUnit.SECONDS);
        this.LOG.info("sleep " + sleepTime);
        sleepTime.sleep();
        RaftServerProxy lastServer = (RaftServerProxy)i.next();
        lastServer.start();
        RaftPeerId lastServerLeaderId = (RaftPeerId)JavaUtils.attemptRepeatedly(() -> Optional.ofNullable(((RaftServerImpl)lastServer.getImpls().iterator().next()).getState().getLeaderId()).orElseThrow(() -> new IllegalStateException("No leader yet")), (int)10, (TimeDuration)ONE_SECOND, (String)"getLeaderId", (Logger)this.LOG);
        this.LOG.info(cluster.printServers());
        Assert.assertEquals((Object)leader.getId(), (Object)lastServerLeaderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testDisconnectLeader() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Thread.sleep(1000L);
                this.isolate(cluster, leader.getId());
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assert.assertNotEquals((Object)reply.getReplierId(), (Object)leader.getId().toString());
                Assert.assertTrue((boolean)reply.isSuccess());
            }
            finally {
                this.deIsolate(cluster, leader.getId());
            }
            cluster.shutdown();
        }
    }

    private void isolate(MiniRaftCluster cluster, RaftPeerId id) {
        try {
            BlockRequestHandlingInjection.getInstance().blockReplier(id.toString());
            cluster.setBlockRequestsFrom(id.toString(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deIsolate(MiniRaftCluster cluster, RaftPeerId id) {
        BlockRequestHandlingInjection.getInstance().unblockReplier(id.toString());
        cluster.setBlockRequestsFrom(id.toString(), false);
    }

    @Test
    public void testLeaderElectionMetrics() throws IOException, InterruptedException {
        Timestamp timestamp = Timestamp.currentTime();
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftServer.Division leaderServer = RaftTestUtil.waitForLeader(cluster);
        RatisMetricRegistry ratisMetricRegistry = LeaderElectionMetrics.getMetricRegistryForLeaderElection((RaftGroupMemberId)leaderServer.getMemberId());
        long numLeaderElections = ratisMetricRegistry.counter("electionCount").getCount();
        Assert.assertTrue((numLeaderElections > 0L ? 1 : 0) != 0);
        long numLeaderElectionTimeout = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assert.assertTrue((numLeaderElectionTimeout > 0L ? 1 : 0) != 0);
        Timer timer = ratisMetricRegistry.timer("electionTime");
        double meanTimeNs = timer.getSnapshot().getMean();
        long elapsedNs = timestamp.elapsedTime().toLong(TimeUnit.NANOSECONDS);
        Assert.assertTrue((timer.getCount() > 0L && meanTimeNs < (double)elapsedNs ? 1 : 0) != 0);
        Long leaderElectionLatency = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("lastLeaderElectionElapsedTime")).values().iterator().next()).getValue();
        Assert.assertTrue((leaderElectionLatency > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testImmediatelyRevertedToFollower() {
        RaftServerImpl server = LeaderElectionTests.createMockServer(true);
        LeaderElection subject = new LeaderElection(server, false);
        try {
            subject.startInForeground();
            Assert.assertEquals((Object)LifeCycle.State.CLOSED, (Object)subject.getCurrentState());
        }
        catch (Exception e) {
            this.LOG.info("Error starting LeaderElection", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShutdownBeforeStart() {
        RaftServerImpl server = LeaderElectionTests.createMockServer(false);
        LeaderElection subject = new LeaderElection(server, false);
        try {
            subject.shutdown();
            subject.startInForeground();
            Assert.assertEquals((Object)LifeCycle.State.CLOSED, (Object)subject.getCurrentState());
        }
        catch (Exception e) {
            this.LOG.info("Error starting LeaderElection", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPreVote() {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List<RaftServer.Division> followers = cluster.getFollowers();
                Assert.assertEquals((long)followers.size(), (long)2L);
                RaftServer.Division follower = followers.get(0);
                this.isolate(cluster, follower.getId());
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assert.assertTrue((boolean)reply.isSuccess());
                long savedTerm = leader.getInfo().getCurrentTerm();
                this.LOG.info("Wait follower {} timeout and trigger pre-vote", (Object)follower.getId());
                Thread.sleep(2000L);
                this.deIsolate(cluster, follower.getId());
                Thread.sleep(2000L);
                RaftServer.Division newleader = RaftTestUtil.waitForLeader(cluster);
                Assert.assertNotNull((Object)newleader);
                Assert.assertEquals((Object)newleader.getId(), (Object)leader.getId());
                Assert.assertEquals((long)savedTerm, (long)leader.getInfo().getCurrentTerm());
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
            cluster.shutdown();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static RaftServerImpl createMockServer(boolean alive) {
        DivisionInfo info = (DivisionInfo)Mockito.mock(DivisionInfo.class);
        Mockito.when((Object)info.isAlive()).thenReturn((Object)alive);
        Mockito.when((Object)info.isCandidate()).thenReturn((Object)false);
        RaftServerImpl server = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        Mockito.when((Object)server.getInfo()).thenReturn((Object)info);
        RaftGroupMemberId memberId = RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"any"), (RaftGroupId)RaftGroupId.randomId());
        Mockito.when((Object)server.getMemberId()).thenReturn((Object)memberId);
        LeaderElectionMetrics leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftGroupMemberId)memberId, () -> 0L);
        Mockito.when((Object)server.getLeaderElectionMetrics()).thenReturn((Object)leaderElectionMetrics);
        RaftServerProxy proxy = (RaftServerProxy)Mockito.mock(RaftServerProxy.class);
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)true);
        Mockito.when((Object)proxy.getProperties()).thenReturn((Object)properties);
        Mockito.when((Object)server.getRaftServer()).thenReturn((Object)proxy);
        return server;
    }
}

