/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Log4jUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class PreAppendLeaderStepDownTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    private static volatile boolean leaderShouldStepDown = false;

    public PreAppendLeaderStepDownTest() {
        Log4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithException.class, StateMachine.class);
    }

    @Test
    public void testLeaderStepDown() throws Exception {
        leaderShouldStepDown = true;
        this.runWithNewCluster(3, this::runTestLeaderStepDown);
    }

    @Test
    public void testNoLeaderStepDown() throws Exception {
        leaderShouldStepDown = false;
        this.runWithNewCluster(3, this::runTestLeaderStepDown);
    }

    private void runTestLeaderStepDown(CLUSTER cluster) throws Exception {
        RaftServer.Division oldLeader = RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(oldLeader.getId());){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftTestUtil.SimpleMessage message = new RaftTestUtil.SimpleMessage("message");
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), oldLeader.getId(), 999L, message);
            long oldTerm = RaftTestUtil.waitForLeader(cluster).getRaftLog().getLastEntryTermIndex().getTerm();
            rpc.sendRequest(r);
            long newTerm = RaftTestUtil.waitForLeader(cluster).getRaftLog().getLastEntryTermIndex().getTerm();
            if (leaderShouldStepDown) {
                Assert.assertTrue((newTerm > oldTerm ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)newTerm, (long)oldTerm);
            }
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    protected static class StateMachineWithException
    extends SimpleStateMachine4Testing {
        protected StateMachineWithException() {
        }

        public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
            throw new StateMachineException("Fake Exception in preAppend", leaderShouldStepDown);
        }
    }
}

