/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.StreamSupport;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.simulation.RaftServerReply;
import org.apache.ratis.server.simulation.RaftServerRequest;
import org.apache.ratis.server.simulation.SimulatedClientRpc;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.server.simulation.SimulatedRpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniRaftClusterWithSimulatedRpc
extends MiniRaftCluster {
    static final Logger LOG = LoggerFactory.getLogger(MiniRaftClusterWithSimulatedRpc.class);
    public static final MiniRaftCluster.Factory<MiniRaftClusterWithSimulatedRpc> FACTORY = new MiniRaftCluster.Factory<MiniRaftClusterWithSimulatedRpc>(){

        @Override
        public MiniRaftClusterWithSimulatedRpc newCluster(String[] ids, RaftProperties prop) {
            RaftConfigKeys.Rpc.setType((RaftProperties)prop, (RpcType)SimulatedRpc.INSTANCE);
            if (ThreadLocalRandom.current().nextBoolean()) {
                prop.setInt(SimulatedRequestReply.SIMULATE_LATENCY_KEY, 0);
            }
            int simulateLatencyMs = ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)prop).getInt(arg_0, arg_1), (String)SimulatedRequestReply.SIMULATE_LATENCY_KEY, (int)SimulatedRequestReply.SIMULATE_LATENCY_DEFAULT, arg_0 -> ((Logger)LOG).info(arg_0), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
            SimulatedRequestReply serverRequestReply = new SimulatedRequestReply(simulateLatencyMs);
            SimulatedClientRpc client2serverRequestReply = new SimulatedClientRpc(simulateLatencyMs);
            return new MiniRaftClusterWithSimulatedRpc(ids, prop, serverRequestReply, client2serverRequestReply);
        }
    };
    private final SimulatedRequestReply<RaftServerRequest, RaftServerReply> serverRequestReply;
    private final SimulatedClientRpc client2serverRequestReply;

    private MiniRaftClusterWithSimulatedRpc(String[] ids, RaftProperties properties, SimulatedRequestReply<RaftServerRequest, RaftServerReply> serverRequestReply, SimulatedClientRpc client2serverRequestReply) {
        super(ids, properties, SimulatedRpc.Factory.newRaftParameters(serverRequestReply, client2serverRequestReply));
        this.serverRequestReply = serverRequestReply;
        this.client2serverRequestReply = client2serverRequestReply;
    }

    @Override
    public void restart(boolean format) throws IOException {
        this.serverRequestReply.clear();
        this.client2serverRequestReply.clear();
        super.restart(format);
    }

    @Override
    protected Parameters setPropertiesAndInitParameters(RaftPeerId id, RaftGroup group, RaftProperties properties) {
        this.serverRequestReply.addPeer(id);
        this.client2serverRequestReply.addPeer(id);
        return this.parameters;
    }

    @Override
    public void blockQueueAndSetDelay(String leaderId, int delayMs) throws InterruptedException {
        boolean block = delayMs > 0;
        LOG.debug("{} leader queue {} and set {}ms delay for the other queues", new Object[]{block ? "Block" : "Unblock", leaderId, delayMs});
        this.serverRequestReply.getQueue((String)leaderId).blockSendRequestTo.set(block);
        StreamSupport.stream(this.getServers().spliterator(), false).filter(s -> !s.getId().toString().equals(leaderId)).map(s -> this.serverRequestReply.getQueue(s.getId().toString())).forEach(q -> q.delayTakeRequestTo.set(delayMs));
        long sleepMs = 3L * this.getTimeoutMax().toLong(TimeUnit.MILLISECONDS) / 2L;
        Thread.sleep(sleepMs);
    }

    @Override
    public void setBlockRequestsFrom(String src, boolean block) {
        this.serverRequestReply.getQueue((String)src).blockTakeRequestFrom.set(block);
    }

    public static interface FactoryGet
    extends MiniRaftCluster.Factory.Get<MiniRaftClusterWithSimulatedRpc> {
        @Override
        default public MiniRaftCluster.Factory<MiniRaftClusterWithSimulatedRpc> getFactory() {
            return FACTORY;
        }
    }
}

