/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogInputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogOutputStream;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.MD5FileUtil;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStateMachine4Testing
extends BaseStateMachine {
    private static final int SNAPSHOT_THRESHOLD = 100;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStateMachine4Testing.class);
    private static final String RAFT_TEST_SIMPLE_STATE_MACHINE_TAKE_SNAPSHOT_KEY = "raft.test.simple.state.machine.take.snapshot";
    private static final boolean RAFT_TEST_SIMPLE_STATE_MACHINE_TAKE_SNAPSHOT_DEFAULT = false;
    private boolean notifiedAsLeader;
    private final SortedMap<Long, RaftProtos.LogEntryProto> indexMap = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedMap<String, RaftProtos.LogEntryProto> dataMap = Collections.synchronizedSortedMap(new TreeMap());
    private final Daemon checkpointer;
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final RaftProperties properties = new RaftProperties();
    private final long segmentMaxSize = RaftServerConfigKeys.Log.segmentSizeMax((RaftProperties)this.properties).getSize();
    private final long preallocatedSize = RaftServerConfigKeys.Log.preallocatedSize((RaftProperties)this.properties).getSize();
    private final int bufferSize = RaftServerConfigKeys.Log.writeBufferSize((RaftProperties)this.properties).getSizeInt();
    private volatile boolean running = true;
    private final Blocking blocking = new Blocking();
    private final Collecting collecting = new Collecting();
    private long endIndexLastCkpt = -1L;
    private volatile RaftProtos.RoleInfoProto slownessInfo = null;
    private volatile RaftProtos.RoleInfoProto leaderElectionTimeoutInfo = null;
    private RaftGroupId groupId;
    static final ByteString STATE_MACHINE_DATA = ByteString.copyFromUtf8((String)"StateMachine Data");

    public static SimpleStateMachine4Testing get(RaftServer.Division s) {
        return (SimpleStateMachine4Testing)s.getStateMachine();
    }

    public SimpleStateMachine4Testing() {
        this.checkpointer = new Daemon(() -> {
            while (this.running) {
                if (this.indexMap.lastKey() - this.endIndexLastCkpt >= 100L) {
                    this.endIndexLastCkpt = this.takeSnapshot();
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    public Collecting collecting() {
        return this.collecting;
    }

    public RaftProtos.RoleInfoProto getSlownessInfo() {
        return this.slownessInfo;
    }

    public RaftProtos.RoleInfoProto getLeaderElectionTimeoutInfo() {
        return this.leaderElectionTimeoutInfo;
    }

    private void put(RaftProtos.LogEntryProto entry) {
        RaftProtos.LogEntryProto previous = this.indexMap.put(entry.getIndex(), entry);
        Preconditions.assertNull((Object)previous, (String)"previous");
        String s = entry.getStateMachineLogEntry().getLogData().toStringUtf8();
        this.dataMap.put(s, entry);
        LOG.info("{}: put {}, {} -> {}", new Object[]{this.getId(), entry.getIndex(), s.length() <= 10 ? s : s.substring(0, 10) + "...", LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry)});
    }

    public synchronized void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
        LOG.info("Initializing " + (Object)((Object)this));
        this.groupId = groupId;
        this.getLifeCycle().startAndTransition(() -> {
            super.initialize(server, groupId, raftStorage);
            this.storage.init(raftStorage);
            this.loadSnapshot(this.storage.findLatestSnapshot());
            if (this.properties.getBoolean(RAFT_TEST_SIMPLE_STATE_MACHINE_TAKE_SNAPSHOT_KEY, false)) {
                this.checkpointer.start();
            }
        }, new Class[0]);
    }

    public synchronized void pause() {
        this.getLifeCycle().transition(LifeCycle.State.PAUSING);
        this.getLifeCycle().transition(LifeCycle.State.PAUSED);
    }

    public synchronized void reinitialize() throws IOException {
        LOG.info("Reinitializing " + (Object)((Object)this));
        this.loadSnapshot(this.storage.findLatestSnapshot());
        if (this.getLifeCycleState() == LifeCycle.State.PAUSED) {
            this.getLifeCycle().transition(LifeCycle.State.STARTING);
            this.getLifeCycle().transition(LifeCycle.State.RUNNING);
        }
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        RaftProtos.LogEntryProto entry = Objects.requireNonNull(trx.getLogEntry());
        this.put(entry);
        this.updateLastAppliedTermIndex(entry.getTerm(), entry.getIndex());
        RaftTestUtil.SimpleMessage m = new RaftTestUtil.SimpleMessage(entry.getIndex() + " OK");
        return this.collecting.collect(Collecting.Type.APPLY_TRANSACTION, m);
    }

    public long takeSnapshot() {
        TermIndex termIndex = this.getLastAppliedTermIndex();
        if (termIndex.getTerm() <= 0L || termIndex.getIndex() <= 0L) {
            return -1L;
        }
        long endIndex = termIndex.getIndex();
        File snapshotFile = this.storage.getSnapshotFile(termIndex.getTerm(), termIndex.getIndex());
        LOG.debug("Taking a snapshot with t:{}, i:{}, file:{}", new Object[]{termIndex.getTerm(), termIndex.getIndex(), snapshotFile});
        try (SegmentedRaftLogOutputStream out = new SegmentedRaftLogOutputStream(snapshotFile, false, this.segmentMaxSize, this.preallocatedSize, ByteBuffer.allocateDirect(this.bufferSize));){
            for (RaftProtos.LogEntryProto entry : this.indexMap.values()) {
                if (entry.getIndex() > endIndex) break;
                out.write(entry);
            }
            out.flush();
        }
        catch (IOException e) {
            LOG.warn("Failed to take snapshot", (Throwable)e);
        }
        try {
            MD5Hash digest = MD5FileUtil.computeMd5ForFile((File)snapshotFile);
            MD5FileUtil.saveMD5File((File)snapshotFile, (MD5Hash)digest);
        }
        catch (IOException e) {
            LOG.warn("Hit IOException when computing MD5 for snapshot file " + snapshotFile, (Throwable)e);
        }
        try {
            this.storage.loadLatestSnapshot();
        }
        catch (IOException e) {
            LOG.warn("Hit IOException when loading latest snapshot for snapshot file " + snapshotFile, (Throwable)e);
        }
        return endIndex;
    }

    public SimpleStateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    private synchronized long loadSnapshot(SingleFileSnapshotInfo snapshot) throws IOException {
        if (snapshot == null || !snapshot.getFile().getPath().toFile().exists()) {
            LOG.info("The snapshot file {} does not exist", (Object)(snapshot == null ? null : snapshot.getFile()));
            return -1L;
        }
        LOG.info("Loading snapshot {}", (Object)snapshot);
        long endIndex = snapshot.getIndex();
        try (SegmentedRaftLogInputStream in = new SegmentedRaftLogInputStream(snapshot.getFile().getPath().toFile(), 0L, endIndex, false);){
            RaftProtos.LogEntryProto entry;
            while ((entry = in.nextEntry()) != null) {
                this.put(entry);
                this.updateLastAppliedTermIndex(entry.getTerm(), entry.getIndex());
            }
        }
        Preconditions.assertTrue((!this.indexMap.isEmpty() && endIndex >= this.indexMap.lastKey() ? 1 : 0) != 0, (String)"endIndex=%s, indexMap=%s", (Object[])new Object[]{endIndex, this.indexMap});
        this.endIndexLastCkpt = endIndex;
        this.setLastAppliedTermIndex(snapshot.getTermIndex());
        this.storage.loadLatestSnapshot();
        return endIndex;
    }

    public CompletableFuture<Message> query(Message request) {
        Exception exception;
        String string = request.getContent().toStringUtf8();
        try {
            LOG.info("query " + string);
            RaftProtos.LogEntryProto entry = (RaftProtos.LogEntryProto)this.dataMap.get(string);
            if (entry != null) {
                return CompletableFuture.completedFuture(Message.valueOf((ByteString)entry.toByteString()));
            }
            exception = new IndexOutOfBoundsException(this.getId() + ": LogEntry not found for query " + string);
        }
        catch (Exception e) {
            LOG.warn("Failed request " + request, (Throwable)e);
            exception = e;
        }
        return JavaUtils.completeExceptionally((Throwable)new StateMachineException("Failed request " + request, (Throwable)exception));
    }

    public TransactionContext startTransaction(RaftClientRequest request) {
        this.blocking.await(Blocking.Type.START_TRANSACTION);
        return TransactionContext.newBuilder().setStateMachine((StateMachine)this).setClientRequest(request).setStateMachineData(STATE_MACHINE_DATA).build();
    }

    public CompletableFuture<Void> write(RaftProtos.LogEntryProto entry) {
        return this.blocking.getFuture(Blocking.Type.WRITE_STATE_MACHINE_DATA);
    }

    public CompletableFuture<ByteString> read(RaftProtos.LogEntryProto entry) {
        return this.blocking.getFuture(Blocking.Type.READ_STATE_MACHINE_DATA).thenApply(v -> STATE_MACHINE_DATA);
    }

    public CompletableFuture<Void> flush(long index) {
        return this.blocking.getFuture(Blocking.Type.FLUSH_STATE_MACHINE_DATA);
    }

    public void close() {
        this.getLifeCycle().checkStateAndClose(() -> {
            this.running = false;
            this.checkpointer.interrupt();
        });
    }

    public RaftProtos.LogEntryProto[] getContent() {
        return this.indexMap.values().toArray(new RaftProtos.LogEntryProto[0]);
    }

    public void blockStartTransaction() {
        this.blocking.block(Blocking.Type.START_TRANSACTION);
    }

    public void unblockStartTransaction() {
        this.blocking.unblock(Blocking.Type.START_TRANSACTION);
    }

    public void blockWriteStateMachineData() {
        this.blocking.block(Blocking.Type.WRITE_STATE_MACHINE_DATA);
    }

    public void unblockWriteStateMachineData() {
        this.blocking.unblock(Blocking.Type.WRITE_STATE_MACHINE_DATA);
    }

    public void blockFlushStateMachineData() {
        this.blocking.block(Blocking.Type.FLUSH_STATE_MACHINE_DATA);
    }

    public void unblockFlushStateMachineData() {
        this.blocking.unblock(Blocking.Type.FLUSH_STATE_MACHINE_DATA);
    }

    public void notifyFollowerSlowness(RaftProtos.RoleInfoProto roleInfoProto) {
        LOG.info("{}: notifySlowness {}, {}", new Object[]{this, this.groupId, roleInfoProto});
        this.slownessInfo = roleInfoProto;
    }

    public void notifyExtendedNoLeader(RaftProtos.RoleInfoProto roleInfoProto) {
        LOG.info("{}: notifyExtendedNoLeader {}, {}", new Object[]{this, this.groupId, roleInfoProto});
        this.leaderElectionTimeoutInfo = roleInfoProto;
    }

    public void notifyLeaderChanged(RaftGroupMemberId groupMemberId, RaftPeerId raftPeerId) {
        if (groupMemberId.getPeerId().equals((Object)raftPeerId)) {
            this.notifiedAsLeader = true;
        }
    }

    public boolean isNotifiedAsLeader() {
        return this.notifiedAsLeader;
    }

    protected File getSMdir() {
        return this.storage.getSmDir();
    }

    static class Blocking {
        private final EnumMap<Type, CompletableFuture<Void>> maps = new EnumMap(Type.class);

        Blocking() {
        }

        void block(Type type) {
            LOG.info("block {}", (Object)type);
            CompletableFuture future = new CompletableFuture();
            CompletableFuture previous = this.maps.putIfAbsent(type, future);
            Preconditions.assertNull(previous, (String)"previous");
        }

        void unblock(Type type) {
            LOG.info("unblock {}", (Object)type);
            CompletableFuture<Void> future = this.maps.remove((Object)type);
            Objects.requireNonNull(future, "future == null");
            future.complete(null);
        }

        CompletableFuture<Void> getFuture(Type type) {
            return this.maps.getOrDefault((Object)type, CompletableFuture.completedFuture(null));
        }

        void await(Type type) {
            try {
                this.getFuture(type).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Failed to await " + (Object)((Object)type), e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Failed to await " + (Object)((Object)type), e);
            }
        }

        static enum Type {
            START_TRANSACTION,
            READ_STATE_MACHINE_DATA,
            WRITE_STATE_MACHINE_DATA,
            FLUSH_STATE_MACHINE_DATA;

        }
    }

    public static class Collecting {
        private final EnumMap<Type, BlockingQueue<Runnable>> map = new EnumMap(Type.class);

        BlockingQueue<Runnable> get(Type type) {
            return this.map.get((Object)type);
        }

        public BlockingQueue<Runnable> enable(Type type) {
            LinkedBlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
            BlockingQueue previous = this.map.put(type, q);
            Preconditions.assertNull((Object)previous, (String)"previous");
            return q;
        }

        <T> CompletableFuture<T> collect(Type type, T value) {
            BlockingQueue<Runnable> q = this.get(type);
            if (q == null) {
                return CompletableFuture.completedFuture(value);
            }
            CompletableFuture future = new CompletableFuture();
            boolean offered = q.offer(() -> future.complete(value));
            Preconditions.assertTrue((boolean)offered);
            return future;
        }

        public static enum Type {
            APPLY_TRANSACTION;

        }
    }
}

