/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.PendingStepDown;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingStepDown {
    public static final Logger LOG = LoggerFactory.getLogger(PendingStepDown.class);
    private final LeaderStateImpl leader;
    private final TimeoutScheduler scheduler = TimeoutScheduler.getInstance();
    private final PendingRequestReference pending = new PendingRequestReference();

    PendingStepDown(LeaderStateImpl leaderState) {
        this.leader = leaderState;
    }

    CompletableFuture<RaftClientReply> submitAsync(TransferLeadershipRequest request) {
        Preconditions.assertNull((Object)request.getNewLeader(), (String)"request.getNewLeader()");
        MemoizedSupplier supplier = JavaUtils.memoize(() -> new PendingRequest(this, request));
        PendingRequest previous = this.pending.getAndUpdate((Supplier)supplier);
        if (previous != null) {
            return previous.getReplyFuture();
        }
        this.leader.submitStepDownEvent(LeaderState.StepDownReason.FORCE);
        this.scheduler.onTimeout(TimeDuration.valueOf((long)request.getTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS), () -> this.timeout(), LOG, () -> "Timeout check failed for step down leader request: " + request);
        return ((PendingRequest)supplier.get()).getReplyFuture();
    }

    void complete(Function<TransferLeadershipRequest, RaftClientReply> newSuccessReply) {
        this.pending.getAndSetNull().ifPresent(p -> p.complete(newSuccessReply));
    }

    void timeout() {
        this.pending.getAndSetNull().ifPresent(PendingRequest::timeout);
    }

    static /* synthetic */ LeaderStateImpl access$000(PendingStepDown x0) {
        return x0.leader;
    }
}

