/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.util.Preconditions;

final class RaftConfigurationImpl
implements RaftConfiguration {
    private final PeerConfiguration oldConf;
    private final PeerConfiguration conf;
    private final long logEntryIndex;

    static Builder newBuilder() {
        return new Builder(null);
    }

    private RaftConfigurationImpl(PeerConfiguration conf, PeerConfiguration oldConf, long logEntryIndex) {
        this.conf = Objects.requireNonNull(conf);
        this.oldConf = oldConf;
        this.logEntryIndex = logEntryIndex;
    }

    boolean isTransitional() {
        return this.oldConf != null;
    }

    boolean isStable() {
        return this.oldConf == null;
    }

    boolean containsInConf(RaftPeerId peerId, RaftProtos.RaftPeerRole ... roles) {
        if (roles == null || roles.length == 0) {
            return this.conf.contains(peerId);
        }
        if (roles.length == 1) {
            return this.conf.contains(peerId, roles[0]);
        }
        return this.conf.contains(peerId, EnumSet.of(roles[0], roles)) != null;
    }

    boolean isHighestPriority(RaftPeerId peerId) {
        RaftPeer target = this.getPeer(peerId, new RaftProtos.RaftPeerRole[0]);
        if (target == null) {
            return false;
        }
        Collection peers = this.getCurrentPeers();
        for (RaftPeer peer : peers) {
            if (peer.getPriority() < target.getPriority() || peer.equals((Object)target)) continue;
            return false;
        }
        return true;
    }

    boolean containsInOldConf(RaftPeerId peerId) {
        return this.oldConf != null && this.oldConf.contains(peerId);
    }

    boolean containsInBothConfs(RaftPeerId peerId) {
        return this.containsInConf(peerId, new RaftProtos.RaftPeerRole[0]) && (this.oldConf == null || this.containsInOldConf(peerId));
    }

    public RaftPeer getPeer(RaftPeerId id, RaftProtos.RaftPeerRole ... roles) {
        if (id == null) {
            return null;
        }
        RaftPeer peer = this.conf.getPeer(id, roles);
        if (peer != null) {
            return peer;
        }
        if (this.oldConf != null) {
            return this.oldConf.getPeer(id, roles);
        }
        return null;
    }

    public Collection<RaftPeer> getAllPeers(RaftProtos.RaftPeerRole role) {
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>(this.conf.getPeers(role));
        if (this.oldConf != null) {
            this.oldConf.getPeers(role).stream().filter(p -> !peers.contains(p)).forEach(peers::add);
        }
        return peers;
    }

    Collection<RaftPeer> getOtherPeers(RaftPeerId selfId) {
        List others = this.conf.getOtherPeers(selfId);
        if (this.oldConf != null) {
            this.oldConf.getOtherPeers(selfId).stream().filter(p -> !others.contains(p)).forEach(others::add);
        }
        return others;
    }

    boolean hasMajority(Collection<RaftPeerId> others, RaftPeerId selfId) {
        Preconditions.assertTrue((!others.contains(selfId) ? 1 : 0) != 0);
        return this.conf.hasMajority(others, selfId) && (this.oldConf == null || this.oldConf.hasMajority(others, selfId));
    }

    boolean majorityRejectVotes(Collection<RaftPeerId> rejects) {
        return this.conf.majorityRejectVotes(rejects) || this.oldConf != null && this.oldConf.majorityRejectVotes(rejects);
    }

    public String toString() {
        return this.logEntryIndex + ": " + this.conf + ", old=" + this.oldConf;
    }

    boolean hasNoChange(Collection<RaftPeer> newMembers) {
        if (!this.isStable() || this.conf.size() != newMembers.size()) {
            return false;
        }
        for (RaftPeer peer : newMembers) {
            if (this.conf.contains(peer.getId()) && this.conf.getPeer(peer.getId(), new RaftProtos.RaftPeerRole[0]).getPriority() == peer.getPriority()) continue;
            return false;
        }
        return true;
    }

    public long getLogEntryIndex() {
        return this.logEntryIndex;
    }

    Collection<RaftPeer> filterNotContainedInConf(List<RaftPeer> peers) {
        return peers.stream().filter(p -> !this.containsInConf(p.getId(), new RaftProtos.RaftPeerRole[]{RaftProtos.RaftPeerRole.FOLLOWER, RaftProtos.RaftPeerRole.LISTENER})).collect(Collectors.toList());
    }

    public Collection<RaftPeer> getPreviousPeers(RaftProtos.RaftPeerRole role) {
        return this.oldConf != null ? this.oldConf.getPeers(role) : Collections.emptyList();
    }

    public Collection<RaftPeer> getCurrentPeers(RaftProtos.RaftPeerRole role) {
        return this.conf.getPeers(role);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RaftConfigurationImpl that = (RaftConfigurationImpl)obj;
        return this.logEntryIndex == that.logEntryIndex && Objects.equals(this.conf, that.conf) && Objects.equals(this.oldConf, that.oldConf);
    }

    public int hashCode() {
        return Long.hashCode(this.logEntryIndex);
    }

    static /* synthetic */ PeerConfiguration access$100(RaftConfigurationImpl x0) {
        return x0.conf;
    }
}

