/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.server.impl.RetryCacheImpl;
import org.apache.ratis.thirdparty.com.google.common.cache.Cache;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;

class RetryCacheImpl
implements RetryCache {
    private final Cache<ClientInvocationId, CacheEntry> cache;
    private final AtomicReference<StatisticsImpl> statistics = new AtomicReference();
    private final TimeDuration statisticsExpiryTime;

    RetryCacheImpl(RaftProperties properties) {
        this(RaftServerConfigKeys.RetryCache.expiryTime((RaftProperties)properties), RaftServerConfigKeys.RetryCache.statisticsExpiryTime((RaftProperties)properties));
    }

    RetryCacheImpl(TimeDuration cacheExpiryTime, TimeDuration statisticsExpiryTime) {
        this.cache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(cacheExpiryTime.getDuration(), cacheExpiryTime.getUnit()).build();
        this.statisticsExpiryTime = statisticsExpiryTime;
    }

    CacheEntry getOrCreateEntry(ClientInvocationId key) {
        CacheEntry entry;
        try {
            entry = (CacheEntry)this.cache.get((Object)key, () -> new CacheEntry(key));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        return entry;
    }

    CacheEntry refreshEntry(CacheEntry newEntry) {
        this.cache.put((Object)newEntry.getKey(), (Object)newEntry);
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheQueryResult queryCache(ClientInvocationId key) {
        CacheEntry cacheEntry;
        CacheEntry newEntry = new CacheEntry(key);
        try {
            cacheEntry = (CacheEntry)this.cache.get((Object)key, () -> newEntry);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        if (cacheEntry == newEntry) {
            return new CacheQueryResult(cacheEntry, false);
        }
        if (!cacheEntry.isDone() || !cacheEntry.isFailed()) {
            return new CacheQueryResult(cacheEntry, true);
        }
        RetryCacheImpl retryCacheImpl = this;
        synchronized (retryCacheImpl) {
            CacheEntry currentEntry = (CacheEntry)this.cache.getIfPresent((Object)key);
            if (currentEntry == cacheEntry || currentEntry == null) {
                return new CacheQueryResult(this.refreshEntry(newEntry), false);
            }
            return new CacheQueryResult(currentEntry, true);
        }
    }

    public RetryCache.Statistics getStatistics() {
        return (RetryCache.Statistics)this.statistics.updateAndGet(old -> old == null || old.isExpired() ? new StatisticsImpl(this, this.cache) : old);
    }

    public CacheEntry getIfPresent(ClientInvocationId key) {
        return (CacheEntry)this.cache.getIfPresent((Object)key);
    }

    public synchronized void close() {
        if (this.cache != null) {
            this.cache.invalidateAll();
            this.statistics.set(null);
        }
    }

    static CompletableFuture<RaftClientReply> failWithReply(RaftClientReply reply, CacheEntry entry) {
        if (entry != null) {
            entry.failWithReply(reply);
            return entry.getReplyFuture();
        }
        return CompletableFuture.completedFuture(reply);
    }

    static CompletableFuture<RaftClientReply> failWithException(Throwable t, CacheEntry entry) {
        if (entry != null) {
            entry.failWithException(t);
            return entry.getReplyFuture();
        }
        return JavaUtils.completeExceptionally((Throwable)t);
    }

    static /* synthetic */ TimeDuration access$000(RetryCacheImpl x0) {
        return x0.statisticsExpiryTime;
    }
}

