/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.ConfigurationManager;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.StateMachineUpdater;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.memory.MemoryRaftLog;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.server.storage.SnapshotManager;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

/*
 * Exception performing whole class analysis ignored.
 */
class ServerState
implements Closeable {
    private final RaftGroupMemberId memberId;
    private final RaftServerImpl server;
    private final RaftLog log;
    private final ConfigurationManager configurationManager;
    private final StateMachineUpdater stateMachineUpdater;
    private RaftStorageImpl storage;
    private final SnapshotManager snapshotManager;
    private volatile Timestamp lastNoLeaderTime;
    private final TimeDuration noLeaderTimeout;
    private final AtomicLong currentTerm = new AtomicLong();
    private volatile RaftPeerId leaderId;
    private volatile RaftPeerId votedFor;
    private final AtomicReference<TermIndex> latestInstalledSnapshot = new AtomicReference();

    ServerState(RaftPeerId id, RaftGroup group, RaftProperties prop, RaftServerImpl server, StateMachine stateMachine) throws IOException {
        this.memberId = RaftGroupMemberId.valueOf((RaftPeerId)id, (RaftGroupId)group.getGroupId());
        this.server = server;
        RaftConfigurationImpl initialConf = RaftConfigurationImpl.newBuilder().setConf((Iterable)group.getPeers()).build();
        this.configurationManager = new ConfigurationManager(initialConf);
        RaftServer.Division.LOG.info("{}: {}", (Object)this.getMemberId(), (Object)this.configurationManager);
        boolean storageFound = false;
        List directories = RaftServerConfigKeys.storageDir((RaftProperties)prop);
        while (!directories.isEmpty()) {
            File dir = ServerState.chooseStorageDir((List)directories, (String)group.getGroupId().getUuid().toString());
            try {
                this.storage = new RaftStorageImpl(dir, RaftServerConfigKeys.Log.corruptionPolicy((RaftProperties)prop), RaftServerConfigKeys.storageFreeSpaceMin((RaftProperties)prop).getSize());
                storageFound = true;
                break;
            }
            catch (IOException e) {
                if (e.getCause() instanceof OverlappingFileLockException) {
                    throw e;
                }
                RaftServer.Division.LOG.warn("Failed to init RaftStorage under {} for {}: {}", new Object[]{dir.getParent(), group.getGroupId().getUuid().toString(), e});
                directories.removeIf(d -> d.getAbsolutePath().equals(dir.getParent()));
            }
        }
        if (!storageFound) {
            throw new IOException("No healthy directories found for RaftStorage among: " + RaftServerConfigKeys.storageDir((RaftProperties)prop));
        }
        this.snapshotManager = new SnapshotManager((RaftStorage)this.storage, id);
        stateMachine.initialize((RaftServer)server.getRaftServer(), group.getGroupId(), (RaftStorage)this.storage);
        Optional.ofNullable(this.storage.readRaftConfiguration()).ifPresent(arg_0 -> this.setRaftConf(arg_0));
        this.leaderId = null;
        this.lastNoLeaderTime = Timestamp.currentTime();
        this.noLeaderTimeout = RaftServerConfigKeys.Notification.noLeaderTimeout((RaftProperties)prop);
        LongSupplier getSnapshotIndexFromStateMachine = () -> Optional.ofNullable(stateMachine.getLatestSnapshot()).map(SnapshotInfo::getIndex).filter(i -> i >= 0L).orElse(-1L);
        this.log = ServerState.initRaftLog((RaftGroupMemberId)this.getMemberId(), (RaftServerImpl)server, (RaftStorage)this.storage, arg_0 -> this.setRaftConf(arg_0), (LongSupplier)getSnapshotIndexFromStateMachine, (RaftProperties)prop);
        RaftStorageMetadata metadata = this.log.loadMetadata();
        this.currentTerm.set(metadata.getTerm());
        this.votedFor = metadata.getVotedFor();
        this.stateMachineUpdater = new StateMachineUpdater(stateMachine, server, this, this.log.getSnapshotIndex(), prop);
    }

    RaftGroupMemberId getMemberId() {
        return this.memberId;
    }

    static File chooseStorageDir(List<File> volumes, String targetSubDir) throws IOException {
        HashMap numberOfStorageDirPerVolume = new HashMap();
        File[] empty = new File[]{};
        ArrayList resultList = new ArrayList();
        volumes.stream().flatMap(volume -> {
            File[] dirs = Optional.ofNullable(volume.listFiles()).orElse(empty);
            numberOfStorageDirPerVolume.put(volume, dirs.length);
            return Arrays.stream(dirs);
        }).filter(dir -> targetSubDir.equals(dir.getName())).forEach(resultList::add);
        if (resultList.size() > 1) {
            throw new IOException("More than one directories found for " + targetSubDir + ": " + resultList);
        }
        if (resultList.size() == 1) {
            return (File)resultList.get(0);
        }
        return numberOfStorageDirPerVolume.entrySet().stream().min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(v -> new File((File)v, targetSubDir)).orElseThrow(() -> new IOException("No storage directory found."));
    }

    void writeRaftConfiguration(RaftProtos.LogEntryProto conf) {
        this.storage.writeRaftConfiguration(conf);
    }

    void start() {
        this.stateMachineUpdater.start();
    }

    private static RaftLog initRaftLog(RaftGroupMemberId memberId, RaftServerImpl server, RaftStorage storage, Consumer<RaftProtos.LogEntryProto> logConsumer, LongSupplier getSnapshotIndexFromStateMachine, RaftProperties prop) throws IOException {
        Object log = RaftServerConfigKeys.Log.useMemory((RaftProperties)prop) ? new MemoryRaftLog(memberId, getSnapshotIndexFromStateMachine, prop) : new SegmentedRaftLog(memberId, (RaftServer.Division)server, server.getStateMachine(), arg_0 -> ((RaftServerImpl)server).notifyTruncatedLogEntry(arg_0), () -> ((RaftServerImpl)server).submitUpdateCommitEvent(), storage, getSnapshotIndexFromStateMachine, prop);
        log.open(log.getSnapshotIndex(), logConsumer);
        return log;
    }

    RaftConfigurationImpl getRaftConf() {
        return this.configurationManager.getCurrent();
    }

    long getCurrentTerm() {
        return this.currentTerm.get();
    }

    boolean updateCurrentTerm(long newTerm) {
        long current = this.currentTerm.getAndUpdate(curTerm -> Math.max(curTerm, newTerm));
        if (newTerm > current) {
            this.votedFor = null;
            this.setLeader(null, (Object)"updateCurrentTerm");
            return true;
        }
        return false;
    }

    RaftPeerId getLeaderId() {
        return this.leaderId;
    }

    boolean hasLeader() {
        return this.leaderId != null;
    }

    LeaderElection.ConfAndTerm initElection(LeaderElection.Phase phase) throws IOException {
        long term;
        this.setLeader(null, (Object)phase);
        if (phase == LeaderElection.Phase.PRE_VOTE) {
            term = this.getCurrentTerm();
        } else if (phase == LeaderElection.Phase.ELECTION) {
            term = this.currentTerm.incrementAndGet();
            this.votedFor = this.getMemberId().getPeerId();
            this.persistMetadata();
        } else {
            throw new IllegalArgumentException("Unexpected phase " + phase);
        }
        return new LeaderElection.ConfAndTerm(this.getRaftConf(), term);
    }

    void persistMetadata() throws IOException {
        this.log.persistMetadata(RaftStorageMetadata.valueOf((long)this.currentTerm.get(), (RaftPeerId)this.votedFor));
    }

    RaftPeerId getVotedFor() {
        return this.votedFor;
    }

    void grantVote(RaftPeerId candidateId) {
        this.votedFor = candidateId;
        this.setLeader(null, (Object)"grantVote");
    }

    void setLeader(RaftPeerId newLeaderId, Object op) {
        if (!Objects.equals(this.leaderId, newLeaderId)) {
            String suffix;
            if (newLeaderId == null) {
                this.lastNoLeaderTime = Timestamp.currentTime();
                suffix = "";
            } else {
                Timestamp previous = this.lastNoLeaderTime;
                this.lastNoLeaderTime = null;
                suffix = ", leader elected after " + previous.elapsedTimeMs() + "ms";
                this.server.getStateMachine().event().notifyLeaderChanged(this.getMemberId(), newLeaderId);
            }
            RaftServer.Division.LOG.info("{}: change Leader from {} to {} at term {} for {}{}", new Object[]{this.getMemberId(), this.leaderId, newLeaderId, this.getCurrentTerm(), op, suffix});
            this.leaderId = newLeaderId;
            if (this.leaderId != null) {
                this.server.finishTransferLeadership();
            }
        }
    }

    boolean shouldNotifyExtendedNoLeader() {
        return Optional.ofNullable(this.lastNoLeaderTime).map(Timestamp::elapsedTime).filter(t -> t.compareTo(this.noLeaderTimeout) > 0).isPresent();
    }

    long getLastLeaderElapsedTimeMs() {
        return Optional.ofNullable(this.lastNoLeaderTime).map(Timestamp::elapsedTimeMs).orElse(0L);
    }

    void becomeLeader() {
        this.setLeader(this.getMemberId().getPeerId(), (Object)"becomeLeader");
    }

    RaftLog getLog() {
        return this.log;
    }

    TermIndex getLastEntry() {
        SnapshotInfo snapshot;
        TermIndex lastEntry = this.getLog().getLastEntryTermIndex();
        if (lastEntry == null && (snapshot = this.getLatestSnapshot()) != null) {
            lastEntry = snapshot.getTermIndex();
        }
        return lastEntry;
    }

    void appendLog(TransactionContext operation) throws StateMachineException {
        this.log.append(this.currentTerm.get(), operation);
        Objects.requireNonNull(operation.getLogEntry());
    }

    boolean recognizeLeader(RaftPeerId peerLeaderId, long leaderTerm) {
        long current = this.currentTerm.get();
        if (leaderTerm < current) {
            return false;
        }
        if (leaderTerm > current || this.leaderId == null) {
            return true;
        }
        return this.leaderId.equals((Object)peerLeaderId);
    }

    static int compareLog(TermIndex lastEntry, TermIndex candidateLastEntry) {
        if (lastEntry == null) {
            if (candidateLastEntry == null || candidateLastEntry.getTerm() == 0L && candidateLastEntry.getIndex() == 0L) {
                return 0;
            }
            return -1;
        }
        if (candidateLastEntry == null) {
            return 1;
        }
        return lastEntry.compareTo(candidateLastEntry);
    }

    public String toString() {
        return this.getMemberId() + ":t" + this.currentTerm + ", leader=" + this.leaderId + ", voted=" + this.votedFor + ", raftlog=" + this.log + ", conf=" + this.getRaftConf();
    }

    boolean isConfCommitted() {
        return this.getLog().getLastCommittedIndex() >= this.getRaftConf().getLogEntryIndex();
    }

    void setRaftConf(RaftProtos.LogEntryProto entry) {
        if (entry.hasConfigurationEntry()) {
            this.setRaftConf(LogProtoUtils.toRaftConfiguration((RaftProtos.LogEntryProto)entry));
        }
    }

    void setRaftConf(RaftConfiguration conf) {
        this.configurationManager.addConfiguration(conf);
        this.server.getServerRpc().addRaftPeers(conf.getAllPeers());
        Collection listeners = conf.getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
        if (!listeners.isEmpty()) {
            this.server.getServerRpc().addRaftPeers(listeners);
        }
        RaftServer.Division.LOG.info("{}: set configuration {}", (Object)this.getMemberId(), (Object)conf);
        RaftServer.Division.LOG.trace("{}: {}", (Object)this.getMemberId(), (Object)this.configurationManager);
    }

    void updateConfiguration(RaftProtos.LogEntryProto[] entries) {
        if (entries != null && entries.length > 0) {
            this.configurationManager.removeConfigurations(entries[0].getIndex());
            Arrays.stream(entries).forEach(arg_0 -> this.setRaftConf(arg_0));
        }
    }

    boolean updateCommitIndex(long majorityIndex, long curTerm, boolean isLeader) {
        if (this.log.updateCommitIndex(majorityIndex, curTerm, isLeader)) {
            this.stateMachineUpdater.notifyUpdater();
            return true;
        }
        return false;
    }

    void notifyStateMachineUpdater() {
        this.stateMachineUpdater.notifyUpdater();
    }

    void reloadStateMachine(long lastIndexInSnapshot) {
        this.log.updateSnapshotIndex(lastIndexInSnapshot);
        this.stateMachineUpdater.reloadStateMachine();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stateMachineUpdater.stopAndJoin();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            RaftServer.Division.LOG.warn("{}: Interrupted when joining stateMachineUpdater", (Object)this.getMemberId(), (Object)e);
        }
        RaftServer.Division.LOG.info("{}: closes. applyIndex: {}", (Object)this.getMemberId(), (Object)this.getLastAppliedIndex());
        this.log.close();
        this.storage.close();
    }

    RaftStorage getStorage() {
        return this.storage;
    }

    void installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        StateMachine sm = this.server.getStateMachine();
        sm.pause();
        this.snapshotManager.installSnapshot(sm, request);
        this.updateInstalledSnapshotIndex(TermIndex.valueOf((RaftProtos.TermIndexProto)request.getSnapshotChunk().getTermIndex()));
    }

    void updateInstalledSnapshotIndex(TermIndex lastTermIndexInSnapshot) {
        this.log.onSnapshotInstalled(lastTermIndexInSnapshot.getIndex());
        this.latestInstalledSnapshot.set(lastTermIndexInSnapshot);
    }

    private SnapshotInfo getLatestSnapshot() {
        return this.server.getStateMachine().getLatestSnapshot();
    }

    long getLatestInstalledSnapshotIndex() {
        TermIndex ti = (TermIndex)this.latestInstalledSnapshot.get();
        return ti != null ? ti.getIndex() : -1L;
    }

    long getSnapshotIndex() {
        SnapshotInfo s = this.getLatestSnapshot();
        long latestSnapshotIndex = s != null ? s.getIndex() : -1L;
        return Math.max(latestSnapshotIndex, this.getLatestInstalledSnapshotIndex());
    }

    long getNextIndex() {
        long logNextIndex = this.log.getNextIndex();
        long snapshotNextIndex = this.log.getSnapshotIndex() + 1L;
        return Math.max(logNextIndex, snapshotNextIndex);
    }

    long getLastAppliedIndex() {
        return this.stateMachineUpdater.getStateMachineLastAppliedIndex();
    }

    boolean containsTermIndex(TermIndex ti) {
        Objects.requireNonNull(ti, "ti == null");
        if (Optional.ofNullable(this.latestInstalledSnapshot.get()).filter(ti::equals).isPresent()) {
            return true;
        }
        if (Optional.ofNullable(this.getLatestSnapshot()).map(SnapshotInfo::getTermIndex).filter(ti::equals).isPresent()) {
            return true;
        }
        return this.log.contains(ti);
    }
}

