/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.io.InterruptedIOException;
import java.util.function.UnaryOperator;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogAppenderDaemon {
    public static final Logger LOG = LoggerFactory.getLogger(LogAppenderDaemon.class);
    private final String name;
    private final LifeCycle lifeCycle;
    private final Daemon daemon;
    private final LogAppender logAppender;
    static final UnaryOperator<LifeCycle.State> TRY_TO_RUN = current -> {
        if (current == LifeCycle.State.STARTING) {
            return LifeCycle.State.RUNNING;
        }
        if (LifeCycle.States.CLOSING_OR_CLOSED_OR_EXCEPTION.contains(current)) {
            return current;
        }
        throw new IllegalArgumentException("Cannot to tryToRun from " + current);
    };
    static final UnaryOperator<LifeCycle.State> TRANSITION_FINALLY = current -> {
        if (LifeCycle.State.isValid((LifeCycle.State)current, (LifeCycle.State)LifeCycle.State.CLOSED)) {
            return LifeCycle.State.CLOSED;
        }
        if (LifeCycle.State.isValid((LifeCycle.State)current, (LifeCycle.State)LifeCycle.State.EXCEPTION)) {
            return LifeCycle.State.EXCEPTION;
        }
        return current;
    };
    static final UnaryOperator<LifeCycle.State> TRY_TO_CLOSE = current -> {
        if (current == LifeCycle.State.NEW) {
            return LifeCycle.State.CLOSED;
        }
        if (current.isClosingOrClosed()) {
            return current;
        }
        if (LifeCycle.State.isValid((LifeCycle.State)current, (LifeCycle.State)LifeCycle.State.CLOSING)) {
            return LifeCycle.State.CLOSING;
        }
        throw new IllegalArgumentException("Cannot to tryToClose from " + current);
    };

    LogAppenderDaemon(LogAppender logAppender) {
        this.logAppender = logAppender;
        this.name = logAppender + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.lifeCycle = new LifeCycle((Object)this.name);
        this.daemon = new Daemon(() -> this.run(), this.name);
    }

    public boolean isWorking() {
        return !LifeCycle.States.CLOSING_OR_CLOSED_OR_EXCEPTION.contains(this.lifeCycle.getCurrentState());
    }

    public void tryToStart() {
        if (this.lifeCycle.compareAndTransition(LifeCycle.State.NEW, LifeCycle.State.STARTING)) {
            this.daemon.start();
        }
    }

    private void run() {
        try {
            if (this.lifeCycle.transition(TRY_TO_RUN) == LifeCycle.State.RUNNING) {
                this.logAppender.run();
            }
            this.lifeCycle.compareAndTransition(LifeCycle.State.RUNNING, LifeCycle.State.CLOSING);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info(this + " was interrupted: " + e);
        }
        catch (InterruptedIOException e) {
            LOG.info(this + " I/O was interrupted: " + e);
        }
        catch (Throwable e) {
            LOG.error(this + " failed", e);
            this.lifeCycle.transitionIfValid(LifeCycle.State.EXCEPTION);
        }
        finally {
            if (this.lifeCycle.transitionAndGet(TRANSITION_FINALLY) == LifeCycle.State.EXCEPTION) {
                this.logAppender.getLeaderState().restart(this.logAppender);
            }
        }
    }

    public void tryToClose() {
        if (this.lifeCycle.transition(TRY_TO_CLOSE) == LifeCycle.State.CLOSING) {
            this.daemon.interrupt();
        }
    }

    public String toString() {
        return this.name;
    }
}

