/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.function.CheckedBiFunction;

class BufferedWriteChannel
implements Closeable {
    private final FileChannel fileChannel;
    private final ByteBuffer writeBuffer;
    private boolean forced = true;

    static BufferedWriteChannel open(File file, boolean append, ByteBuffer buffer) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel fc = raf.getChannel();
        if (append) {
            fc.position(fc.size());
        } else {
            fc.truncate(0L);
        }
        Preconditions.assertSame((long)fc.size(), (long)fc.position(), (String)"fc.position");
        return new BufferedWriteChannel(fc, buffer);
    }

    BufferedWriteChannel(FileChannel fileChannel, ByteBuffer byteBuffer) {
        this.fileChannel = fileChannel;
        this.writeBuffer = byteBuffer;
    }

    void write(byte[] b) throws IOException {
        int toPut;
        for (int offset = 0; offset < b.length; offset += toPut) {
            toPut = Math.min(b.length - offset, this.writeBuffer.remaining());
            this.writeBuffer.put(b, offset, toPut);
            if (this.writeBuffer.remaining() != 0) continue;
            this.flushBuffer();
        }
    }

    void preallocateIfNecessary(long size, CheckedBiFunction<FileChannel, Long, Long, IOException> preallocate) throws IOException {
        long outstanding = (long)this.writeBuffer.position() + size;
        if (this.fileChannel.position() + outstanding > this.fileChannel.size()) {
            preallocate.apply((Object)this.fileChannel, (Object)outstanding);
        }
    }

    void flush() throws IOException {
        this.flushBuffer();
        if (!this.forced) {
            this.fileChannel.force(false);
            this.forced = true;
        }
    }

    CompletableFuture<Void> asyncFlush(ExecutorService executor) throws IOException {
        this.flushBuffer();
        if (this.forced) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> f = CompletableFuture.supplyAsync(() -> this.fileChannelForce(), executor);
        this.forced = true;
        return f;
    }

    private Void fileChannelForce() {
        try {
            this.fileChannel.force(false);
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
        return null;
    }

    private void flushBuffer() throws IOException {
        if (this.writeBuffer.position() == 0) {
            return;
        }
        this.writeBuffer.flip();
        do {
            this.fileChannel.write(this.writeBuffer);
        } while (this.writeBuffer.hasRemaining());
        this.writeBuffer.clear();
        this.forced = false;
    }

    boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.fileChannel.truncate(this.fileChannel.position());
        }
        finally {
            this.fileChannel.close();
        }
    }
}

