/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.server.storage.RaftStorageDirectoryImpl;
import org.apache.ratis.util.AtomicFileOutputStream;
import org.apache.ratis.util.FileUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class RaftStorageDirectoryImpl
implements RaftStorageDirectory {
    private static final String IN_USE_LOCK_NAME = "in_use.lock";
    private static final String META_FILE_NAME = "raft-meta";
    private static final String CONF_EXTENSION = ".conf";
    private final File root;
    private FileLock lock;
    private long freeSpaceMin;

    RaftStorageDirectoryImpl(File dir, long freeSpaceMin) {
        this.root = dir;
        this.lock = null;
        this.freeSpaceMin = freeSpaceMin;
    }

    public File getRoot() {
        return this.root;
    }

    void clearDirectory() throws IOException {
        RaftStorageDirectoryImpl.clearDirectory((File)this.getCurrentDir());
        RaftStorageDirectoryImpl.clearDirectory((File)this.getStateMachineDir());
    }

    private static void clearDirectory(File dir) throws IOException {
        if (dir.exists()) {
            LOG.info(dir + " already exists.  Deleting it ...");
            FileUtils.deleteFully((File)dir);
        }
        FileUtils.createDirectories((File)dir);
    }

    File getMetaFile() {
        return new File(this.getCurrentDir(), "raft-meta");
    }

    File getMetaTmpFile() {
        return AtomicFileOutputStream.getTemporaryFile((File)this.getMetaFile());
    }

    File getMetaConfFile() {
        return new File(this.getCurrentDir(), "raft-meta.conf");
    }

    boolean isCurrentEmpty() throws IOException {
        File currentDir = this.getCurrentDir();
        if (!currentDir.exists()) {
            return true;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(currentDir.toPath());){
            if (dirStream.iterator().hasNext()) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    StorageState analyzeStorage(boolean toLock) throws IOException {
        Objects.requireNonNull(this.root, "root directory is null");
        String rootPath = this.root.getCanonicalPath();
        try {
            if (!this.root.exists()) {
                LOG.info("The storage directory " + rootPath + " does not exist. Creating ...");
                FileUtils.createDirectories((File)this.root);
            }
            if (!this.root.isDirectory()) {
                LOG.warn(rootPath + " is not a directory");
                return StorageState.NON_EXISTENT;
            }
            if (!Files.isWritable(this.root.toPath())) {
                LOG.warn("The storage directory " + rootPath + " is not writable.");
                return StorageState.NON_EXISTENT;
            }
        }
        catch (SecurityException ex) {
            LOG.warn("Cannot access storage directory " + rootPath, (Throwable)ex);
            return StorageState.NON_EXISTENT;
        }
        if (toLock) {
            this.lock();
        }
        if (!this.hasEnoughSpace()) {
            LOG.warn("There are not enough space left for directory " + rootPath + " free space min required: " + this.freeSpaceMin + " free space actual: " + this.root.getFreeSpace());
            return StorageState.NO_SPACE;
        }
        if (this.isHealthy()) {
            return StorageState.NORMAL;
        }
        return StorageState.NOT_FORMATTED;
    }

    public boolean isHealthy() {
        return this.getMetaFile().exists();
    }

    private boolean hasEnoughSpace() {
        return this.root.getFreeSpace() > this.freeSpaceMin;
    }

    void lock() throws IOException {
        File lockF = new File(this.root, "in_use.lock");
        FileLock newLock = (FileLock)FileUtils.attempt(() -> this.tryLock(lockF), () -> "tryLock " + lockF);
        if (newLock == null) {
            String msg = "Cannot lock storage " + this.root + ". The directory is already locked";
            LOG.info(msg);
            throw new IOException(msg);
        }
        this.lock = newLock;
    }

    private FileLock tryLock(File lockF) throws IOException {
        FileLock res;
        boolean deletionHookAdded = false;
        if (!lockF.exists()) {
            lockF.deleteOnExit();
            deletionHookAdded = true;
        }
        RandomAccessFile file = new RandomAccessFile(lockF, "rws");
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        try {
            res = file.getChannel().tryLock();
            if (null == res) {
                LOG.error("Unable to acquire file lock on path " + lockF.toString());
                throw new OverlappingFileLockException();
            }
            file.write(jvmName.getBytes(StandardCharsets.UTF_8));
            LOG.info("Lock on " + lockF + " acquired by nodename " + jvmName);
        }
        catch (OverlappingFileLockException oe) {
            LOG.error("It appears that another process has already locked the storage directory: " + this.root, (Throwable)oe);
            file.close();
            throw new IOException("Failed to lock storage " + this.root + ". The directory is already locked", oe);
        }
        catch (IOException e) {
            LOG.error("Failed to acquire lock on " + lockF + ". If this storage directory is mounted via NFS, ensure that the appropriate nfs lock services are running.", (Throwable)e);
            file.close();
            throw e;
        }
        if (!deletionHookAdded) {
            lockF.deleteOnExit();
        }
        return res;
    }

    void unlock() throws IOException {
        if (this.lock == null) {
            return;
        }
        this.lock.release();
        this.lock.channel().close();
        this.lock = null;
    }

    public String toString() {
        return "Storage Directory " + this.root;
    }
}

